/*----------------------------------------------------------------------
   em.h - Velocis extension module control and prototypes

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef EM_H
#define EM_H

/* If the operating system doesn't offer dynamic loading of extension modules,
   or if we want to test with CodeCenter, or if we're profiling, static-link
   extension modules.
*/
#if defined(__SABER__) || defined(SCO)
#if !defined(STATIC_EXTMODS)
#define STATIC_EXTMODS          /* all extension modules are static-linked */
#endif
#endif

/* If compiling for AIX, extension modules have a single, privileged entry
   point.
*/
#if defined(AIX)
#define EXTMOD_ONE_ENTRY
#endif

#ifdef STATIC_EXTMODS
#define STATIC_EXTMOD_EADM
#define STATIC_EXTMOD_ERDM
#define STATIC_EXTMOD_SQL
#define STATIC_EXTMOD_DDLP
#define STATIC_EXTMOD_SDDLP
#define STATIC_EXTMOD_SCOLS
#define STATIC_EXTMOD_SUDF
#define STATIC_EXTMOD_SUDP
#define STATIC_EXTMOD_SIEF
#define STATIC_EXTMOD_MGEFILL
#define STATIC_EXTMOD_EMSQL
#define STATIC_EXTMOD_EM
#define STATIC_EXTMOD_UDF
#define STATIC_EXTMOD_RDM_EM
#define STATIC_EXTMOD_ROLLF
#endif


short REXTERNAL rm_emInit(void);

short REXTERNAL rm_emLoad(
    char *emName,
    short *modHandle
);

short REXTERNAL rm_emGetFcnAddr(
    short modHandle,
    char *fcnName,
    void **fcnAddr
);

short REXTERNAL rm_emUnload(
    short modHandle
);

#endif /* EM_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/EM.H_V   1.5   25 Aug 1994 09:44:42   BRADB  $
*/
