/*----------------------------------------------------------------------
   dberr.h -- text of error messages used by dberr function

   Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef DBERR_H
#define DBERR_H

/* dberr error/status messages */
static char *user_error[] = {
    "database not opened",
    "invalid set",
    "invalid record",
    "invalid database",
    "invalid field name",
    "invalid db_address",
    "no current record",
    "set has no current owner",
    "set has no current member",
    "key value required",
    "invalid database open mode or lock type",
    "record is owner of non-empty set(s)",
    "record is member of set(s)",
    "member already owned",
    "field is a compound key",
    "record not connected to set",
    "field is not a valid key",
    "record not legal owner of set",
    "record not legal member of set",
    "incompatible dictionary file",
    "illegal attempt to delete system record",
    "illegal attempt to access unlocked record/set",
    "transaction id not supplied",
    "transaction already active",
    "transaction not active",
    "cannot free locks within a transaction",
    "attempted transaction in no-trans mode",
    "exclusive access required",
    "unspecified or duplicate user id",
    "field is not an optional key field",
    "field is not defined in current record type",
    "record/field has/in a compound key",
    "invalid record or set number",
    "no current record type",
    "invalid country table sort string",
    "",
    "session or database handle is invalid",
    "database is unavailable",
    "no access rights to database",
    "the database is not registered in the catalog",
    "attempt to change read lock mode from within Tx",
    "buffer is not big enough to receive contents",
    "instance/table level locking conflict",
    "",
    "illegal attempt to downgrade a lock inside a Tx",
    "unable to locate a file",
    "catalog error",
    "Field contains invalid floating point value",
    "Field contains invalid double value",
    "Illegal function call from client",
    "no permission for Database operation",
    "A NULL pointer parameter has been provided",
    "Invalid table element requested",
    "Mark not found during d_trrollback",
    "Illegal attempt to write lock static entity",
    "Program(mer) error -- can't do operation, but otherwise OK to proceed",
    "Database file path too long",
    "Database opened in wrong mode for operation",
    "Need a record lock to connect/disconnect",
    "specified error handler not found"
};

#define N_DBERRS (sizeof(user_error) / sizeof(char *))

/* dberr system error/status messages  (-900...) */
static char *system_error[] = {
    "available disk space below minimum threshold"
};

#define N_SYSERRS (sizeof(system_error) / sizeof(char *))

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/DBERR.H_V   1.17   16 Feb 1995 13:37:12   BRADB  $
*/
