/*----------------------------------------------------------------------
   catlen.h - Velocis catalog lengths, and a few other small 
   things for interpretation of data stored in the catalog.

   Copyright (c) 1993-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef CATLEN_H
#define CATLEN_H

/* Fundamental Velocis catalog lengths (including terminal null byte) */

#define SERVERNAME_LEN   12     /* server name */
#define SERVERADDR_LEN  128     /* server@node */
#define CHLOG_CYCLE_LEN   8     /* e.g., "RAAAAAAA" */
#define CHLOGDEV_LEN     10
#define CHKPTDEV_LEN     10
#define CUSTOMERNAME_LEN 40
#define SERIALNUM_LEN    30
#define USERNAME_LEN     15     /* user name */
#define USERPASS_LEN      8     /* user password */
#define DEVNAME_LEN      10     /* device name */
#define DEVPATH_LEN      48     /* full path name of device */
#if 0
#define DBDNAME_LEN      13     /* filename (with extension?) of .DBD file */
#endif
#define DBNAME_LEN       13     /* database name -- filename (with
                                   extension?) of .DBD file */
#define CREATECHG_LEN     8
#define RDS_FILENAME_LEN 16
#define GRPNAME_LEN       8
#define BACKCHG_LEN       8
#define CHGNAMEST_LEN     8
#define CHGNAMEEND_LEN    8
#define EMNAME_LEN       12     /* extension module name */

#define DBACCESS_PRIVATE    0x01
#define DBACCESS_SQL_DB     0x02

#endif /* CATLEN_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/CATLEN.H_V   1.5   11 Nov 1994 08:30:24   BRADB  $
*/

