#ifndef CATALOG_H
#define CATALOG_H

/*---------------------------------------------------------------------------
   Velocis catalog definition

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------------*/


/* database catalog record/key structure declarations */

struct sysconfig {
   char servername[12];
   unsigned short maxpages;
   unsigned short maxlocks;
   unsigned short maxibsize;
   unsigned short maxobsize;
   unsigned short maxdbopen;
   unsigned short maxuserson;
   unsigned short maxuserslicensed;
   unsigned short numthrds;
   unsigned short numpthrds;
   short thrdfair;
   unsigned short dbid_seq;
   unsigned short delaytre;
   unsigned short archon;
   unsigned long maxchksize;
   unsigned long maxlogsize;
   long memlimit;
   unsigned short filelimit;
   char chlog_cycle[8];
   char chlogdev[10];
   char chkptdev[10];
   unsigned short backupid;
   char customername[40];
   char serialnum[30][1];
};

struct userinf {
   char username[15];
   char userpass[8];
   char userpriv;
};

struct device {
   char devname[10];
   char devpath[48];
};

struct dbdinf {
   char dbdinfname[13];
};

struct dbase {
   char dbname[13];
   unsigned short dbid;
   long datecreate;
   char createchg[8];
   unsigned long createofs;
   char dbaccess;
};

struct fileinf {
   char rds_filename[16];
};

struct dbaccrec {
   short permaccess;
   short ownerdb;
};

struct groupname {
   char grpname[8];
   short dbavail;
};

struct backupinf {
   unsigned long savesetid;
   unsigned long backtime;
   char backchg[8];
   unsigned long backofs;
};

struct ign_region {
   char chgnamest[8];
   unsigned long startofs;
   char chgnameend[8];
   unsigned long endofs;
};

struct extmodule {
   char emname[12];
};

/* record, field and set table entry definitions */

/* File Id Constants */

/* Record Name Constants */
#define SYSCONFIG 10000
#define USERINF 10001
#define DEVICE 10002
#define DBDINF 10003
#define DBASE 10004
#define FILEINF 10005
#define DBACCREC 10006
#define GROUPNAME 10007
#define BACKUPINF 10008
#define IGN_REGION 10009
#define EXTMODULE 10010

/* Field Name Constants */
#define SERVERNAME 0L
#define MAXPAGES 1L
#define MAXLOCKS 2L
#define MAXIBSIZE 3L
#define MAXOBSIZE 4L
#define MAXDBOPEN 5L
#define MAXUSERSON 6L
#define MAXUSERSLICENSED 7L
#define NUMTHRDS 8L
#define NUMPTHRDS 9L
#define THRDFAIR 10L
#define DBID_SEQ 11L
#define DELAYTRE 12L
#define ARCHON 13L
#define MAXCHKSIZE 14L
#define MAXLOGSIZE 15L
#define MEMLIMIT 16L
#define FILELIMIT 17L
#define CHLOG_CYCLE 18L
#define CHLOGDEV 19L
#define CHKPTDEV 20L
#define BACKUPID 21L
#define CUSTOMERNAME 22L
#define SERIALNUM 23L
#define USERNAME 1000L
#define USERPASS 1001L
#define USERPRIV 1002L
#define DEVNAME 2000L
#define DEVPATH 2001L
#define DBDINFNAME 3000L
#define DBNAME 4000L
#define DBID 4001L
#define DATECREATE 4002L
#define CREATECHG 4003L
#define CREATEOFS 4004L
#define DBACCESS 4005L
#define RDS_FILENAME 5000L
#define PERMACCESS 6000L
#define OWNERDB 6001L
#define GRPNAME 7000L
#define DBAVAIL 7001L
#define SAVESETID 8000L
#define BACKTIME 8001L
#define BACKCHG 8002L
#define BACKOFS 8003L
#define CHGNAMEST 9000L
#define STARTOFS 9001L
#define CHGNAMEEND 9002L
#define ENDOFS 9003L
#define EMNAME 10000L

/* Set Name Constants */
#define SYS_CON 20000
#define SYS_DEV 20001
#define SYS_EM 20002
#define SYS_USER 20003
#define DEV_USER 20004
#define DEV_FILE 20005
#define DEV_DBDINF 20006
#define DBDINF_DBASE 20007
#define DEV_EM 20008
#define DBASE_FILES 20009
#define DBASE_USER 20010
#define USER_DBASE 20011
#define FAMILY_INFO 20012
#define FAMILY_IGN_REGION 20013
#define FAMILY_BACKUP 20014

/* Field Sizes */
#define SIZEOF_SERVERNAME 12
#define SIZEOF_MAXPAGES 2
#define SIZEOF_MAXLOCKS 2
#define SIZEOF_MAXIBSIZE 2
#define SIZEOF_MAXOBSIZE 2
#define SIZEOF_MAXDBOPEN 2
#define SIZEOF_MAXUSERSON 2
#define SIZEOF_MAXUSERSLICENSED 2
#define SIZEOF_NUMTHRDS 2
#define SIZEOF_NUMPTHRDS 2
#define SIZEOF_THRDFAIR 2
#define SIZEOF_DBID_SEQ 2
#define SIZEOF_DELAYTRE 2
#define SIZEOF_ARCHON 2
#define SIZEOF_MAXCHKSIZE 4
#define SIZEOF_MAXLOGSIZE 4
#define SIZEOF_MEMLIMIT 4
#define SIZEOF_FILELIMIT 2
#define SIZEOF_CHLOG_CYCLE 8
#define SIZEOF_CHLOGDEV 10
#define SIZEOF_CHKPTDEV 10
#define SIZEOF_BACKUPID 2
#define SIZEOF_CUSTOMERNAME 40
#define SIZEOF_SERIALNUM 30
#define SIZEOF_USERNAME 15
#define SIZEOF_USERPASS 8
#define SIZEOF_USERPRIV 1
#define SIZEOF_DEVNAME 10
#define SIZEOF_DEVPATH 48
#define SIZEOF_DBDINFNAME 13
#define SIZEOF_DBNAME 13
#define SIZEOF_DBID 2
#define SIZEOF_DATECREATE 4
#define SIZEOF_CREATECHG 8
#define SIZEOF_CREATEOFS 4
#define SIZEOF_DBACCESS 1
#define SIZEOF_RDS_FILENAME 16
#define SIZEOF_PERMACCESS 2
#define SIZEOF_OWNERDB 2
#define SIZEOF_GRPNAME 8
#define SIZEOF_DBAVAIL 2
#define SIZEOF_SAVESETID 4
#define SIZEOF_BACKTIME 4
#define SIZEOF_BACKCHG 8
#define SIZEOF_BACKOFS 4
#define SIZEOF_CHGNAMEST 8
#define SIZEOF_STARTOFS 4
#define SIZEOF_CHGNAMEEND 8
#define SIZEOF_ENDOFS 4
#define SIZEOF_EMNAME 12

#endif    /* CATALOG_H */
