/*-------------------------------------------------------------------------
    valerror.h  -  VAL error codes

    Used on both client and server side.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-------------------------------------------------------------------------*/

#ifndef VALERRS_H
#define VALERRS_H

#define VAL_OKAY       0        /* status is okay, ie. operation is success */
#define VAL_BUSY      -1        /* internal error */
#define VAL_INUSE     -2        /* internal error */
#define VAL_NOMEM     -3        /* allocation failed */
#define VAL_TOOSMALL  -4        /* output buffer to small for result */
#define VAL_BADENV    -5        /* passed in a bad environment handle */
#define VAL_INVALID   -6        /* passed in a bad argument */
#define VAL_BADBUF    -7        /* internal error */
#define VAL_NULL      -8        /* unpack a NULL value */
#define VAL_MAXPREC   -9        /* unpacking a value which exceeds max prec */
#define VAL_OVERLOSS -10        /* operation has resulted in both overflow and precloss */
#define VAL_OVERFLOW -11        /* operation has resulted in an overflow */
#define VAL_PRECLOSS -12        /* operation has resulted in percision loss */

#endif /* VALERRS_H */
/*
$Header:   P:/PAT/INCLUDE/VCS/VALERRS.H_V   1.1   18 Apr 1994 12:12:20   RICHM  $
*/

