/*----------------------------------------------------------------------
   txtutil.h:  text manipulation functions

   Copyright (c) 1993-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef TXTUTIL_H
#define TXTUTIL_H


/*---------------------------------------------------------------------------
    prototypes for txtutil.c
*/

#ifdef WATC
char *RINTERNAL getWatcEnv(
    char *cp
);
#ifdef __NETWARE_386__
void RINTERNAL putWatcEnv(
    char *cp
);
#endif
#endif

short RINTERNAL AllDigits(
    const char *mayBeNum
);
char * RINTERNAL makeAllocPath (
    const char *path,
    const char *filename,
    const char *extension,  /* if NULL, don't append terminal '.' to buf */
    short tag
);
short RINTERNAL makePath (
    char *buf,          /* buffer in which to build the pathname (possibly
                         * the same as 'path' */
    unsigned short bufLen,  /* number of bytes in 'buf' */
    const char *path,
    const char *filename,
    const char *extension   /* if NULL, don't append terminal '.' to buf */
);
char * RINTERNAL pathBaseExt (
    const char *fullpath    /* path name, possibly with drive specifier */
);
char * RINTERNAL StrArrayCat(
    const char **pStrArray,
    short nStr,             /* number of entries in the array */
    short tag
);
char * RINTERNAL StrncpyZ(
    char *dest,
    const char *src,
    size_t len
);
char * RINTERNAL StrLower(
    char *
);
char * RINTERNAL StrUpper(
    char *
);
short RINTERNAL StrToArgv(
    char *pStr,
    int *pArgc,
    char ***pArgv,
    short tag
);

void rdsLoginParms(
    const char *pszCmdLine,
    char *pszServer,
    char *pszUserID,
    char *pszPassword
);

/* formatted terminal output conversion */
void tprintf(
    const char *format,
    ... 
);

#if defined(AIX) || defined(HPUX) || defined(SCO) || defined(SOLARIS)
#define USE_RDS_STRICMP
int stricmp (const char *pStr1, const char *pStr2);
int strnicmp (const char *pStr1, const char *pStr2, unsigned int count);
#endif

#endif /* TXTUTIL_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/TXTUTIL.H_V   1.25   13 Jul 1994 09:26:06   JAYE  $
*/
