/*----------------------------------------------------------------------
   sqlrpc.h

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef SQLRPC_H
#define SQLRPC_H

#include "rdsrpc.h"

/* ====================================================================
    SQL RPC data type conversion table
*/
#ifndef RPCTYPES
#define RPCTYPES

/* only rdbccore.c and sql.c should get here */
static short sql_rpctypes[] = { /* subscripted by dtype+SQL_NEGTYPES */
    /* SQL_NOVAL         */  0,
    /* SQL_NOW           */  0,
    /* SQL_TODAY         */  0,
    /* SQL_USER          */  0,
    /* SQL_CDATA         */  0,
    /* SQL_DBADDR        */  DPL_DT_LONG | DPL_DT_MOD_ARRAY,
    /* SQL_BIT           */  0,
    /* SQL_TINYINT       */  0,
    /* SQL_BIGINT        */  0,
    /* SQL_LONGVARBINARY */  0,
    /* SQL_VARBINARY     */  0,
    /* SQL_BINARY        */  DPL_DT_CHAR | DPL_DT_MOD_ARRAY,
    /* SQL_LONGVARCHAR   */  0,
    /* SQL_NULL          */  0,
    /* SQL_CHAR          */  DPL_DT_CHAR | DPL_DT_MOD_ARRAY,
    /* SQL_NUMERIC       */  DPL_DT_CHAR | DPL_DT_MOD_ARRAY,
    /* SQL_DECIMAL       */  DPL_DT_CHAR | DPL_DT_MOD_ARRAY,
    /* SQL_INTEGER       */  DPL_DT_LONG | DPL_DT_MOD_ARRAY,
    /* SQL_SMALLINT      */  DPL_DT_SHORT | DPL_DT_MOD_ARRAY,
    /* SQL_FLOAT         */  DPL_DT_DOUBLE | DPL_DT_MOD_ARRAY,
    /* SQL_REAL          */  DPL_DT_FLOAT | DPL_DT_MOD_ARRAY,
    /* SQL_DOUBLE        */  DPL_DT_DOUBLE | DPL_DT_MOD_ARRAY,
    /* SQL_DATE          */  DPL_DT_LONG | DPL_DT_MOD_ARRAY,
    /* SQL_TIME          */  DPL_DT_LONG | DPL_DT_MOD_ARRAY,
    /* SQL_TIMESTAMP     */  DPL_DT_LONG | DPL_DT_MOD_ARRAY,
    /* SQL_VARCHAR       */  DPL_DT_CHAR | DPL_DT_MOD_ARRAY
};

static DPLDATAITEM rpcTimestamp[] = {
     DPL_DT_OPEN_STRUCT,0,sizeof(TIMESTAMP_VAL),0,
     DPL_DT_LONG,0,0,0, /* date */
     DPL_DT_LONG,0,0,0, /* time */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};


#else   /* RPCTYPES */

/* all modules except rdbccore.c and sql.c should get here */
extern short rpctypes[];

#endif  /* RPCTYPES */

/*
$Header:   P:/PAT/INCLUDE/VCS/SQLRPC.H_V   1.10   18 Apr 1994 12:12:04   RICHM  $
*/

#endif
