/*===========================================================================
    sqlrdefs.h - RDS SQL-dependent constant and type definitions.

    Used on both client and server side.

    Raima Corporation version.
    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
===========================================================================*/
#ifndef SQLRDEFS_H
#define SQLRDEFS_H
#include "sqlxdefs.h"
#include "rsqlerrs.h"
#include "valerrs.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct bcd_val {
    unsigned char prec;     /* precision of DECIMAL */
    unsigned char scale;    /* scale of DECIMAL */
    unsigned char flags;    /* PACKED_MASK | SIGN_MASK */
    char          val[1];   /* start of DECIMAL */
} BCD_VAL;

typedef void RFAR  *   BCD_HENV;

typedef struct tagBCD_STRUCT {
    BCD_HENV    hBCD;
    BCD_VAL    *ptr;
    unsigned short bytes;
} BCD_STRUCT;

#define BCDLEN(p) (sizeof(BCD_VAL)+((p)/2+(p)%2))

typedef struct _decimal {
   unsigned char LDigits;   /* Actual # of digits left of decimal.                                    */
   unsigned char RDigits;   /* Actual # of digits right of decimal.                                   */
   BCD_VAL RFAR *ptr;       /* copy input decimals here. Must be allocated by caller                  */
   short         Static;    /* = 1 => ptr is static buffer don't free */
} DECIMAL;                  /* Decimal:   bit 0 = sign, 0 = neg, 1 = pos.                             */
                            /*            bit 4  - 7,  digit 1                                        */
                            /*            ...                                                         */

typedef struct _c_data {
    void RFAR        *ptr;  /* pointer to buffer containing c_data */
    short             len;  /* length (in bytes) of ptr buffer */
} C_DATA;

typedef void RFAR * HCDATA;

typedef struct _value {
    short type;                      /* data type of value (SQL_*)          */
    union {
        short          sv;           /* SQL_SMALLINT                        */
        long           lv;           /* SQL_INTEGER || SQL_DATE || SQL_TIME */
        float          fv;           /* SQL_REAL                            */
        double         dv;           /* SQL_FLOAT                           */
        DECIMAL        bv;           /* SQL_DECIMAL */
        C_DATA         cd;           /* SQL_CDATA */
        struct {
            long       date;         /* absolute date: 0 == no date         */
            long       time;         /* seconds per day * 10000             */
        } tsv;                       /* SQL_TIMESTAMP                       */
        char RFAR     *cv;           /* SQL_CHAR ||  SQL_VARCHAR            */
    } vt;
} VALUE;

/* VALUE Descriptor, used by import/export filters */
typedef struct value_descr {
    char RFAR *name;        /* name of column */
    short type;             /* data type */
    short prec;             /* precision or length */
    short scale;            /* scale */
} VALUE_DESCR;


/* TBD:HELP: Version strings DRIVER_VER_NO and SOURCE_VER_NO should be automated!!! */

#define DRIVER_VER_NO       "01.02.0100"    /* ODBC format for driver version */
#define SOURCE_VER_NO       "01.02.0100"    /* ODBC format for source version, same as RSQL_VER_NO */

#define SQL_BEGIN           2       /* SQLExtendedTransact begin */
#define SQL_MARK            3       /* SQLExtendedTransact mark */

/* number of negative valued data types (= - SQL_NOVAL) */
#define SQL_NULL             0
#define SQL_DBADDR          -8
#define SQL_CDATA           -9
#define SQL_USER            -10
#define SQL_TODAY           -11
#define SQL_NOW             -12
#define SQL_NOVAL           -13
#define SQL_PARAMREF        -14
#define SQL_COLREF          -15
#define SQL_ZERODIV         -16
#define SQL_VALUE           -17
#define SQL_PROCVAR         -18
#define SQL_PRECLOSS        -19
#define SQL_OVERFLOW        -20
#define SQL_OVERLOSS        -21
#define SQL_NEGTYPES        (-(SQL_NOVAL))

#define SQL_ROWID           SQL_DBADDR

#define SQL_C_STRUCT        SQL_CDATA
#define SQL_C_DATA          SQL_CDATA

/* sqlrdefs.h redefines from that in sqlxdefs.h for RDS SQL types */
#undef  SQL_TYPE_MIN
#define SQL_TYPE_MIN        -9

#define SQL_PREC_SMALLINT   5
#define SQL_PREC_INTEGER    10
#define SQL_PREC_FLOAT      15
#define SQL_PREC_REAL       7

/* non-ODBC Functions for SQLGetFunctions */
#define SQL_API_EXTENDEDTRANSACT        200
#define SQL_API_BINDCALC                201
#define SQL_API_DESCRIBEBREAK           202
#define SQL_API_DESCRIBECALC            203
#define SQL_API_DESCRIBEREPORT          204
#define SQL_API_DESCRIBEROW             205
#define SQL_API_DESCRIBERIBESTMT        206
#define SQL_API_NEXTLINE                207
#define SQL_API_NEXTPAGE                208
#define SQL_API_WHENEVER                209

/* row type definitions */
#define DETAIL                      0
#define BREAK                       1
#define REPHDR                      2
#define PAGEHDR                     3
#define BREAKHDR                    4
#define PAGEFTR                     5
#define REPFTR                      6

/* statement type definitions
   (specified order corresponds to position in jump table in sql.c)
*/
#define sqlOPEN                     1
#define sqlCLOSE                    2
#define sqlSELECT                   3
#define sqlINSERT                   4
#define sqlBEGIN                    5
#define sqlCOMMIT                   6
#define sqlMARK                     7
#define sqlROLLBACK                 8
#define sqlSET                      9
#define sqlUPDATE                   10
#define sqlDELETE                   11
#define sqlCRVIEW                   12
#define sqlDRVIEW                   13
#define sqlREPORT                   14
#define sqlCRPROC                   15
#define sqlDRPROC                   16
#define sqlEXECUTE                  17
#define sqlSTATS                    18
#define sqlLOCK                     19
#define sqlUNLOCK                   20
#define sqlCRFUNC                   21
#define sqlDRFUNC                   22
#define sqlCRFILTER                 23
#define sqlDRFILTER                 24
#define sqlCRTABLE                  25
#define sqlDRTABLE                  26
#define sqlCRINDEX                  27
#define sqlDRINDEX                  28
#define sqlGRANT                    29
#define sqlREVOKE                   30
#define sqlACTIVATE                 31
#define sqlDEACTIVATE               32
#define sqlCRDB                     33
#define sqlDRDB                     34

#ifdef __cplusplus
}
#endif

/*
$Header:   P:/PAT/INCLUDE/VCS/SQLRDEFS.H_V   1.26   16 Mar 1995 07:20:36   BRADB  $
*/
#endif
