/*===========================================================================
    sql.h - standard header for ODBC compliant applications.

    Raima Corporation version.
    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
===========================================================================*/
#ifndef SQL_H
#define SQL_H
#include "sqldefs.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================
    Raima SQL ODBC Core Function Prototypes
*/
RETCODE REXTERNAL SQLAllocConnect(
    HENV              henv,
    HDBC RFAR       * hdbc
);

RETCODE REXTERNAL SQLAllocEnv(
    HENV RFAR       * henv
);

RETCODE REXTERNAL SQLAllocStmt(
    HDBC              hdbc,
    HSTMT RFAR      * hstmt
);

RETCODE REXTERNAL SQLBindCol(
    HSTMT             hstmt,
    UWORD             col,
    SWORD             type,
    PTR               buf,
    SDWORD            buflen,
    SDWORD RFAR     * outlen
);

RETCODE REXTERNAL SQLCancel(
    HSTMT             hstmt
);

RETCODE REXTERNAL SQLColAttributes(
    HSTMT             hstmt,
    UWORD             colNum,
    UWORD             descType,
    PTR               outBuffer,
    SWORD             outBufLen,
    SWORD   RFAR    * actualOutLen,
    SDWORD  RFAR    * numericBuff
);

RETCODE REXTERNAL SQLConnect(
    HDBC              hdbc,
    UCHAR RFAR      * server,
    SWORD             slen,
    UCHAR RFAR      * user,
    SWORD             ulen,
    UCHAR RFAR      * password,
    SWORD             plen
);

RETCODE REXTERNAL SQLDescribeCol(
    HSTMT             hstmt,
    UWORD             col,
    UCHAR RFAR      * colname,
    SWORD             buflen,
    SWORD RFAR      * outlen,
    SWORD RFAR      * type,
    UDWORD RFAR     * prec,
    SWORD RFAR      * scale,
    SWORD RFAR      * nullable
);

RETCODE REXTERNAL SQLDisconnect(
    HDBC              hdbc
);

RETCODE REXTERNAL SQLError(
    HENV              henv,
    HDBC              hdbc,
    HSTMT             hstmt,
    UCHAR RFAR      * sqlstate,
    SDWORD RFAR     * rsqlcode,
    UCHAR RFAR      * errmsg,
    SWORD             errlen,
    SWORD RFAR      * outlen
);

RETCODE REXTERNAL SQLExecDirect(
    HSTMT             hstmt,
    UCHAR RFAR      * sqlstr,
    SDWORD            slen
);

RETCODE REXTERNAL SQLExecute(
    HSTMT             hstmt
);

RETCODE REXTERNAL SQLFetch(
    HSTMT             hstmt
);

RETCODE REXTERNAL SQLFreeConnect(
    HDBC              hdbc
);

RETCODE REXTERNAL SQLFreeEnv(
    HENV              henv
);

RETCODE REXTERNAL SQLFreeStmt(
    HSTMT             hstmt,
    UWORD             option
);

RETCODE REXTERNAL SQLGetCursorName(
    HSTMT             hstmt,
    UCHAR RFAR      * cursor,
    SWORD             clen,
    SWORD RFAR      * olen
);

RETCODE REXTERNAL SQLNumResultCols(
    HSTMT             hstmt,
    SWORD RFAR      * nocols
);

RETCODE REXTERNAL SQLPrepare(
    HSTMT             hstmt,
    UCHAR RFAR      * sqlstr,
    SDWORD            slen
);

RETCODE REXTERNAL SQLRowCount(
    HSTMT             hstmt,
    SDWORD RFAR     * rows
);

RETCODE REXTERNAL SQLSetCursorName(
    HSTMT             hstmt,
    UCHAR RFAR      * cursor,
    SWORD             clen
);

RETCODE REXTERNAL SQLSetParam(
    HSTMT             hstmt,
    UWORD             pnum,
    SWORD             ctype,
    SWORD             dtype,
    UDWORD            coldef,
    SWORD             scale,
    PTR               value,
    SDWORD RFAR     * len
);

RETCODE REXTERNAL SQLTransact(
    HENV              henv,
    HDBC              hdbc,
    UWORD             type
);

#ifdef __cplusplus
}
#endif

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/SQL.H_V   1.19   18 Apr 1994 12:11:54   RICHM  $
*/
