/*----------------------------------------------------------------------
   sdberr.h - text error messages used by s_errinfo

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef SDBERRS_H
#define SDBERRS_H

/* s_errinfo error/status messages */
static char *server_error[] = {
    "unable to open server catalog",                  /* S_NOCATALOG   -1000 */
    "unable to locate user name",                     /* S_USERNAME    -1001 */
    "wrong password",                                 /* S_PASSWORD    -1002 */
    "login has been denied",                          /* S_NOLOGIN     -1003 */
    "extension module is not registered in catalog",  /* S_UNREGEM     -1004 */
    "server handle was bad",                          /* S_BADSRV      -1005 */
    "extension module handle was bad",                /* S_BADEMH      -1006 */
    "DosFreeModule call failed",                      /* S_FREEMODULE  -1007 */
    "DosGetProcAddr call failed",                     /* S_GETPROCADDR -1008 */
    "DosLoadModule call failed",                      /* S_LOADMODULE  -1009 */
    "Device exists",                                  /* S_DEVEXISTS   -1010 */
    "Database exists",                                /* S_DBEXISTS    -1011 */
    "No privilege",                                   /* S_PRIV        -1012 */
    "",                                               /* not used      -1013 */
    "No device",                                      /* S_NODEV       -1014 */
    "No database",                                    /* S_NODB        -1015 */
    "Extension module already exists in catalog",     /* S_EMEXISTS    -1016 */
    "User name already exists in catalog",            /* S_USEREXISTS  -1017 */
    "Unable to open a file on server",                /* S_FILEOPERR   -1018 */
    "Unable to write to file on server",              /* S_FILEWRERR   -1019 */
    "Unable to read from file on server",             /* S_FILERDERR   -1020 */
    "server name not in catalog",                     /* S_NOSVNAME    -1021 */
    "",                                               /* not used      -1022 */
    "config record does not exist",                   /* S_NOCONFIG    -1023 */
    "Database File does not exist",                   /* S_NODBFEXISTS -1024 */
    "Extension module does not exist",                /* S_NOEM        -1025 */
    "User does not exist",                            /* S_NOUSER      -1026 */
    "DEV_EM has members, delete not allowed",         /* S_EMMEMS      -1027 */
    "DEV_DBDINF has members, delete not allowed",     /* S_DBASEMEMS   -1028 */
    "DEV_FILE has members, delete not allowed",       /* S_FILEMEMS    -1029 */
    "DEV_USER has members, delete not allowed",       /* S_USERMEMS    -1030 */
    "User/Database not on access list",               /* S_NOTONLIST   -1031 */
    "User/Database already on access list",           /* S_ONLIST      -1032 */
    "Owner allready exists",                          /* S_OWNEXIST    -1033 */
    "Catalog Timeout",                                /* S_CATTIME     -1034 */
    "Database unavailable for catalog operation",     /* S_DBINUSE     -1035 */
    "Duplicate Family",                               /* S_DUPFAMILY   -1036 */
    "No Family Found",                                /* S_NOFAMILY    -1037 */
    "Database Not connected to family",               /* S_DBNOTCON    -1038 */
    "Database allready connected to a family",        /* S_DBALLCON    -1039 */
    "Backup Records don't exist for family",          /* S_NOBACK      -1040 */
    "Operation Invalid when Family is ON-LINE",       /* S_NOONLINE    -1041 */
    "Invalid Backup Id stamped on Family",            /* S_INVBACK     -1042 */
    "Ignore/Backup records Exist for family",         /* S_BCKIGNMEM   -1043 */
    "No ModDescribeFcns function in Extension Module",/* S_INVEM       -1044 */
    "",                                               /* not used      -1045 */
    "Family must be OFF_LINE",                        /* S_OFFLINE     -1046 */
    "Path currently exists for a different device",   /* S_PATHEXISTS  -1047 */
    "File currently exists for different database",   /* S_FILEDEVICE  -1048 */
    "(numthrds +numptrhds) cannot exceed 13",         /* S_INVAMTTHRDS -1049 */
    "Illegal Physical Path for Device",               /* S_BADPATH     -1050 */
    "Extension Module not currently attached",        /* S_NOTATTACHED -1051 */
    "Maximum licensed users already logged on",       /* S_USERLIMIT   -1052 */
    "Invalid database dictionary",                    /* S_DBINV       -1053 */
    "Name too long",                                  /* S_LONGNAME    -1054 */
    "Client/Server incompatibility"                   /* S_INCOMPATABILITY -1055 */
};

#define N_SDBERRS (sizeof(server_error) / sizeof(char *))
#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/SDBERR.H_V   1.23   11 Nov 1994 08:33:44   BRADB  $
*/
