/*----------------------------------------------------------------------
   saproto.h:  server access prototypes

   Copyright (c) 1991-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef SAPROTO_H
#define SAPROTO_H

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------------------------
    prototypes for srvacc.c
*/
char RFAR *REXTERNAL c_db_name(
    RDM_DB hDb );

short REXTERNAL c_size_ft(
    RDM_DB hDb );

short REXTERNAL c_size_rt(
    RDM_DB hDb );

short REXTERNAL c_size_fd(
    RDM_DB hDb );

short REXTERNAL c_size_st(
    RDM_DB hDb );

short REXTERNAL c_size_mt(
    RDM_DB hDb );

short REXTERNAL c_size_srt(
    RDM_DB hDb );

short REXTERNAL c_size_kt(
    RDM_DB hDb );

short REXTERNAL c_rec_len(
    short record,
    RDM_DB hDb );

char RFAR *REXTERNAL c_ft_name(
    short element,
    RDM_DB hDb );

short REXTERNAL c_ft_slsize(
    short element,
    RDM_DB hDb );

short REXTERNAL c_ft_slots(
    short element,
    RDM_DB hDb );

short REXTERNAL c_rt_fdtot(
    short record,
    RDM_DB hDb );

short REXTERNAL c_rt_fields(
    short record,
    RDM_DB hDb );

char RFAR *REXTERNAL c_rt_name(
    short record,
    RDM_DB hDb );

short REXTERNAL c_rt_size(
    short record,
    RDM_DB hDb );

short REXTERNAL c_fd_len(
    short fd_number,
    RDM_DB hDb );

unsigned char REXTERNAL c_fd_type(
    short fd_number,
    RDM_DB hDb );

short REXTERNAL c_fd_key(
    short fd_number,
    RDM_DB hDb );

short REXTERNAL c_fd_keyfile(
    short fd_number,
    RDM_DB hDb );

short REXTERNAL c_fd_rec(
    short fd_number,
    RDM_DB hDb );

short REXTERNAL c_fd_dim(
    short fd_number,
    short dim_elem,
    RDM_DB hDb );

short REXTERNAL c_fd_flags(
    short fd_number,
    RDM_DB hDb );

char RFAR *REXTERNAL c_fd_name(
    short fd_number,
    RDM_DB hDb );

short REXTERNAL c_fd_size(
    long field,
    RDM_DB hDb );

short REXTERNAL c_field_offset(
    short fd_number,
    RDM_DB hDb );

short REXTERNAL c_st_order(
    short st_number,
    RDM_DB hDb );

short REXTERNAL c_st_own_rt(
    short st_number,
    RDM_DB hDb );

short REXTERNAL c_st_members(
    short st_number,
    RDM_DB hDb );

short REXTERNAL c_st_memtot(
    short st_number,
    RDM_DB hDb );

char RFAR *REXTERNAL c_st_name(
    short st_number,
    RDM_DB hDb );

short REXTERNAL c_mt_record(
    short mt_number,
    RDM_DB hDb );

short REXTERNAL c_mt_sort_fld(
    short mt_number,
    RDM_DB hDb );

short REXTERNAL c_mt_totsf(
    short mt_number,
    RDM_DB hDb );

short REXTERNAL c_se_fld(
    short srt_number,
    RDM_DB hDb );

short REXTERNAL c_kt_key(
    short kt_number,
    RDM_DB hDb );

short REXTERNAL c_kt_field(
    short kt_number,
    RDM_DB hDb );

short REXTERNAL c_kt_ptr(
    short kt_number,
    RDM_DB hDb );

short REXTERNAL c_rt_idx(
    short rec );

short REXTERNAL c_fd_idx(
    long fld,
    RDM_DB hDb );

short REXTERNAL c_st_idx(
    short rec );

short REXTERNAL c_freedict(
    RDM_DB hDb );

short REXTERNAL c_sendfile(
    char RFAR *filename,
    char RFAR *device,
    RDM_SESS hSess );

short REXTERNAL c_recvfile(
    char RFAR *filename,
    char RFAR *device,
    RDM_SESS hSess );

#ifdef __cplusplus
}
#endif

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/SAPROTO.H_V   1.9   18 Apr 1994 12:11:48   RICHM  $
*/
