/*
    File: RPCDEFS.H
 Purpose: Include module for Remote Procedure Call Facility.
  Author: Brian Scott
    Date: 9-16-92

 Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------------*/
#ifndef RPCDEFS_H
#define RPCDEFS_H

/************** INTERNAL RETURN CODES ********************************/
#define S_RPCSVCINUSE     -5020
#define S_RPCFCNDISABLED  -5021
#define S_RPCINVSERVICE   -5022
#define S_RPCFCNINUSE     -5023
#define S_RPCFCNNOTUSED   -5024
#define S_RPCINVMODE      -5025

/************** MODE PARAMETERS ********************************/
#define RPC_MODE_CLIENT      0
#define RPC_MODE_SERVER      1

/********************* FUNCTION PROTOTYPES *****************/
#define RPCFCN  short (*FcnAddr)(PDPLDATADESC, PDPLDATADESC)

short REXTERNAL rpc_init(unsigned char, unsigned char, unsigned short,
    unsigned short);
void REXTERNAL rpc_term(void);
short REXTERNAL rpc_getFcnAddr(void **, unsigned short, unsigned short);
short REXTERNAL rpc_addFcn(
    short (REXTERNAL *FcnAddr)(PDPLDATADESC, PDPLDATADESC),
    unsigned short usServiceId, unsigned short FcnId);
short REXTERNAL rpc_deleteFcn(unsigned short, unsigned short);
short REXTERNAL rpc_disableFcn(unsigned short, unsigned short);
short REXTERNAL rpc_enableFcn(unsigned short, unsigned short);
short REXTERNAL rpc_callFcn(unsigned short, unsigned short, unsigned short,
    unsigned char, PDPLDATADESC, PDPLDATADESC *, short *);
short REXTERNAL rpc_processRequest(unsigned char, unsigned short *,
    unsigned short *, unsigned short *, short *);
short REXTERNAL rpc_mapNCPRetCode(short);
short REXTERNAL rpc_allocService(unsigned short, unsigned short);
short REXTERNAL rpc_freeService(unsigned short);
short REXTERNAL rpc_sessionInit(unsigned short usNcpSessId,
    RDM_SESS RDSSessId);

short REXTERNAL rpc_sessionTerm(
    unsigned short usNcpSessId
);

/* The following are needed in RPC\RPC.C and RPC\PARM.C: */
typedef struct {
    unsigned char  uchRPCMode;
    unsigned char  uchDPLMode;
    unsigned char  bIsAligned;
    unsigned short usServiceCBSize;
    unsigned short usRpcSessCBSize;
} RPCCB, *PRPCCB;

short RINTERNAL RPCDepacketize(PDPLDATADESC *, void *, unsigned short,
    unsigned char);
short RINTERNAL RPCPacketize(PDPLDATADESC, unsigned char);

extern RPCCB *gpRpcCB;  /* pointer to the Global RPC Control Block */

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/RPCDEFS.H_V   1.18   18 Apr 1994 12:11:36   RICHM  $
*/
