/*----------------------------------------------------------------------
    rmtagmem.h - resource manager prototypes for tagged memory

    This file contains function prototypes from the Resource Manager which
    may be used by extension modules.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RMTAGMEM_H
#define RMTAGMEM_H

#include <setjmp.h>

#ifdef __cplusplus
extern "C" {
#endif

#define NO_MEMTAG   (-1)        /* never a tag gotten with rm_allocTag */

short REXTERNAL rm_allocTag(
    int * jb,
    long limit
);

void REXTERNAL rm_resetTag(
    int * jb,
    short tag
);

void REXTERNAL rm_freeTagMemory(
    short tag,
    short freetag
);

void REXTERNAL rm_errorJump(
    int * jb
);

void REXTERNAL rm_exitJump(
    int * jb
);

#ifdef __cplusplus
}
#endif

/*
$Header:   P:/PAT/INCLUDE/VCS/RMTAGMEM.H_V   1.8   27 Sep 1994 15:43:20   BRADB  $
*/
#endif
