/*----------------------------------------------------------------------
    rmproto.h - Velocis resource manager prototypes.

    This file contains function prototypes from the Resource Manager which
    may be used by extension modules.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RMPROTO_H
#define RMPROTO_H

#ifdef __cplusplus
extern "C" {
#endif

void REXTERNAL rm_freeall(
    void
);

void REXTERNAL rm_setMemoryLimit(
    long limit
);

long REXTERNAL rm_memoryAvail(
    short tag
);

unsigned long REXTERNAL rm_memused(
    void
);

void REXTVARARG rm_memReport(
    short flags,
    short tag,
    char *msg,
    ...
);

/* File handling functions */
short REXTERNAL rm_fileCopy(
    char *srcName,
    char *destName
);

void REXTERNAL rm_fileHandleLimit(
    short limit
);

unsigned int REXTERNAL rm_fileSeekWrite(
    short handle,
    unsigned long seekAddr,
    void *buf,
    unsigned int length
);

unsigned int REXTERNAL rm_fileSeekRead(
    short handle,
    unsigned long seekAddr,
    void *buf,
    unsigned int length
);

long REXTERNAL rm_fileLength(
    short handle
);

short REXTERNAL rm_fileMove(
    char *srcName,
    char *destName
);

long REXTERNAL rm_filePosition(
    short handle
);

void REXTERNAL rm_fileSync(
    short handle
);

short REXTERNAL rm_fileRemove(
    char *name
);

short REXTERNAL rm_fileRename(
    char *oldName,
    char *newName
);

char * REXTERNAL rm_fileTempName(
    char *dir
);

/* Error handling functions */
void REXTERNAL rm_errorExit(
    void
);

/* System message logging functions */
void REXTERNAL rm_systemLogOpen(
    char *fn
);

short REXTERNAL rm_systemLog(
    short newVal
);

void REXTVARARG rm_systemLogWrite(
    char *format,
    ...
);

void REXTVARARG rm_systemLogOptWrite(
    char *format,
    ...
);

void REXTERNAL rm_systemLogClose(
    void
);

/* Statistics gathering functions */
void REXTERNAL rm_statInit(
    unsigned short count
);

void REXTERNAL rm_statInc(
    short item,
    unsigned short incamt
);

void REXTERNAL rm_statClear(
    short item
);

void REXTERNAL rm_statClearAll(
    void
);

long *REXTERNAL rm_statRep(
    unsigned short *count
);

void REXTERNAL rm_exit(
    short exitCode
);

short REXTERNAL rm_emRegFcn(
    char *emName,
    char *fcnName,
    short (REXTERNAL *fcnAddr)()
);

#ifdef WINDOWS

void REXTERNAL rm_block(
    int blockNum
);

void REXTERNAL rm_release(
    int blockNum
);

void REXTERNAL rm_yield(
    void
);

#else

#define rm_block(a)                 /**/
#define rm_release(a)               /**/
#define rm_yield()                  /**/

#endif

#if defined(RDSWIN) && !defined(QUICKWIN)

#ifndef _INC_STDIO
#include <stdio.h>
#endif
#ifndef _INC_TIME
#include <time.h>
#endif

int     __cdecl RDSsscanf(const char *, const char *, ...);
char *  __cdecl RDSdtoa (double, char *, short, short, char *, short);
int     __cdecl RDSprintf(const char *, ...);
FILE *  __cdecl RDSfdopen(int, const char *);
void    __cdecl RDSexit(int);
int     __cdecl RDSvprintf(const char *, va_list);
size_t  __cdecl RDSstrftime(char *, size_t, const char *, const struct tm *);
char *  __cdecl RDSgets(char *);
#endif

#ifdef __cplusplus
}
#endif

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/RMPROTO.H_V   1.28   13 Dec 1994 08:05:00   BRADB  $
*/
