/*----------------------------------------------------------------------
    rdserrs.h:  Velocis error codes

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RDSERRS_H
#define RDSERRS_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Velocis error codes (negative)
*/
#define S_DBOPEN    (-1)	    /* database not opened */
#define S_INVSET    (-2)	    /* invalid set */
#define S_INVREC    (-3)	    /* invalid record */
#define S_INVDB     (-4)	    /* invalid database handle */
#define S_INVFLD    (-5)	    /* invalid field name */
#define S_INVADDR   (-6)	    /* invalid db_address */
#define S_NOCR      (-7)	    /* no current record */
#define S_NOCO      (-8)	    /* set has no current owner */
#define S_NOCM      (-9)	    /* set has no current member */
#define S_KEYREQD   (-10)	    /* key value required */
#define S_BADTYPE   (-11)	    /* invalid database open mode or lock type */
#define S_HASMEM    (-12)	    /* record is owner of non-empty set(s) */
#define S_ISMEM     (-13)	    /* record is member of set(s) */
#define S_ISOWNED   (-14)	    /* member already owned */
#define S_ISCOMKEY  (-15)       /* field is a compound key */
#define S_NOTCON    (-16)       /* record not connected to set */
#define S_NOTKEY    (-17)	    /* field is not a valid key */
#define S_INVOWN    (-18)	    /* record not legal owner of set */
#define S_INVMEM    (-19)	    /* record not legal member of set */
#define S_INCOMPAT  (-20)	    /* incompatible dictionary file */
#define S_DELSYS    (-21)	    /* illegal attempt to delete system record */
#define S_NOTLOCKED (-22)	    /* attempt to access unlocked record or set */
#define S_TRANSID   (-23)	    /* transaction id not supplied */
#define S_TRACTIVE  (-24)	    /* transaction already active */
#define S_TRNOTACT  (-25)	    /* transaction not currently active */
#define S_TRFREE    (-26)	    /* attempt to free a lock inside a transacton */
#define S_NOTRANS   (-27)	    /* attempted transaction in no-trans mode */
#define S_EXCLUSIVE (-28)	    /* functions requires exclusive db access */
#define S_USERID    (-29)	    /* Lock arbitor doesn't recognize userid */
#define S_NOTOPTKEY (-30)	    /* field is not an optional key */
#define S_BADFIELD  (-31)	    /* field not defined in current record type */
#define S_COMKEY    (-32)	    /* record/field has/in a compound key */
#define S_INVNUM    (-33)	    /* invalid record or set number */
#define S_NOTYPE    (-34)	    /* No current record type */
#define S_INVSORT   (-35)	    /* Invalid country table sort string */
#define S_INVSESS   (-37)     /* session or database handle is invalid */
#define S_DBUNAVAIL (-38)     /* database is unavailable */
#define S_DBACCESS  (-39)     /* database cannot be accessed */
#define S_DBNOTREG  (-40)     /* database not registered in catalog */
#define S_ILLMODE   (-41)	    /* attempt to change read lock mode from */
#define S_BUFLEN    (-42)     /* Buffer is not big enough to receive */
#define S_CONFLICT  (-43)     /* instance/table level locking conflict */
#define S_ILLDOWNG  (-45)     /* illegal attempt to downgrade a lock inside */
#define S_NOFILE    (-46)     /* unable to locate a file */
#define S_CATERR    (-47)     /* catalog error */
#define S_INVFLOAT  (-48)     /* Field contains invalid floating point value */
#define S_INVDOUB   (-49)     /* Field contains invalid double value */
#define S_ILLCALL   (-50)     /* Illegal function call from client */
#define S_DBPERM    (-51)     /* No permission for DB operation */
#define S_INVNULL   (-52)     /* A NULL pointer parameter has been provided */
#define S_INVELEM   (-53)     /* Invalid table element requested */
#define S_NOMARK    (-54)     /* Mark not found during d_trrollback */
#define S_STATIC    (-55)     /* Illegal attempt to write lock static entity */
#define S_PROGRAM   (-56)     /* Program(mer) error -- can't do operation, but otherwise OK to proceed */
#define S_LONGPATH  (-57)     /* Database file path too long */
#define S_INVMODE   (-58)     /* Database opened in wrong mode for operation */
#define S_NEEDLOCK  (-59)     /* Need a record lock to connect/disconnect */
#define S_NODBERR   (-60)     /* specified error handler not found */

/*
 * Velocis status codes (Non-negative)
*/
#if 0       /* now in rdsbasic.h */
#define S_OKAY        0	    /* normal return, okay */
#endif

#define S_EOS         1	    /* end of set */
#define S_NOTFOUND    2	    /* record not found */
#define S_DUPLICATE   3	    /* duplicate key */
#define S_KEYSEQ      4	    /* field type used out of sequence in d_keynext */
#define S_UNAVAIL     5	    /* lock request not currently unavailable */
#define S_DELETED     6	    /* record/set deleted since last accessed */
#define S_EXOPENED    8	    /* database is exclusively opened */
#define S_OPENED      9	    /* cannot open database exclusively, it is
                                already opened */
#define S_INCMODE    10	    /* incompatible open mode (db already open) */
#define S_UPGDEN     11     /* upgrade denied - another upgrade pending */
#define S_NOLOCK     12     /* trying to free unlocked entity */
#define S_NOTGRANTED 13     /* instance lock not granted, covered by an
                               existing table lock */
#define S_LOCKED     14     /* lock was granted in previous request */
#define S_WRONGBACK  15     /* wrong backup is stamped on files */
#define S_SETCLASH   16     /* set currency clash with another user */
#define S_RPCENDOFPARMS  17 /* End of RPC Parameter list reached  */
#define S_VOIDTX     18     /* Cannot roll back a void transactions */
#define S_TXTIMEOUT  19     /* d_trbegin timed out.  Change log cycle in progress. */

/*
 * Velocis System error codes
*/
#define S_NOSPACE     (-900)   /* available disk space below min threshold */

/*
 * Velocis Administrative error codes
*/
#define S_NOCATALOG   (-1000)  /* unable to open server catalog */
#define S_USERNAME    (-1001)  /* unable to locate user name */
#define S_PASSWORD    (-1002)  /* wrong password */
#define S_NOLOGIN     (-1003)  /* login has been denied */
#define S_UNREGEM     (-1004)  /* extension module is not registered in catalog */
#define S_BADSRV      (-1005)  /* srv (task index) was bad */
#define S_BADEMH      (-1006)  /* extension module handle (emh) was bad */
#define S_FREEMODULE  (-1007)  /* the rm_emUnload call failed */
#define S_GETPROCADDR (-1008)  /* the rm_emGetFcnAddr call failed */
#define S_LOADMODULE  (-1009)  /* the rm_emLoad call failed */
#define S_DEVEXISTS   (-1010)  /* Device exists */
#define S_DBEXISTS    (-1011)  /* Database exists */
#define S_PRIV        (-1012)  /* No privilege */
#define S_NODEV       (-1014)  /* No device */
#define S_NODB        (-1015)  /* No database */
#define S_EMEXISTS    (-1016)  /* Extension module already exists in catalog */
#define S_USEREXISTS  (-1017)  /* User name already exists in catalog */
#define S_FILEOPERR   (-1018)  /* Unable to open a file on server */
#define S_FILEWRERR   (-1019)  /* Unable to write to file on server */
#define S_FILERDERR   (-1020)  /* Unable to read from file on server */
#define S_NOSVNAME    (-1021)  /* server name not in catalog */
#define S_NOCONFIG    (-1023)  /* config record does not exist */
#define S_NODBFEXISTS (-1024)  /* Database File does not exist */
#define S_NOEM        (-1025)  /* Extension module does not exist */
#define S_NOUSER      (-1026)  /* User does not exist */
#define S_EMMEMS      (-1027)  /* DEV_EM has members, delete not allowed */
#define S_DBASEMEMS   (-1028)  /* DEV_DBDINF has members, delete not allowed */
#define S_FILEMEMS    (-1029)  /* DEV_FILE has members, delete not allowed */
#define S_USERMEMS    (-1030)  /* DEV_USER has members, delete not allowed */
#define S_NOTONLIST   (-1031)  /* User/Database not on access list */
#define S_ONLIST      (-1032)  /* User/Database already on access list */
#define S_OWNEXIST    (-1033)  /* Owner already exists */
#define S_CATTIME     (-1034)  /* Catalog Timeout */
#define S_DBINUSE     (-1035)  /* Db is unavailable for catalog operation*/
#define S_DUPFAMILY   (-1036)  /* family already exists */
#define S_NOFAMILY    (-1037)  /* family does not exist */
#define S_DBNOTCON    (-1038)  /* dbase not connected to family */
#define S_DBALLCON    (-1039)  /* dbase already connected to family */
#define S_NOBACK      (-1040)  /* backup records do not exist for family */
#define S_NOONLINE    (-1041)  /* operation can't be done when family is online */
#define S_INVBACK     (-1042)  /* invalid backup saveset id on backup */
#define S_BCKIGNMEM   (-1043)  /* member can't be added because
                                * ignore/backupinf records exist */
#define S_INVEM       (-1044)  /* Extension module has no ModDescribeFcns function */
#define S_OFFLINE     (-1046)  /* Family must be off-line for operation */

#define S_PATHEXISTS  (-1047)  /* Path exists already */
#define S_FILEDEVICE  (-1048)  /* File already exists on device */
#define S_INVAMTTHRDS (-1049)  /* Too many threads */
#define S_BADPATH     (-1050)  /* Physical Path does not exist */
#define S_NOTATTACHED (-1051)  /* Client is not attached to extension module */
#define S_USERLIMIT   (-1052)  /* Maximum licensed users already logged on */
#define S_DBINV       (-1053)  /* Invalid database dictionary */
#define S_LONGNAME    (-1054)  /* Name too long */
#define S_INCOMPATABLE (-1055) /* client <--> server incompatability */

/*
 * Velocis Network Communication Processor error codes
*/
#define S_NCPINITERR  (-2000)  /* Failed to initialize NCP */
#define S_INVSVRNAME  (-2001)  /* Invalid server name (syntax problem) */
#define S_INVCONDATA  (-2002)  /* Invalid connect data */
#define S_REMNODEUNR  (-2003)  /* Remote node unreachable */
#define S_NMSVRUNR    (-2004)  /* Name server unreachable */
#define S_SVRUNAVAIL  (-2005)  /* Server unavailable (i.e., doesn't exist) */
#define S_NETUNAVAIL  (-2006)  /* Transport (on network) unavailable */
#define S_SESREJECT   (-2007)  /* Session rejected connection */
#define S_NINTERR     (-2008)  /* NCP internal error */
#define S_SESDISCON   (-2009)  /* The session is disconnected */
#define S_INVMSGSIZE  (-2010)  /* Invalid message size (NCP) */
#define S_NOMEMORY    (-2011)  /* client was unable to grant memory */
#define S_NOTLOGON    (-2012)  /* could not log on */
#define S_SESSUNAVAIL (-2013)  /* Session Limit Reached */
#define S_INVSESSID   (-2015)  /* Invalid Session Id */
#define S_INSUFFNETRES (-2016) /* Insufficient Network Resources */

/*
 * Velocis Data Portability Layer error codes
*/
#define S_DPLINTERR    (-4000) /* Internal DPL Error */
#define S_DPLTOOLARGE  (-4001) /* The data stream to be converted is too large */
#define S_DPLINTOVF    (-4002) /* Integer Overflow */
#define S_DPLFLTOVF    (-4003) /* Float Overflow   */
#define S_DPLDBLOVF    (-4004) /* Double Overflow */
#define S_DPLINTUNDF   (-4005) /* Integer Overflow */
#define S_DPLFLTUNDF   (-4006) /* Float Underflow   */
#define S_DPLDBLUNDF   (-4007) /* Double Underflow */
#define S_DPLINVDTYPE  (-4008) /* Invalid data type in data descriptor */

/*
 * Velocis Data Remote Procedure Call error codes
*/
#define S_RPCINTERR       (-5001)
#define S_RPCINVFCN       (-5002)
#define S_RPCSESSDISC     (-5003)
#define S_RPCINVDATAITEM  (-5004)
#define S_RPCINVDATATYPE  (-5005)
#define S_RPCPARMMISMATCH (-5006)
#define S_RPCINVSESSID    (-5007)

#ifdef __cplusplus
}
#endif

#endif

/*
$Header:   P:/PAT/INCLUDE/VCS/RDSERRS.H_V   1.31   23 Feb 1995 07:19:36   wayne  $
*/
