/*----------------------------------------------------------------------
   rdmprcdd.h:  Velocis RPC Data Descriptors

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RDMRPCDD_H
#define RDMRPCDD_H

#ifdef SERVER_DD
#define DO_FREE_MEM DPL_DT_MOD_FREE_MEM
#else
#define DO_FREE_MEM 0
#endif

#define RPC_DD_GROUPLOCK_SIZE 8

static DPLDATAITEM aRpcDDGROUPLOCK[RPC_DD_GROUPLOCK_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(GROUPLOCK),0,
     DPL_DT_SHORT, 0,0,0,     /* ftype  */
     DPL_DT_SHORT, 0,0,0,     /* rstype */
     DPL_DT_U_LONG,0,0,0,     /* dba */
     DPL_DT_U_LONG,0,0,0,     /* hdb */
     DPL_DT_SHORT, 0,0,0,     /* odnum  */
     DPL_DT_CHAR,  0,0,0,     /* lmode  */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};


#define RPC_DD_CHGINFO_SIZE 4

static DPLDATAITEM aRpcDDCHGINFO[RPC_DD_CHGINFO_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(CHGINFO),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0,     /* chgName  */
     DPL_DT_U_LONG,0,0,0,                      /* curofs  */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};


/*
-----------------------------------------------------------------------------
    Dictionary Tables
-----------------------------------------------------------------------------
*/

#define RPC_DD_FILE_ENTRY_SIZE 10

static DPLDATAITEM aRpcDDFILE_ENTRY[RPC_DD_FILE_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct FILE_ENTRY_S),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,FILENMLEN,0,0,  /* ft_name */
     DPL_DT_SHORT, 0,0,0,     /* ft_desc  */
     DPL_DT_CHAR,  0,0,0,     /* ft_status*/
     DPL_DT_CHAR,  0,0,0,     /* ft_type  */
     DPL_DT_SHORT, 0,0,0,     /* ft_slots */
     DPL_DT_SHORT, 0,0,0,     /* ft_slsize*/
     DPL_DT_SHORT, 0,0,0,     /* ft_pgsize*/
     DPL_DT_SHORT, 0,0,0,     /* ft_flags */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_RECORD_ENTRY_SIZE 8

static DPLDATAITEM aRpcDDRECORD_ENTRY[RPC_DD_RECORD_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct RECORD_ENTRY_S),0,
     DPL_DT_U_SHORT, 0,0,0,     /* rt_file  */
     DPL_DT_U_SHORT, 0,0,0,     /* rt_len   */
     DPL_DT_U_SHORT, 0,0,0,     /* rt_data  */
     DPL_DT_U_SHORT, 0,0,0,     /* rt_fields*/
     DPL_DT_SHORT, 0,0,0,     /* rt_fdtot */
     DPL_DT_SHORT, 0,0,0,     /* rt_flags */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_SET_ENTRY_SIZE 8

static DPLDATAITEM aRpcDDSET_ENTRY[RPC_DD_SET_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct SET_ENTRY_S),0,
     DPL_DT_SHORT, 0,0,0,     /* st_order   */
     DPL_DT_SHORT, 0,0,0,     /* st_own_rt  */
     DPL_DT_SHORT, 0,0,0,     /* st_own_ptr */
     DPL_DT_SHORT, 0,0,0,     /* st_members */
     DPL_DT_SHORT, 0,0,0,     /* st_memtot  */
     DPL_DT_SHORT, 0,0,0,     /* st_flags   */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_MEMBER_ENTRY_SIZE 6

static DPLDATAITEM aRpcDDMEMBER_ENTRY[RPC_DD_MEMBER_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct MEMBER_ENTRY_S),0,
     DPL_DT_SHORT, 0,0,0,     /* mt_record   */
     DPL_DT_SHORT, 0,0,0,     /* mt_mem_ptr  */
     DPL_DT_SHORT, 0,0,0,     /* mt_sort_fld */
     DPL_DT_SHORT, 0,0,0,     /* mt_totsf */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};


#define RPC_DD_SORT_ENTRY_SIZE 4

static DPLDATAITEM aRpcDDSORT_ENTRY[RPC_DD_SORT_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct SORT_ENTRY_S),0,
     DPL_DT_SHORT, 0,0,0,     /* se_fld  */
     DPL_DT_SHORT, 0,0,0,     /* se_set  */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};


#define RPC_DD_FIELD_ENTRY_SIZE 11

static DPLDATAITEM aRpcDDFIELD_ENTRY[RPC_DD_FIELD_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct FIELD_ENTRY_S),0,
     DPL_DT_CHAR,0,0,0,         /* fd_key  */
     DPL_DT_U_CHAR, 0,0,0,      /* fd_type */
     DPL_DT_U_SHORT, 0,0,0,     /* fd_len  */
     DPL_DT_U_SHORT | DPL_DT_MOD_ARRAY, MAXDIMS,0,0, /* fd_dim */
     DPL_DT_U_SHORT, 0,0,0,     /* fd_keyfile */
     DPL_DT_SHORT, 0,0,0,       /* fd_keyno */
     DPL_DT_U_SHORT, 0,0,0,     /* fd_ptr */
     DPL_DT_SHORT, 0,0,0,       /* fd_rec */
     DPL_DT_U_SHORT, 0,0,0,     /* fd_flags */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_KEY_ENTRY_SIZE 6

static DPLDATAITEM aRpcDDKEY_ENTRY[RPC_DD_KEY_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct KEY_ENTRY_S),0,
     DPL_DT_SHORT, 0,0,0,     /* kt_key    */
     DPL_DT_SHORT, 0,0,0,     /* kt_field  */
     DPL_DT_SHORT, 0,0,0,     /* kt_ptr    */
     DPL_DT_SHORT, 0,0,0,     /* kt_sort   */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_RECORD_SIZES_SIZE 4

static DPLDATAITEM aRpcDDRECORD_SIZES[RPC_DD_RECORD_SIZES_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct RECORD_SIZES_S),0,
     DPL_DT_SHORT, 0,0,0,     /* rt_size   */
     DPL_DT_SHORT, 0,0,0,     /* rt_fields */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_SIZE_ENTRY_SIZE 4

static DPLDATAITEM aRpcDDSIZE_ENTRY[RPC_DD_SIZE_ENTRY_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct _SIZE_ENTRY),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, FILENMLEN,0,0,     /* db_name */
     DPL_DT_SHORT | DPL_DT_MOD_ARRAY, 7,0,0,            /* size    */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_DATAITEM_SIZE 6

static DPLDATAITEM aRpcDDDataItem[RPC_DD_DATAITEM_SIZE] = {
     DPL_DT_OPEN_STRUCT,0,sizeof(DPLDATAITEM),0,
     DPL_DT_U_SHORT,0,0,0,                          /* usDataType    */
     DPL_DT_U_SHORT,0,0,0,                          /* usSize        */
     DPL_DT_U_SHORT,0,0,0,                          /* usStructSize  */
     DPL_DT_DOUBLE,0,0, 0,                          /* DataVal       */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#endif /* RDMRPCDD_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/RDMRPCDD.H_V   1.12   18 Apr 1994 12:11:08   RICHM  $
*/
