/*----------------------------------------------------------------------------
   proto.h:  Velocis function declaration header file

   (This file must be included after dbtype.h)

   Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------------*/

#ifndef PROTO_H
#define PROTO_H

/* From rollbak.c: --------------------------------------*/
short RINTERNAL RollBackTx(
    unsigned short txid,
    unsigned long firstRec,
    const char *trmTrTag,
    short chgLogFile
);
short RINTERNAL uukSearch(
    short key_prefix,
    void *key_val,
    size_t keyLen
);
void RINTERNAL uukCreate(
    short key_prefix,
    void *key_val,
    size_t keyLen
);
void RINTERNAL uukDelete(
    void
);
void RINTERNAL rcvopencheck(
    unsigned short dbid
);

/* From chkpt.c: --------------------------------------*/
short RINTERNAL doCheckpoint(
    void
);
short RINTERNAL chk_active(
    void
);
void RINTERNAL chk_init(
    void
);
void RINTERNAL chk_cleanup(
    void
);
void RINTERNAL chk_check(
    void
);

/* From chlog.c: --------------------------------------*/
short RINTERNAL cycle_active(
    void
);

/* From discon.c: --------------------------------------*/
void verifySet(
    unsigned short set,
    DB_ADDR odba
);

/* From dberr.c: --------------------------------------*/
short RINTERNAL dberr(
    short error,
    short api,
    short occur,
    const char *auxerr
);

/* From dbfcns.c: -------------------------------------*/
void RINTERNAL rdmStartup(
    short runMinimal
);
void RINTERNAL rdmShutdown(
    void
);

short REXTERNAL d_openTempDB(
    const char RFAR *dbname,
    RDM_DBD RFAR *DBDict,
    RDM_SESS hSess,
    RDM_DB RFAR *hDb
);

short openDbHandle(
    char    *dbname,        /* name of database instance */
    short    openFlags,
    short    permaccess,
    RDM_DBD *DBDict
);

short findDbInstEntry(
    char    *dbname,        /* name of database instance */
    short    openFlags,
    RDM_DBD *DBDict,
    unsigned short *dbInst
);

OPEN_DBD *getOpenDbdEntry(
    char *dbname,         /* name of database instance */
    unsigned short *dbid,
    short openFlags,
    RDM_DBD *DBDict
);
void closeDbHandle(void);
void closeDbInstEntry(void);
void close_openDbdEntry(
    OPEN_DBD *odbd
);

/* From dio.c: ----------------------------------------*/
short RINTERNAL dio_open(
    unsigned short opdn,
    FILE_NO fno
);
short RINTERNAL dio_close(
    unsigned short opdn,
    FILE_NO fno
);
void RINTERNAL dio_init(
    void
);
void RINTERNAL dio_openSems(
    void
);
void RINTERNAL dio_cacheExtend(
    unsigned short maxPages
);
void RINTERNAL dio_free(
    void
);
void RINTERNAL dio_clrfile(
    FILE_NO fno
);
void RINTERNAL dio_flush(
    unsigned short opdn,
    unsigned short clearFlag
);
void RINTERNAL dio_setdef(
    FILE_NO file_no
);
void RINTERNAL dio_get(
    F_ADDR page_no,
    void **page_ptr,
    short hold,
    short newPage
);
void RINTERNAL dio_touch(
    F_ADDR page_no
);
void RINTERNAL dio_read(
    DB_ADDR dba,
    char **recptr,
    short hold,
    short newSlot
);
void RINTERNAL dio_write(
    DB_ADDR dba,
    short release
);
void RINTERNAL dio_release(
    DB_ADDR dba
);
void RINTERNAL dio_file_modified(
    FILE_STAT *fs_ptr
);

/* From pzfcns.c ----------------------------------*/
void RINTERNAL pz_init(
    void
);
void RINTERNAL pz_read(
    FILE_NO fno   /* file number */
);
void RINTERNAL pz_alloc(
    FILE_NO fno,  /* file number */
    F_ADDR *loc   /* pointer to allocated location */
);
short RINTERNAL pz_unalloc(
    FILE_NO fno,
    F_ADDR loc
);
short RINTERNAL pz_del(
    FILE_NO fno,  /* file number */
    F_ADDR loc    /* location to be freed */
);
short RINTERNAL pz_undel(
    DB_ADDR dba
);
F_ADDR RINTERNAL pz_next(
    FILE_NO fno
);
void RINTERNAL pz_clr(
    short opdn
);
void RINTERNAL pz_get(
    short rt,
    DB_ADDR dba
);

void RINTERNAL pz_setverbackstamp(
    unsigned long savesetid,
    short mode
);


/* From initial.c: ------------------------------------*/
short RINTERNAL InitFile(
    FILE_NO fno,
    char *name,
    DB_USHORT pgsize,
    char type
);

/* From keyfcns.c: ------------------------------------*/
void RINTERNAL key_open(
    void
);
void RINTERNAL key_init(
    unsigned short field	/* field number to be processed */
);
short RINTERNAL key_locpos(
    const char *key_val,    /* key search value */
    short nFields,  /* if not 0, number of fields of compound key to use */
    unsigned short partialStrLen, /* if not 0, length of last (char) field to
                                     match */
    DB_ADDR *dba,           /* database address of located key */
    short lockOpt           /* locking option */
);
short RINTERNAL key_scan(
    register short fcn,	/* next or prev */
    DB_ADDR *dba		/* db address of scanned record */
);

void RINTERNAL key_acpy(
    register char *dest,
    register const char *src,
    register unsigned short n );

short RINTERNAL key_boundary(
    short fcn,	/* KEYFRST or KEYLAST */
    DB_ADDR *dba	/* to get dba of first or last key */
);
short RINTERNAL key_insert(
    unsigned short fld,	/* key field number */
    char *key_val,	/* key value */
    DB_ADDR dba		/* record's database address */
);
short RINTERNAL key_delete(
    unsigned short fld,
    char *key_val,
    DB_ADDR dba
);
short RINTERNAL key_bldcom(
    unsigned short fld,	/* compound key field number */
    char *rec,		/* ptr to record data */
    char *key,		/* ptr to array to recv constructed key */
    short cflag	/* TRUE to complement compound descending keys */
);
void RINTERNAL key_cmpcpy(
    register char *dest,
    register const char *src,
    register unsigned short n
);
void RINTERNAL key_create(
    DB_ADDR db_addr,
    RECORD_ENTRY *rec_ptr,
    void *rec
);
short RINTERNAL key_depth(
    FILE_NO fno
);

/* From recover.c: ------------------------------------*/
short RINTERNAL AxRecover(
    void
);
short RINTERNAL TxRecover(
    void
);

/* From locking.c -------------------------------------*/
void REXTERNAL LaInit(
    unsigned short odnum,
    unsigned short rec,
    unsigned short set,
    unsigned short keyfiles
);
void REXTERNAL LaClose(
    unsigned short odnum
);
void REXTERNAL LaDelUser(
    RDM_SESS userID
);
short REXTERNAL LaGLock(
    GROUPLOCK *glock,
    size_t num,
    RDM_SESS userID,
    short use_timeout
);
short REXTERNAL LaFree(
    short level,
    unsigned short rstype,
    DB_ADDR dba,
    unsigned short odnum,
    RDM_SESS userID
);
short REXTERNAL LaGetLockStat(
    short level,
    unsigned short rstype,
    DB_ADDR dba,
    unsigned short odnum,
    RDM_SESS userID
);
short REXTERNAL LaRelease(
    short freeflag,
    RDM_SESS userID
);
short REXTERNAL LaTimeout(
    short nsecs,
    RDM_SESS userID
);
short REXTERNAL LaCreateRecPerm(
    unsigned short rstype,
    unsigned short odnum,
    RDM_SESS userID
);
short REXTERNAL LaInstancePerm(
    short urtype,
    short rstype,
    DB_ADDR dba,
    unsigned short odnum,
    RDM_SESS userID
);

/* From libfcns.c: ------------------------------------*/
void RINTERNAL BeginCacheMods(
    void
);
void RINTERNAL EndCacheMods(
    void
);
void RINTERNAL fatalExit(
    short apifcn,
    char *msg
);
void RINTERNAL inCatDir(
    char *baseName,
    char *fullName
);
short RINTERNAL gateKeeper(
    short opCode,
    DB_ADDR dba,
    short rstype
);
short RINTERNAL nset_check(
    register short nset,
    unsigned short *set,
    SET_ENTRY **set_ptr
);
short RINTERNAL nfld_check(
    register long nfld,
    short *rec,
    unsigned short *fld,
    RECORD_ENTRY ** rec_ptr,
    FIELD_ENTRY ** fld_ptr
);
short RINTERNAL nrec_check(
    short nrec,
    short *rec,
    RECORD_ENTRY **rec_ptr
);
short RINTERNAL fldcmp(
    register FIELD_ENTRY *fld_ptr,
    const char *f1,
    const char *f2,
    short nFields,  /* if not 0, number of fields of compound key to use */
    unsigned short partialStrLen, /* if not 0, length of last (char) field to
                                     match */
    DB_USHORT sortflag
);
short RINTERNAL ADDRcmp(
    DB_ADDR *d1,
    DB_ADDR *d2
);
short RINTERNAL null_dba(
    void *db_addr
);
short RINTERNAL check_dba(
    DB_ADDR dba
);

void RINTERNAL maskbuf(
    unsigned short buflen,
    register const char *m1,
    register const char *m2,
    register char *destbuf
);
void RINTERNAL xvalueExtend(
    size_t len
);

#if !defined(WATC) && !defined(__IBMC__) && !defined(__IBMCPP__) && !defined(__BORLANDC__) && !defined(MSC) && !defined(UNIX)
void RINTERNAL memmove(
    char *dest,
    char *src,
    unsigned len
);
#endif

void fpeHandler(
    short intr,
    short subcode
);
short RINTERNAL validFloat(
    float fp
);
short RINTERNAL validDouble(
    double db
);
short REXTERNAL usersort_d(
    short sort,			/* which sort case has been selected */
    void *f1,			/* first field value */
    void *f2,			/* second field value */
    unsigned char dataType,	/* field type, as in field_table */
    short *dimen,		/* 3 dimensions from field_table */
    short dataSize		/* field size, from field_table */
);

/* From makenew.c: ------------------------------------*/
short RINTERNAL sk_free(
    void
);

/* From recfcns.c: ------------------------------------*/
short RINTERNAL r_chkfld(
    DB_USHORT field,		/* field_table entry number */
    FIELD_ENTRY *fld_ptr,	/* corresponds to field */
    char *rec,			/* pointer to record slot */
    char *data			/* pointer to data area containing field
				   contents */
);
short RINTERNAL r_delrec(
    DB_SHORT rt,
    DB_ADDR db_addr
);
short RINTERNAL r_fieldwrite(
    long field,	/* field constant */
    void *data,		/* data area to contain field contents */
    DB_ADDR dba,        /* dba of effected record */
    short caller        /* caller constant for dberr report */
);
short RINTERNAL r_gfld(
    FIELD_ENTRY *fld_ptr,
    char *rec,			/* pointer to record */
    char *data			/* pointer to data area to contain field
				   contents */
);
short RINTERNAL r_gmem(
    unsigned short set,		/* set table entry number */
    char *rec,			/* pointer to record */
    void *mem_addr		/* pointer to member pointer */
);
short RINTERNAL r_gset(
    unsigned short set,		/* set table entry number */
    char *rec,			/* pointer to record */
    SET_PTR *setptr		/* pointer to set pointer */
);
short RINTERNAL r_pfld(
    DB_USHORT field,		/* field_table entry number */
    FIELD_ENTRY *fld_ptr,	/* corresponds to field */
    char *rec,			/* pointer to existing record */
    char *data,			/* pointer to data area containing new field
				   contents */
    DB_ADDR *db_addr,
    short struct_key_chk
);
short RINTERNAL r_pmem(
    unsigned short set,		/* set table entry number */
    char *rec,			/* pointer to record */
    void *mem_addr		/* pointer to member pointer */
);
short RINTERNAL r_pset(
    unsigned short set,		/* set table entry number */
    char *rec,			/* pointer to record */
    SET_PTR *setptr		/* pointer to set pointer */
);
short RINTERNAL r_smem(
    DB_ADDR db_addr,
    DB_USHORT set
);
short RINTERNAL r_setopt(
    FIELD_ENTRY *fld_ptr,	/* field table entry of optional key */
    char *rec			/* Pointer to record */
);
short RINTERNAL r_clropt(
    FIELD_ENTRY *fld_ptr,	/* Field table entry of optional key */
    char *rec			/* Pointer to record */
);
short RINTERNAL r_tstopt(
    FIELD_ENTRY *fld_ptr,	/* Field table entry of optional key */
    char *rec			/* Pointer to record */
);

/* From task.c ------------------------------------*/
short RINTERNAL db_enter(
    RDM_SESS hSess,
    RDM_DB hDb,
    short apifcn
);
short RINTERNAL db_exit(
    short x
);
void RINTERNAL clear_pgptrs(
    void
);

/* From mapchar.c ------------------------------------*/
short RINTERNAL ctb_mapchar(
    unsigned char instr,
    unsigned char outstr,
    char *sort_str,
    unsigned char subsort
);
short RINTERNAL ctb_mapstr(
    char *instr,
    char *outstr,
    char *sort_str,
    unsigned char subsort
);
	
short RINTERNAL ctb_init(
    void
);
short RINTERNAL ctbl_alloc(
    short tbn
);
void RINTERNAL ctbl_free(
    short tbn
);
short RINTERNAL ctb_findentry(
    short tbn,
    const unsigned char *instr,
    short *idx
);

#endif /* PROTO_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/PROTO.H_V   1.58   09 Feb 1995 13:00:08   BRADB  $
*/
