/*** Semaphore support */
#undef HSEM
#define HSEM void * _Seg16

#undef SEM_INDEFINITE_WAIT
#define SEM_INDEFINITE_WAIT	(-1L)
#define SEM_IMMEDIATE_RETURN	0L

USHORT APIENTRY16 DosSemClear(HSEM hsem);
USHORT APIENTRY16 DosSemSet(HSEM hsem);
USHORT APIENTRY16 DosSemWait(HSEM hsem, LONG lTimeOut);
USHORT APIENTRY16 DosSemSetWait(HSEM hsem, LONG lTimeOut);

typedef LHANDLE HSYSSEM;	/* hssm */
typedef HSYSSEM FAR *PHSYSSEM;

USHORT APIENTRY16 DosCreateSem(USHORT fExclusive, PHSYSSEM phsem, PSZ pszSemName);

#define CSEM_PRIVATE		0
#define CSEM_PUBLIC		1

USHORT APIENTRY16 DosCloseSem(HSEM hsem);

typedef struct _MUXSEM {	/* mxs */
	USHORT	zero;
	HSEM	hsem;
} MUXSEM;

typedef MUXSEM * _Seg16 PMUXSEM;

typedef struct _MUXSEMLIST {	/* mxsl */
	USHORT	cmxs;
	MUXSEM	amxs[16];
} MUXSEMLIST;
typedef MUXSEMLIST FAR *PMUXSEMLIST;

/*
 * Since a MUXSEMLIST structure is actually a variable length
 * structure, the following macro may be used to define a MUXSEMLIST
 * structure having size elements, named "name".
 */
#define DEFINEMUXSEMLIST(name, size) \
    struct {			     \
	USHORT cmxs;		     \
	MUXSEM amxs[size];	     \
    } name;

/*
 * This function actually takes a far pointer to a MUXSEMLIST structure
 * as its second parameter, but in order to allow its use with the
 * DEFINEMUXSEMLIST macro, it is declared here as PVOID.
 */
USHORT APIENTRY16 DosMuxSemWait(PUSHORT _Seg16 pisemCleared, PVOID _Seg16 pmsxl, LONG lTimeOut);
