/*-----------------------------------------------------------------------
   ffbag.h - routines to implement a "fixed-size fifo bag".

   A bag is a collection of pointers to objects, with no necessary ordering.
   Supported operations:  add, delete, iterate.

   NOTE!  ffBagAdd() copies the user's data into the fixed-length slot.

   Copyright (c) 1993-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------*/

/* Offsetof macro definition that doesn't draw warnings from PC-lint.
   WARNING -- the CSet compiler can't handle this.
*/
#if defined(PC_LINT) && defined(offsetof)
#undef offsetof
#define offsetof(s,m)   (size_t)((char *)&(((s *)0)->m) - (char *)0)
#endif

typedef void * FFBAG_MEM;       /* pointer to member of bag */

typedef struct {
    unsigned short ffb_total;   /* number of elements which are available */
    unsigned short ffb_inUse;   /* number of elements which are in use */
    unsigned short ffb_nextPush; /* index in array to store next pushed val */
    unsigned short ffb_memSize; /* sizeof(member) */
    char *ffb_memArray;         /* array of members */
} FFBAG;


short REXTERNAL ffBagCreate(
    unsigned short nMems,       /* number of members of pool */
    unsigned short memSize,     /* sizeof(member) */
    FFBAG **ppFfb,
    short **ppUserShort         /* long value for user to play with (in
                                   shared memory, along with the ffbag) */
);
short REXTERNAL ffBagPush(FFBAG *pBag, void *pVal);
short REXTERNAL ffBagPop(FFBAG *pBag, void *pVal);

/*
$Header:   P:/PAT/INCLUDE/VCS/FFBAG.H_V   1.1   18 Apr 1994 12:10:08   RICHM  $
*/

