/*
    File: DPL.H
 Purpose: Include module for Data Portability Layer.
  Author: Brian Scott
    Date: 7-8-92

 Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------------*/

#ifndef DPL_H
#define DPL_H

/******************* RETURN CODES **************************/
#define DPL_RC_SUCCESS            0
#define DPL_RC_INTERNAL_ERROR     1     
#define DPL_RC_TOO_LARGE          2
#define DPL_RC_INTEGER_OVERFLOW   3
#define DPL_RC_FLOAT_OVERFLOW     4
#define DPL_RC_INVALID_DATA_TYPE  5
#define DPL_RC_INVALID_MODE       6
#define DPL_RC_INSUFF_MEMORY      7
#define DPL_RC_INVALID_ITEM       8
#define DPL_RC_INTEGER_UNDERFLOW  9
#define DPL_RC_FLOAT_UNDERFLOW    10
#define DPL_RC_DOUBLE_OVERFLOW    11
#define DPL_RC_DOUBLE_UNDERFLOW   12

/***************** MACROS *************************************/
#define isTypeChar(a)        (a & DPL_DT_CHAR)
#define isTypeDouble(a)      (a & DPL_DT_DOUBLE)
#define isTypeFloat(a)       (a & DPL_DT_FLOAT)
#define isTypeInt(a)         (a & DPL_DT_INT)
#define isTypeLong(a)        (a & DPL_DT_LONG)
#define isTypeShort(a)       (a & DPL_DT_SHORT)
#define isTypeString(a)      (a & DPL_DT_STRING)
#define isTypeUChar(a)       (a & DPL_DT_U_CHAR)
#define isTypeUInt(a)        (a & DPL_DT_U_INT)
#define isTypeULong(a)       (a & DPL_DT_U_LONG)
#define isTypeUShort(a)      (a & DPL_DT_U_SHORT)
#define isTypeOpaque(a)      (a & DPL_DT_OPAQUE)
#define isTypeOpenStruct(a)  (a & DPL_DT_OPEN_STRUCT)
#define isTypeCloseStruct(a) (a & DPL_DT_CLOSE_STRUCT
#define isTypeDataDesc(a)    (a & DPL_DT_DATA_DESC)
#define isTypeAsciz(a)       (a & DPL_DT_ASCIZ)
#define isModArray(a)        ((a & DPL_DT_MOD_ARRAY) >> 8)
#define isModSrcRef(a)       ((a & DPL_DT_MOD_SOURCE_REF) >> 8)
#define isModTargRef(a)      ((a & DPL_DT_MOD_TARGET_REF) >> 8)
#define isModAligned(a)      ((a & DPL_DT_MOD_ALIGNED) >> 8)
#define isModEOS(a)          ((a & DPL_DT_MOD_END_OF_STRUCT) >> 8)
#define isModFreeMem(a)      ((a & DPL_DT_MOD_FREE_MEM) >> 8)
#define isModNullPtr(a)      ((a & DPL_DT_MOD_NULL_PTR) >> 8)
#define isModeAlign(a)       (a & DPL_MODE_ALIGN)
#define isModeIgnOvf(a)      (a & DPL_MODE_IGNORE_OVF)
#define getDataType(a)       (a & DPL_DT_MASK)

/********************* FUNCTION PROTOTYPES *****************/
short REXTERNAL d_getDD(
    short           sItem,
    long            lElement,
    short           *psItemCnt,
    short           *psLength,
    PDPLDATAITEM    *ppDD,
    RDM_DB hDb
);

unsigned short REXTERNAL dpl_decode(PDPLDATADESC *,void *, unsigned short,
    unsigned char);
unsigned short REXTERNAL dpl_encode(PDPLDATADESC, void **, unsigned short *,
    unsigned char, unsigned char, unsigned short *);

PDPLDATAITEM REXTERNAL dpl_addDataItem(PDPLDATAITEM, unsigned short,
    unsigned short);
unsigned short REXTERNAL dpl_putToDataStream(PDPLDATAITEM *,
                                            unsigned short, unsigned short,
                                            unsigned short, void *, void **, 
                                            unsigned short *);
unsigned short REXTERNAL dpl_init(void);
void           REXTERNAL dpl_term(void);

#endif /* DPL_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/DPL.H_V   1.17   18 Apr 1994 12:09:58   RICHM  $
*/
