/*-----------------------------------------------------------------------
  dfsproto - Direct File System Prototypes

  Original version by Mike Geiger, 03/12/93.

  Copyright (c) 1993-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------*/

#ifndef DFSPROTO_H
#define DFSPROTO_H

#define DFSMAX 100      /* maximum number of dfs files */
/* [WLW] the former test (handle<100) is invalid on Netware 4.01 because
         file handles are low numbers
*/
#define DFSTST(vfd)     (0) /* ((unsigned int) vfd < DFSMAX ? 1 : 0) */

int dfscreate (char *fnp);
int dfsopen (char *fnp);
int dfsexp (unsigned long vfd, unsigned long size);
int dfsdocls (unsigned long vfd, int flag);
int dfsseqseek (unsigned long vfd, unsigned long pos, int sense);
int dfsseqwrite (unsigned long vfd, char *buf, int len);
int dfsseqread (unsigned long vfd, char *buf, int len);
int dfschk (char *fnp);
void dfsdone (void);
int dfsfsz (unsigned long vfd);

#endif /* DFSPROTO_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/DFSPROTO.H_V   1.3   18 Apr 1994 12:09:56   RICHM  $
*/
