/*----------------------------------------------------------------------------
   dbxtrn.h:  Velocis external data header file

   Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------------*/

#ifndef DBXTRN_H
#define DBXTRN_H

/* Database Dictionary Tables */
extern DB_USHORT largest_page;


/* NOTE: any additions/deletions/modifications to this section must be 
	 mirrored is the definition section in task.c.
*/
/* The following three global variables, od, db and gl, are almost always
   assumed to be set up.  The gl variable should point to the current task's
   task parameter.  The db variable should point to the current db_table
   element of gl, based on the current database, curr_db.  The od variable
   should point to the current open_db_table element which corresponds to
   db_table->odn.

   These variables need to be saved on the stack every time a yield to the
   scheduler occurs (usually through the schBlock call).  They are to be
   restored from the stack when returning from the yield.
*/
extern OPEN_DB_ENTRY *od;	     /* pointer into open_db_table */
extern DB_ENTRY      *db;	     /* pointer into a db_table */
extern TASK	         *gl;	     /* pointer to current task structure */

/* global variables */
extern struct sysconfig sysrec;      /* system configuration from catalog */
extern OPEN_DB_ENTRY **open_db_table;/* table of open databases */
extern unsigned short opdb_size;     /* open database table size */
extern HASH_ENTRY    *hashTable;     /* database hash table */
extern unsigned short hashTableSize; /* database page table size */
extern char           catpath[FILENMLEN]; /* location of the Catalog */
extern char           chgLogDevicePath[FILENMLEN]; /* change log device path */
extern unsigned long  chgBufSize;    /* maximum allocation for change log buffer */
extern unsigned short chgMaxTreWait; /* maximum wait for trend buffering */
extern short          recovReadOnly; /* only allow recoverable read locks, ie. d_release after chg_wrTRE */
extern short          max_trends;    /* maximum number of trends to wait for */
extern short          txTimeout;     /* timeout value for schRecvSem in d_trbegin */
extern short          cycleTimeout;  /* timeout value for schWait in cycle */
extern char           chkptFileName[FULLPATHLEN];  /* full checkpoint file */
extern char          *country_tbl[2];   /* country tables one for single chars, double chars */
extern short          ctbl_size[2];  /* country table size */
extern short          ctbl_idx[2];   /* country table index */
extern short          ctb_activ;     /* state of country table */
extern unsigned short recover_redo;  /* in REDO phase of recovery (don't checkpoint) */
extern unsigned long  chkCurSize;    /* number of bytes to be written to chkpt */
extern unsigned short chkNumEntries; /* number of committed checkpoint entries */
extern unsigned short chkNumFiles;   /* number of modified files */
extern unsigned short chkNumPages;   /* number of modified dio pages */
extern unsigned short chkThreshold;  /* cache fill level before checkpoint */
extern PAGE_ENTRY   **chkTable;      /* array of PAGE_ENTRY pointers to be checkpointed */
extern unsigned short chkTableSize;  /* size of chkptTable */
extern RPARMS         rdmparms;      /* catalog parms that affect rdm.dll */
extern short          checkpointSem; /* multiple checkpoint protection */
extern short          asyncReadSem;  /* protection from simultaneous reading of pages */
extern unsigned short max_d_call_depth; /* max d_ call depth */

extern short          chkptSem;      /* permission for checkpoint to proceed */
extern short          wrCHESem;      /* coordinate chg_CheckCycle with checkpoint */
extern short          chLogSem;      /* used because the CHB, CHW and CHE
                                        records are written from the
                                        checkpoint() thread */
extern short          chkThreadSem;  /* used to launch chkpt thread */
extern short          chkPercentage; /* checkpoint threshold */
extern short          yieldFrequency; /* d_ Yield frequency */
extern short          chgcycThreadSem;  /* used to launch cycle thread */
extern short          asyncRead;     /* [WLW] use catalog! */
extern short          asyncWrite;    /* [WLW] use catalog! */

extern char          *compat_dbd[];
extern short          size_compat;
extern short	      db_status;
extern char           srvName[];
extern unsigned long  flExtendSize;
extern long           chkptTimeout;

extern FILE_STAT    **fsTable;       /* table of modified file stat entries */
extern unsigned short fsTableSize;   /* number of entries in fsTable */

extern unsigned int   chgBufOfs;      /* offset needs to be referenced */
extern unsigned long  chgLogOfs;

extern short          growCachePages; /* allow cache pages to grow to largest page size */
extern short          growChgMsgs;   /* pool changed log messages allowing them to grow in size */
extern short          growNcpMsgs;   /* pool ncp messages allowing them to grow in size */

extern short          lockTag;       /* Lock arbiter allocation tag */

#ifndef __BORLANDC__
#ifndef _MSC_VER
#ifdef UNIX
extern int errno;
#elif !defined(WATC) && !defined(__IBMC__) && !defined(__IBMCPP__)
extern short errno;
#endif
#endif
#endif
#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/DBXTRN.H_V   1.51   01 Mar 1995 10:13:16   BRADB  $
*/
