/*---------------------------------------------------------------
 Velocis -- RPC data descriptors for CATALOG structures.

 Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------- */

#ifndef  CATRPCDD_H
#define  CATRPCDD_H

#ifndef NO_NESTED_H
#include "dpldefs.h"
#include "catalog.h"
#endif

/***************************************************************************/
/*  IMPORTANT:  Any changes to the following data descriptors must be      */
/*              reflected in the data descriptors in ADMRPCDD.H since      */
/*              these are contained in them.                               */
/***************************************************************************/

#ifdef SERVER_DD
#define DO_FREE_MEM DPL_DT_MOD_FREE_MEM
#else
#define DO_FREE_MEM 0
#endif

/**************************************************************************/
/*                                                                        */
/*   RPC Data Descriptor's for the catalog's data structures.             */
/*                                                                        */
/**************************************************************************/

#define RPC_DD_SYSCONFIG_SIZE 26

static DPLDATAITEM aRpcDDSysConfig[RPC_DD_SYSCONFIG_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct sysconfig),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,12,0,0, /* servername */
     DPL_DT_U_SHORT, 0,0,0,                 /* maxpages   */
     DPL_DT_U_SHORT, 0,0,0,                 /* maxlocks   */
     DPL_DT_U_SHORT, 0,0,0,                 /* maxibsize  */
     DPL_DT_U_SHORT, 0,0,0,                 /* maxobsize  */
     DPL_DT_U_SHORT, 0,0,0,                 /* maxdbopen  */
     DPL_DT_U_SHORT, 0,0,0,                 /* maxuseron  */
     DPL_DT_U_SHORT, 0,0,0,                 /* maxuserslicensed  */
     DPL_DT_U_SHORT, 0,0,0,                 /* numthrds   */
     DPL_DT_U_SHORT, 0,0,0,                 /* numpthrds  */
     DPL_DT_SHORT,   0,0,0,                 /* thrdfair   */
     DPL_DT_U_SHORT, 0,0,0,                 /* dbid_seq   */
     DPL_DT_U_SHORT, 0,0,0,                 /* delaytre   */
     DPL_DT_U_SHORT, 0,0,0,                 /* archon     */
     DPL_DT_U_LONG,  0,0,0,                 /* maxchksize */
     DPL_DT_U_LONG,  0,0,0,                 /* maxlogsize */
     DPL_DT_LONG,    0,0,0,                 /* memlimit   */
     DPL_DT_U_SHORT, 0,0,0,                 /* filelimit  */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0,  /* chlog_cycle*/
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,10,0,0, /* chlogdev   */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,10,0,0, /* chkptdev   */
     DPL_DT_U_SHORT, 0,0,0,                 /* backupid   */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,40,0,0, /* customername */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,30,0,0, /* serialnum*/
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};


#define RPC_DD_USERINF_SIZE 5

static DPLDATAITEM aRpcDDUserInf[RPC_DD_USERINF_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct userinf),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,15,0,0, /* username */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0,  /* userpass */
     DPL_DT_CHAR,0,0,0,                     /* userpriv */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_DEVICE_SIZE 4

static DPLDATAITEM aRpcDDDevice[RPC_DD_DEVICE_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct device),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,10,0,0,     /* devname */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,48,0,0,     /* devpath */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_DBASE_SIZE 8

static DPLDATAITEM aRpcDDDBase[RPC_DD_DBASE_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct dbase),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,12,0,0,     /* dbdname    */
     DPL_DT_U_SHORT,0,0,0,                      /* dbid       */
     DPL_DT_LONG,0,0,0,                         /* datecreate */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0,      /* createchg  */
     DPL_DT_U_LONG,0,0,0,                       /* createofs  */
     DPL_DT_CHAR,0,0,0,                         /* dbaccess   */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_FILEINF_SIZE 3

static DPLDATAITEM aRpcDDFileInf[RPC_DD_FILEINF_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct fileinf),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,16,0,0,     /* rds_filename  */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_DBACCREC_SIZE 4

static DPLDATAITEM aRpcDDDBAccRec[RPC_DD_DBACCREC_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct fileinf),0,
     DPL_DT_SHORT,0,0,0,     /* permaccess  */
     DPL_DT_SHORT,0,0,0,     /* ownerdb     */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};


#define RPC_DD_GROUPNAME_SIZE 4

static DPLDATAITEM aRpcDDGroupName[RPC_DD_GROUPNAME_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct groupname),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0,     /* grpname  */
     DPL_DT_SHORT,0,0,0,                       /* dbavail  */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_BACKUPINF_SIZE 6

static DPLDATAITEM aRpcDDBackupInf[RPC_DD_BACKUPINF_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct backupinf),0,
     DPL_DT_U_LONG,0,0,0,                  /* savesetid  */
     DPL_DT_U_LONG,0,0,0,                  /* backtime   */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0, /* backchg    */
     DPL_DT_U_LONG,0,0,0,                  /* backofs    */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_IGNREGION_SIZE 6

static DPLDATAITEM aRpcDDIgnRegion[RPC_DD_IGNREGION_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct ign_region),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0,   /* chgnamest  */
     DPL_DT_U_LONG,0,0,0,                    /* startofs   */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,8,0,0,   /* chgnameend */
     DPL_DT_U_LONG,0,0,0,                    /* endofs     */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#define RPC_DD_EXTMODULE_SIZE 3

static DPLDATAITEM aRpcDDExtModule[RPC_DD_EXTMODULE_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM,0,sizeof(struct extmodule),0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY,12,0,0,    /* emname  */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT,0,0,0};

#endif /* CATRPCDD_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/CATRPCDD.H_V   1.7   18 Apr 1994 12:09:42   RICHM  $
*/
