/*-------------------------------------------------------------------------
    calproto.h  -  RSQL datetime defines/structures and prototypes.

    Used on server side.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-------------------------------------------------------------------------*/

#ifndef CALPROTO_H
#define CALPROTO_H
#include "caldefs.h"

#define MAX_PRECISION        10000L
#define MAX_SECONDS_PER_DAY  86399L
#define MAX_TIME             863999999L
#define MAX_MINUTES_PER_DAY   1439

short REXTERNAL calToDateVal        (CAL_ID, CAL_DATE *, DATE_VAL *);
short REXTERNAL calFromDateVal      (CAL_ID, DATE_VAL, CAL_DATE *);
short RINTERNAL calDayOfMonth       (CAL_ID, DATE_VAL, short *);
short RINTERNAL calDayOfWeek        (CAL_ID, DATE_VAL, short *);
short RINTERNAL calMonth            (CAL_ID, DATE_VAL, short *);
short RINTERNAL calQuarter          (CAL_ID, DATE_VAL, short *);
short RINTERNAL calWeek             (CAL_ID, DATE_VAL, short *);
short RINTERNAL calYear             (CAL_ID, DATE_VAL, TIME_VAL *);
short RINTERNAL calNameOfMonth      (CAL_ID, DATE_VAL, char *, short);
short RINTERNAL calAbrNameOfMonth   (CAL_ID, DATE_VAL, char *, short);
short RINTERNAL calNameOfWeekDay    (CAL_ID, DATE_VAL, char *, short);
short RINTERNAL calAbrNameOfWeekDay (CAL_ID, DATE_VAL, char *, short);

short REXTERNAL calToTimeVal        (CAL_TIME *, TIME_VAL *);
short REXTERNAL calFromTimeVal      (TIME_VAL, CAL_TIME *);
short RINTERNAL calToday            (CAL_ID, DATE_VAL *);
short RINTERNAL calNow              (CAL_ID, DATE_VAL *, TIME_VAL *);

/* mask off extra calendars until implemented */
#define  CAL_ISO_H
#define  isoToDateVal(a,b,c)              0
#define  isoFromDateVal(a,b,c)            0
#define  isoDayOfMonth(a,b,c)             0
#define  isoDayOfWeek(a,b,c)              0
#define  isoMonth(a,b,c)                  0
#define  isoQuarter(a,b,c)                0
#define  isoWeek(a,b,c)                   0
#define  isoYear(a,b,c)                   0
#define  isoNameOfMonth(a,b,c,d)          0
#define  isoAbrNameOfMonth(a,b,c,d)       0
#define  isoNameOfWeekDay(a,b,c,d)        0
#define  isoAbrNameOfWeekDay(a,b,c,d)     0

#define  CAL_ISL_H
#define  islToDateVal(a,b,c)             0
#define  islFromDateVal(a,b,c)           0
#define  islDayOfMonth(a,b,c)             0
#define  islDayOfWeek(a,b,c)              0
#define  islMonth(a,b,c)                  0
#define  islQuarter(a,b,c)                0
#define  islWeek(a,b,c)                   0
#define  islYear(a,b,c)                   0
#define  islNameOfMonth(a,b,c,d)          0
#define  islAbrNameOfMonth(a,b,c,d)       0
#define  islNameOfWeekDay(a,b,c,d)        0
#define  islAbrNameOfWeekDay(a,b,c,d)     0

#endif /* CALPROTO_H */
/*
$Header:   P:/PAT/INCLUDE/VCS/CALPROTO.H_V   1.14   18 Apr 1994 12:09:38   RICHM  $
*/
