/*-------------------------------------------------------------------------
    caldefs.h  -  SQL datetime defines/structures and prototypes.

    Used on both client and server side.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-------------------------------------------------------------------------*/

#ifndef CALDEFS_H
#define CALDEFS_H

#define SQL_MAX_PRECISION   32
#define SQL_MAX_SCALE       16

typedef struct cal_date {
    long  year;
    short month;
    short day;
} CAL_DATE;

typedef struct cal_time {
    short hour;
    short minute;
    short second;
    short fraction;
} CAL_TIME;

/* Calander IDs to identify supported calendars, used by calFCNS */
typedef enum {
    GREGORIAN=0,
    GREGORIAN_GB,
    ISO,
    JULIAN,
    ISLAMIC,
    HEBREW
} CAL_ID;

typedef long DATE_VAL;
typedef long TIME_VAL;

typedef struct {
    DATE_VAL date;
    TIME_VAL time;
} TIMESTAMP_VAL;

#endif /* CALDEFS_H */
/*
$Header:   P:/PAT/INCLUDE/VCS/CALDEFS.H_V   1.1   18 Apr 1994 12:12:20   RICHM  $
*/

