/*----------------------------------------------------------------------
   admproto.h - Velocis server administrator function definitions.

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef ADMPROTO_H
#define ADMPROTO_H

#ifdef __cplusplus
extern "C" {
#endif

short REXTERNAL s_maxusers(
    unsigned short UserLimitArg,
    char RFAR *companyName,
    char RFAR *password,
    RDM_SESS hSess
);
short REXTERNAL s_statistics(
    long RFAR *stats,
    short bufLen,
    RDM_SESS hSess
);
short REXTERNAL s_devAdd(
    struct device RFAR *dev,
    RDM_SESS hSess
);
short REXTERNAL s_dbAdd(
    const DBD_DBF RFAR *dbase,
    FILEDEV RFAR *filedev,
    short bufflen,
    RDM_SESS hSess
);
short REXTERNAL s_dbClone(
    const char RFAR *dbToClone, /* name of database instance */
    const char RFAR *cloneName, /* name of new database derived by cloning */
    const char RFAR *devName,   /* device on which to put new database */
    short copyFiles,            /* TRUE ==> copy old files, otherwise
                                   initialize them */
    RDM_SESS hSess              /* caller's session handle */
);

short REXTERNAL s_emAdd(
    EM_CHG RFAR *extmod,
    RDM_SESS hSess
);
short REXTERNAL s_userAdd(
    USERINF_CHG RFAR *user,
    RDM_SESS hSess
);
short REXTERNAL s_configModify(
    struct sysconfig RFAR *sysco,
    RDM_SESS hSess
);
short REXTERNAL s_iniSet(
    char RFAR *section,
    char RFAR *entry,
    char RFAR *value,
    RDM_SESS hSess
);
short REXTERNAL s_iniGet(
    char RFAR *section,
    char RFAR *entry,
    char RFAR *buffer,
    short      length,
    short      flag,
    RDM_SESS hSess
);
short REXTERNAL s_iniSetPrivate(
    char RFAR *section,
    char RFAR *entry,
    char RFAR *value,
    char RFAR *devName,
    char RFAR *iniName,
    RDM_SESS hSess
);
short REXTERNAL s_iniGetPrivate(
    char RFAR *section,
    char RFAR *entry,
    char RFAR *buffer,
    short      length,
    short      flag,
    char RFAR *devName,
    char RFAR *iniName,
    RDM_SESS hSess
);
short REXTERNAL s_shutdown(
    char RFAR *serverName,
    char RFAR *userName,
    char RFAR *userPW
);
short REXTERNAL s_dbModify(
    const DBD_DBF RFAR *dbase,
    const FILEDEV RFAR *filedev,
    short bufflen,
    RDM_SESS hSess
);
short REXTERNAL s_devModify(
    struct device RFAR *device,
    RDM_SESS hSess
);
short REXTERNAL s_emModify(
    EM_CHG RFAR *extmod,
    RDM_SESS hSess
);
short REXTERNAL s_userModify(
    USERINF_CHG RFAR *user,
    RDM_SESS hSess
);
short REXTERNAL s_clrshutdown(
    RDM_SESS hSess
);
short REXTERNAL s_sendfile(
    char  RFAR *filename,
    char  RFAR *devkey,
    short  trop,
    char  RFAR *buff,
    short  bufflen,
    RDM_SESS hSess
);
short REXTERNAL s_recvfile(
    char  RFAR *filename,
    char  RFAR *devkey,
    short  trop,
    char  RFAR *buff,
    short  bufflen,
    short RFAR *actuallen,
    RDM_SESS hSess
);
short REXTERNAL s_backupAdd(
    char RFAR *family,
    RDM_SESS hSess
);
short REXTERNAL s_backupIgnoreAdd(
    char RFAR *family,
    struct ign_region RFAR *ignrec,
    RDM_SESS hSess
);
short REXTERNAL s_familyAdd(
    struct groupname RFAR *groupname,
    RDM_SESS hSess
);
short REXTERNAL s_familyModify(
    struct groupname RFAR *groupname,
    RDM_SESS hSess
);
short REXTERNAL s_familyDel(
    struct groupname RFAR *groupname,
    RDM_SESS hSess
);
short REXTERNAL s_familyMemAdd(
    char RFAR *groupkey,
    char RFAR *dbasekey,
    RDM_SESS hSess
);
short REXTERNAL s_familyMemDel(
    char RFAR *groupkey,
    char RFAR *dbasekey,
    RDM_SESS hSess
);
short REXTERNAL s_backupGet(
    char RFAR *family,
    unsigned long savesetid,
    struct backupinf RFAR *backuprec,
    RDM_SESS hSess
);
short REXTERNAL s_backupStampVerify(
    char RFAR *family,
    unsigned long savesetid,
    short mode,
    RDM_SESS hSess
);
short REXTERNAL s_dbDel(
    const char RFAR *dbkey,
    RDM_SESS hSess
);
short REXTERNAL s_devDel(
    char RFAR *devkey,
    RDM_SESS hSess
);
short REXTERNAL s_emDel(
    char RFAR *extmod,
    RDM_SESS hSess
);
short REXTERNAL s_userDel(
    char RFAR *usekey,
    RDM_SESS hSess
);
short REXTERNAL s_loginDisable(
    RDM_SESS hSess
);
short REXTERNAL s_loginEnable(
    RDM_SESS hSess
);
short REXTERNAL s_errinfo(
    short error,
    char  RFAR *errbuf,
    short length,
    RDM_SESS hSess
);
short REXTERNAL s_configGet(
    struct sysconfig RFAR *sysco,
    RDM_SESS hSess
);
short REXTERNAL s_dbGet(
    const char RFAR *dbkey,
    DBD_DBF RFAR *dbase,
    RDM_SESS hSess
);
short REXTERNAL s_devGet(
    const char RFAR *devkey,
    struct device RFAR *device,
    RDM_SESS hSess
);
short REXTERNAL s_emGet(
    char RFAR *emkey,
    EM_CHG RFAR *extmod,
    RDM_SESS hSess
);
short REXTERNAL s_familyGet(
    char RFAR *grpkey,
    struct groupname RFAR *groupname,
    RDM_SESS hSess
);
short REXTERNAL s_userGet(
    char RFAR *userkey,
    USERINF_CHG RFAR *user,
    RDM_SESS hSess
);
short REXTERNAL s_dbInit(
    const char RFAR *dbkey,
    RDM_SESS hSess
);
short REXTERNAL s_dbInitfile(
    FILE_NO fno,
    RDM_DB hDb
);
short REXTERNAL s_dbUserAdd(
    const char RFAR *user,
    const char RFAR *dbase,
    short ownerdb,
    short permaccess,
    RDM_SESS hSess
);
short REXTERNAL s_dbUserDel(
    const char RFAR *user,
    const char RFAR *dbase,
    RDM_SESS hSess
);
short REXTERNAL s_dbUserGet(
    const char RFAR *user,
    const char RFAR *dbase,
    struct dbaccrec RFAR *dbaccrec,
    RDM_SESS hSess
);
short REXTERNAL s_showDevs(
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showServers(
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showUsers(
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showDbs(
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showEms(
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showDbUsers(
    char RFAR *dbkey,
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showDbFiles(
    char RFAR *dbkey,
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showUserDbs(
    char RFAR *usrkey,
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showFamilys(
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showFamilyMems(
    char RFAR *grpkey,
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showBackupIgnores(
    char RFAR *grpkey,
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);
short REXTERNAL s_showBackups(
    char RFAR *grpkey,
    short pos,
    short nelems,
    void RFAR *buf,
    short buflen,
    short RFAR *actualelem,
    RDM_SESS hSess
);

short REXTERNAL s_systemLogOptWrite(
    char RFAR *msg,
    RDM_SESS hSess
);

short REXTERNAL s_systemLogWrite(
    char RFAR *msg,
    RDM_SESS hSess
);

short REXTERNAL s_getDbdFilenames(
    const char RFAR *dbname,
    const char RFAR *dbdname,
    const char RFAR *devkey,
    char RFAR * RFAR *buf,
    short RFAR *actualelem,
    RDM_SESS hSess
);

short REXTERNAL s_version(
    char RFAR **pVersion,
    RDM_SESS hSess
);

short REXTERNAL s_bomb(
    RDM_SESS hSess
);

short REXTERNAL s_getDiskFreeSpace(
    unsigned long RFAR *pAvail,
    char RFAR *devname,
    RDM_SESS hSess
);

short REXTERNAL s_setMinFreeSpace(
    unsigned long minFree,
    RDM_SESS hSess
);

#ifdef __cplusplus
}
#endif

#endif /* ADMPROTO_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/ADMPROTO.H_V   1.23   29 Dec 1994 16:35:00   DARINN  $
*/
