/* Configuration file for HP LaserJet PCL V                        27.12.1992 */
/* ----------------------------------------                                   */

/*----------------------------------------------------------------------------*/

( PN                                                /* Printer Names resource */

    "HP LaserJet PCL Level IV",                              /* printer names */
    "HP LaserJet PCL Level V"
),

/*----------------------------------------------------------------------------*/

( TP                                                       /* TwinaX resource */

    1,                                                      /* device address */
    5219,                                                        /* emulation */
    2,                                                    /* default language */
    0,                                                      /* default drawer */
    $87,                                                  /* escape character */
    1                                                          /* escape mode */
),

/*----------------------------------------------------------------------------*/

( ER                                              /* Exception Reply resource */

   ( $0002, $7202 ),              /* supress invalid media x-extent exception */
   ( $0002, $7302 )               /* supress invalid media y-extent exception */
),

/*----------------------------------------------------------------------------*/

( PI                                       /* Printer Initialization resource */

    "$0D$1BE$1B(s0P$1B&l1L"                       /* selection sequence */
    "$1B&f700y0X$1B*p-6Y_$08$1B*p+6Y$1B&f1X",

    "$1BE$1B(10U",                                    /* deselection sequence */

    1                                  /* parameter reselection on every page */
),

/*----------------------------------------------------------------------------*/

( PD                                            /* Power on Defaults resource */

    144,                                          /* default pitch in 1/1440" */
    240,                                   /* default line density in 1/1440" */
    1,                                                       /* print quality */
    132,                                                /* default line length */
    70                                                 /* default page length */
),

/*----------------------------------------------------------------------------*/

( OR                                             /* Output Reduction resource */

    0,                                     /* default top margin in 1/1440" */
    0,                                    /* default left margin in 1/1440" */
    7,                                        /* COR line distance multiplier */
    10                                           /* COR line distance divisor */
),

/*----------------------------------------------------------------------------*/

( MO                                           /* Medium Orientation resource */

    ( $0000, "$1B&l0o-51u+0Z$1B&l3E" ),            /* rotate medium 0 degree */
    ( $2D00, "$1B&l1o+0u-24Z$1B&l3E" ),           /* rotate medium 90 degree */
    ( $5A00, "$1B&l2o-51u+0Z$1B&l3E" ),          /* rotate medium 180 degree */
    ( $8700, "$1B&l3o+0u-24Z$1B&l3E" )           /* rotate medium 270 degree */
  ),

/*----------------------------------------------------------------------------*/

( TO                                             /* Text Orientation resource */

    ( $0000, "$1B&a0P" ),                             /* rotate text 0 degree */
    ( $2D00, "$1B&a270P" ),                          /* rotate text 90 degree */
    ( $5A00, "$1B&a180P" ),                         /* rotate text 180 degree */
    ( $8700, "$1B&a90P" )                           /* rotate text 270 degree */
),

/*----------------------------------------------------------------------------*/

( PM                                                 /* Paper Medium resource */

    (
      0,                                                          /* drawer 1 */
      11880, 16800,                      /* paper width and height in 1/1440" */
      11400, 16320,             /* printable area width and height in 1/1440" */
      240, 240,           /* left and top offset of printable area in 1/1440" */
      0,                                                          /* reserved */

      "$1B&l1H",                                          /* selection string */
      "$0C"                                             /* deselection string */
    ),
    (
      1,                                                          /* drawer 2 */
      11880, 16800,                      /* paper width and height in 1/1440" */
      11400, 16320,             /* printable area width and height in 1/1440" */
      240, 240,           /* left and top offset of printable area in 1/1440" */
      0,                                                          /* reserved */

      "$1B&l4H",                                          /* selection string */
      "$0C"                                             /* deselection string */
    ),
    (
      64,                                                  /* envelope feeder */
      7200, 11520,                       /* paper width and height in 1/1440" */
      7200, 11520,              /* printable area width and height in 1/1440" */
      240, 240,           /* left and top offset of printable area in 1/1440" */
      0,                                                          /* reserved */

      "$1B&l3H",                                          /* selection string */
      "$0C"                                             /* deselection string */
    ),
    (
      99,                                                      /* manual feed */
      11880, 16800,                      /* paper width and height in 1/1440" */
      11400, 16320,             /* printable area width and height in 1/1440" */
      240, 240,           /* left and top offset of printable area in 1/1440" */
      0,                                                          /* reserved */

      "$1B&l2H",                                          /* selection string */
      "$0C"                                             /* deselection string */
    )
),

/*----------------------------------------------------------------------------*/

( OS                                               /* Offset Stacker resource */

    "$1B&l1T"                                               /* job seperation */
),


/*----------------------------------------------------------------------------*/

( SC                                              /* Surface Control resource */

    ( 0, "$1B&l0S" ),                                     /* simplex printing */
    ( 1, "$1B&l1S" ),                            /* long edge duplex printing */
    ( 2, "$1B&l2S" )                   /* short edge (tumble) duplex printing */
),

/*----------------------------------------------------------------------------*/

( BN
  ( $00,"$1B&l4H"), 				       /* Lower Cassette Tray */
  ( $01,"$1B&l1H")						   /* MP Tray */
),

/*----------------------------------------------------------------------------*/

( HM                                          /* Horizontal Movement resource */

    3,                                  /* positioning type is absolute moves */
    (
      "$1B*p",                   /* start sequence for horizontal positioning */
      1, 1,                              /* resolution of parameter is 1/300" */
      0, 10,                       /* no offset, parameter passing is decimal */
      "X"                      /* trailer sequence for horizontal positioning */
    )
),

/*----------------------------------------------------------------------------*/

( HJ                                     /* Horizontal Justification resource */

    1,                                  /* positioning type is relative moves */
    (
      "$1B*p+",                /* start sequence for horizontal justification */
      1, 1,                              /* resolution of parameter is 1/300" */
      0, 10,                       /* no offset, parameter passing is decimal */
      "X"                    /* trailer sequence for horizontal justification */
    )
),

/*----------------------------------------------------------------------------*/

( VM                                            /* Vertical Movement resource */

    3,                                  /* positioning type is absolute moves */
    (
      "$1B*p",                     /* start sequence for vertical positioning */
      1, 1,                              /* resolution of parameter is 1/300" */
      0, 10,                       /* no offset, parameter passing is decimal */
      "Y"              /* $1B*p-100Y trailer sequence for vertical positioning */
    )
),

/*----------------------------------------------------------------------------*/

( CP                                            /* Character Pitches resource */

    ( $0120, 244 ),                                  /* 5 characters per inch */
    ( $0090,  11 ),                                 /* 10 characters per inch */
    ( $0078,  66 ),                                 /* 12 characters per inch */
    ( $0060, 230 ),                                 /* 15 characters per inch */
    ( $0054, 252 ),                                 /* 17 characters per inch */
    ( $0048, 281 )                                  /* 20 characters per inch */
),

/*----------------------------------------------------------------------------*/

( FA                                              /* Font Attributes resource */

    ( "$1B(s3B",   "$1B(s0B" ),                  /* turn bold printing on/off */
    ( "$1B(s1S",   "$1B(s0S" ),                /* turn italic printing on/off */
    ( "$1B&d0D",   "$1B&d@" ),                     /* turn underlining on/off */
    ( "$1B*p+20Y", "$1B*p-20Y" ),                    /* turn subscript on/off */
    ( "$1B*p-20Y", "$1B*p+20Y" )                   /* turn superscript on/off */
),

/*----------------------------------------------------------------------------*/

( DF                                                 /* Default Font resource */

    (   1,    65, $0090,   11 ),                            /* 10 cpi default */
    (  66,   200, $0078,   70 ),                            /* 12 cpi default */
    ( 201,   239, $0060,  223 ),                            /* 15 cpi default */
    ( 250,   255, $0054,  252 ),                            /* 17 cpi default */
),

/*----------------------------------------------------------------------------*/

( FO                                                         /* Font resource */

    /* Printer Builtin Fonts */

    ( $0090,  11,  46,  18,  47, "$1B(s0p10h10v3T" ),           /* Courier 10 */
    ( $0060, 223, 224, 219, 220, "$1B(s0p16.66h8.5v0T$1B&k8H" ), /* Gothic 15 */
    ( $0060, 230, 231, 232, 233, "$1B(s0p16.66h8.5v0T$1B&k8H" ), /* Gothic 15 */
    ( $0054, 252, 253, 255,   0, "$1B(s0p17.15h8.5v0T$1B&k7H" ),/* Courier 17 */
    ( $0054, 254,   0,   0,   0, "$1B(s0p17.15h8.5v0T$1B&k7H" ),/* Courier 17 */
    ( $0048, 281,   0,   0,   0, "$1B(s0p17.15h8.5v0T$1B&k6H" ), /* Gothic 20 */
    ( $0120, 244, 245, 248, 249, "$1B(s0p10h3T$1B&k24H" ),      /* Courier 5  */

    ( $0078,  86, 111, 112, 113, "$1B(s0p12h10v8T" ),    /* Prestige Elite 12 */
    ( $0078,  70,  72,  71,  74, "$1B(s0p12h10v8T" ),             /* Serif 12 */
    ( $0078,  85, 135,  92, 136, "$1B(s0p12h10v3T" ),           /* Courier 12 */

    /* Old IBM 3812 typographic fonts */
    ( $0028,  760,    0,    0,    0, "$1B(s1p5.75v4101T" ),     /* Times 6 pt */
    ( $0035,  751,    0,    0,    0, "$1B(s1p7.75v4101T" ),     /* Times 8 pt */
    ( $0043, 1051, 1053, 1056,  764, "$1B(s1p9.75v4101T" ),    /* Times 10 pt */
    ( $0050, 1351,  761,  763,  765, "$1B(s1p11.75v4101T" ),   /* Times 12 pt */
    ( $005D,    0,  762,    0,    0, "$1B(s1p13.75v4101T" ),   /* Times 14 pt */
    ( $006B,    0, 1653,    0,    0, "$1B(s1p15.75v4101T" ),   /* Times 16 pt */
    ( $0078,    0, 1803,    0,    0, "$1B(s1p17.75v4101T" ),   /* Times 18 pt */
    ( $00A0,    0, 2103,    0,    0, "$1B(s1p23.75v4101T" )    /* Times 24 pt */
),

/*----------------------------------------------------------------------------*/

( CT                                              /* Character Table resource */

    $0020, $0023, $0024, $0040, $005B, $005C, $005D, $005E,          /* $0080 */
    $005F, $0060, $007B, $00DD, $007D, $007E, $007C, $00DB,
    $00B3, $00C4, $00C5, $00DA, $00BF, $00D9, $00C0, $00C2,          /* $0090 */
    $00B4, $00C1, $00C3, $0020, $0020, $0020, $0020, $00F2,
    $009F, $00AD, $00BD, $009C, $00CF, $00BE, $0020, $00F5,          /* $00A0 */
    $00F9, $00B8, $00A6, $00AE, $00AA, $00F0, $00A9, $00EE,
    $00F8, $00F1, $00FD, $00FC, $00EF, $00E6, $00F4, $00FA,          /* $00B0 */
    $00F7, $00FB, $00A7, $00AF, $00AC, $00AB, $00F3, $00A8,
    $00B7, $00B5, $00B6, $00C7, $008E, $008F, $0092, $0080,          /* $00C0 */
    $00D4, $0090, $00D2, $00D3, $00DE, $00D6, $00D7, $00D8,
    $00D1, $00A5, $00E3, $00E0, $00E2, $00E5, $0099, $009E,          /* $00D0 */
    $009D, $00EB, $00E9, $00EA, $009A, $00ED, $00E8, $00E1,
    $0085, $00A0, $0083, $00C6, $0084, $0086, $0091, $0087,          /* $00E0 */
    $008A, $0082, $0088, $0089, $008D, $00A1, $008C, $008B,
    $00D0, $00A4, $0095, $00A2, $0093, $00E4, $0094, $00F6,          /* $00F0 */
    $009B, $0097, $00A3, $0096, $0081, $00EC, $00E7, $0098
),

/*----------------------------------------------------------------------------*/

( CS                                          /* Character Selection resource */

    ( $1100, 2, "$1B&f1Y$1B&f0X$1B&f0S$1B(10U",
                "$1B&f1S$1B&f1X$1B&f3X " ),                  /* code page 437 */
    ( $1200, 1, "$1B&f700y3X" )                     /* double underline macro */
),

/*----------------------------------------------------------------------------*/

( BS                                              /* Bold Simulation resource */

    ( 288, "$1B*p+6X" ),                 /* bold offset 5 characters per inch */
    ( 144, "$1B*p+3X" ),                /* bold offset 10 characters per inch */
    ( 120, "$1B*p+3X" ),                /* bold offset 12 characters per inch */
    (  96, "$1B*p+2X" ),                /* bold offset 15 characters per inch */
    (  84, "$1B*p+1X" ),                /* bold offset 17 characters per inch */
    (  72, "$1B*p+1X" ),                /* bold offset 20 characters per inch */
    (  54, "$1B*p+1X" )                 /* bold offset 27 characters per inch */
),

/*----------------------------------------------------------------------------*/

( FI                                                        /* Font and Image */

    (
      0,                            /* download format is HP LaserJet level 4 */
      10,                                          /* maximum number of fonts */
      8,                                   /* horizontal font scaling divisor */
      11,                                    /* vertical font scaling divisor */
      1100,                                          /* number of first image */
      1999,                                           /* number of last image */
      1                                   /* small image optimization allowed */
    ),
    ( "$1B&f0S$1B*c", 1, 1, 800, 4, "D" ),             /* start font download */
    ( "$1B*c5F", 0, 0, 0, 0, "$1B&f1S" ),               /* stop font download */
    ( "$1B(", 1, 1, 800, 4, "X" ),                             /* select font */
    ( "$1B*c", 1, 1, 800, 4, "d2F" )                           /* delete font */
),

/*----------------------------------------------------------------------------*/

( RT                                                             /* RecTangle */

    1,                                           /* type of rectangle support */
    (
      "$1B*c",                          /* set rectangle x dimension sequence */
      5, 24,                                /* parameter resolution is 1/300" */
      0, 4,                        /* no offset, parameter passing is decimal */
      "a",                              /* set rectangle y dimension sequence */
      5, 24,                                /* parameter resolution is 1/300" */
      0, 4,                        /* no offset, parameter passing is decimal */
      "b0P"                                        /* draw rectangle sequence */
    )
).

/*----------------------------------------------------------------------------*/
