UNIT PMTypes;

INTERFACE

{Basic types and constants used by object PM}

CONST
    {Keyboard scancodes}
    kbCLeft       =99;
    kbCRight      =100;
    kbCUp         =97;
    kbCDown       =102;
    kbDel         =105;
    kbInsert      =104;
    kbEnd         =101;
    kbPos1        =96;
    kbPageDown    =103;
    kbPageUp      =98;
    kbBS          =8;
    kbCR          =13;
    kbF1          =59;
    kbF2          =60;
    kbF3          =61;
    kbF4          =62;
    kbF5          =63;
    kbF6          =64;
    kbF7          =65;
    kbF8          =66;
    kbF9          =67;
    kbF10         =68;
    kbESC         =1;
    kbCtrl        =29;
    kbTab         =9;

    {Control codes are basic codes+256}
    kbCtrl1       =2+256;
    kbCtrl2       =3+256;
    kbCtrl3       =4+256;
    kbCtrl4       =5+256;
    kbCtrl5       =6+256;
    kbCtrl6       =7+256;
    kbCtrl7       =8+256;
    kbCtrl8       =9+256;
    kbCtrl9       =10+256;
    kbCtrl0       =11+256;
    kbCtrlA       =286;
    kbCtrlB       =304;
    kbCtrlC       =302;
    kbCtrlD       =288;
    kbCtrlE       =274;
    kbCtrlF       =289;
    kbCtrlG       =290;
    kbCtrlH       =291;
    kbCtrlI       =279;
    kbCtrlJ       =292;
    kbCtrlK       =293;
    kbCtrlL       =294;
    kbCtrlM       =306;
    kbCtrlN       =305;
    kbCtrlO       =280;
    kbCtrlP       =281;
    kbCtrlQ       =272;
    kbCtrlR       =275;
    kbCtrlS       =287;
    kbCtrlT       =276;
    kbCtrlU       =278;
    kbCtrlV       =303;
    kbCtrlW       =273;
    kbCtrlX       =301;
    kbCtrlY       =300;
    kbCtrlZ       =277;
    kbCtrlF1      =315;
    kbCtrlF2      =316;
    kbCtrlF3      =317;
    kbCtrlF4      =318;
    kbCtrlF5      =319;
    kbCtrlF6      =320;
    kbCtrlF7      =321;
    kbCtrlF8      =322;
    kbCtrlF9      =323;
    kbCtrlF10     =324;
    kbCtrlIns     =256+104;
    kbCtrlCLeft   =256+99;
    kbCtrlCRight  =256+100;
    kbCtrlDel     =105+256;
    kbCtrlInsert  =104+256;
    kbCtrlEnd     =101+256;
    kbCtrlPos1    =96+256;
    kbCtrlPageDown=103+256;
    kbCtrlPageUp  =98+256;

    {Shift Codes are basic codes+512}
    kbShiftCLeft       =99+512;
    kbShiftCRight      =100+512;
    kbShiftCUp         =97+512;
    kbShiftCDown       =102+512;
    kbShiftDel         =105+512;
    kbShiftIns         =104+512;
    kbShiftEnd         =101+512;
    kbShiftPos1        =96+512;
    kbShiftPageDown    =103+512;
    kbShiftPageUp      =98+512;
    kbShiftBS          =8+512;
    kbShiftCR          =13+512;
    kbShiftF1          =59+512;
    kbShiftF2          =60+512;
    kbShiftF3          =61+512;
    kbShiftF4          =62+512;
    kbShiftF5          =63+512;
    kbShiftF6          =64+512;
    kbShiftF7          =65+512;
    kbShiftF8          =66+512;
    kbShiftF9          =67+512;
    kbShiftF10         =68+512;

    {Alt Codes are basic codes+768}
    kbAlt1       =2+768;
    kbAlt2       =3+768;
    kbAlt3       =4+768;
    kbAlt4       =5+768;
    kbAlt5       =6+768;
    kbAlt6       =7+768;
    kbAlt7       =8+768;
    kbAlt8       =9+768;
    kbAlt9       =10+768;
    kbAlt0       =11+768;
    kbAltA       =286+512;
    kbAltB       =304+512;
    kbAltC       =302+512;
    kbAltD       =288+512;
    kbAltE       =274+512;
    kbAltF       =289+512;
    kbAltG       =290+512;
    kbAltH       =291+512;
    kbAltI       =279+512;
    kbAltJ       =292+512;
    kbAltK       =293+512;
    kbAltL       =294+512;
    kbAltM       =306+512;
    kbAltN       =305+512;
    kbAltO       =280+512;
    kbAltP       =281+512;
    kbAltQ       =272+512;
    kbAltR       =275+512;
    kbAltS       =287+512;
    kbAltT       =276+512;
    kbAltU       =278+512;
    kbAltV       =303+512;
    kbAltW       =273+512;
    kbAltX       =301+512;
    kbAltY       =300+512;
    kbAltZ       =277+512;
    kbAltF1      =315+512;
    kbAltF2      =316+512;
    kbAltF3      =317+512;
    kbAltF4      =318+512;
    kbAltF5      =319+512;
    kbAltF6      =320+512;
    kbAltF7      =321+512;
    kbAltF8      =322+512;
    kbAltF9      =323+512;
    kbAltF10     =324+512;
    kbAltIns     =256+104+512;
    kbAltCLeft   =256+99+512;
    kbAltCRight  =256+100+512;

{Ctrl-K... MDI Scan Messages}
CONST
    kbCtrlKA       =1286;
    kbCtrlKB       =1304;
    kbCtrlKC       =1302;
    kbCtrlKD       =1288;
    kbCtrlKE       =1274;
    kbCtrlKF       =1289;
    kbCtrlKG       =1290;
    kbCtrlKH       =1291;

    kbCtrlKI       =1279;
    kbCtrlKJ       =1292;
    kbCtrlKK       =1293;
    kbCtrlKL       =1294;
    kbCtrlKM       =1306;
    kbCtrlKN       =1305;
    kbCtrlKO       =1280;
    kbCtrlKP       =1281;
    kbCtrlKQ       =1272;
    kbCtrlKR       =1275;
    kbCtrlKS       =1287;
    kbCtrlKT       =1276;
    kbCtrlKU       =1278;
    kbCtrlKV       =1303;
    kbCtrlKW       =1273;
    kbCtrlKX       =1301;
    kbCtrlKY       =1300;
    kbCtrlKZ       =1277;

    WM_MOUSEDRAG1              =$1000;


CONST
     HWND_DESKTOP       = 1;
     HWND_OBJECT        = 2;
     HWND_TOP           = 3;
     HWND_BOTTOM        = 4;
     HWND_THREADCAPTURE = 5;

     { Frame window styles }
     FCF_TITLEBAR       =$00000001;
     FCF_SYSMENU        =$00000002;
     FCF_MENU           =$00000004;
     FCF_SIZEBORDER     =$00000008;
     FCF_MINBUTTON      =$00000010;
     FCF_MAXBUTTON      =$00000020;
     FCF_MINMAX         =$00000030;
     FCF_VERTSCROLL     =$00000040;
     FCF_HORZSCROLL     =$00000080;
     FCF_DLGBORDER      =$00000100;
     FCF_BORDER         =$00000200;
     FCF_SHELLPOSITION  =$00000400;
     FCF_TASKLIST       =$00000800;
     FCF_NOBYTEALIGN    =$00001000;
     FCF_NOMOVEWITHOWNER=$00002000;
     FCF_ICON           =$00004000;
     FCF_ACCELTABLE     =$00008000;
     FCF_SYSMODAL       =$00010000;
     FCF_SCREENALIGN    =$00020000;
     FCF_MOUSEALIGN     =$00040000;
     FCF_HIDEBUTTON     =$01000000;
     FCF_HIDEMAX        =$01000020;
     FCF_DBE_APPSTAT    =$80000000;
     FCF_AUTOICON       =$40000000;
     { FCF_TITLEBAR | FCF_SYSMENU | FCF_MENU | FCF_SIZEBORDER | FCF_MINMAX |
       FCF_ICON | FCF_ACCELTABLE | FCF_SHELLPOSITION | FCF_TASKLIST }
     FCF_STANDARD       =$0000CC3F;
     {FCF_TITLEBAR | FCF_SYSMENU | FCF_ICON | FCF_SIZEBORDER | FCF_MINMAX
      | FCF_MENU | FCF_SHELLPOSITION | FCF_TASKLIST}
     FCF_SPEED          =$00004C3F;
     {FCF_TITLEBAR | FCF_SYSMENU  | FCF_MINMAX | FCF_SIZEBORDER
      | FCF_TASKLIST | FCF_SHELLPOSITION}
     FCF_SIMPLE         =$00000c3b;
     {FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX | FCF_SIZEBORDER |
      FCF_NOBYTEALIGN}
     FCF_SPEEDCHILD     =$0000103B;

     SWP_SIZE                 =$0001;
     SWP_MOVE                 =$0002;
     SWP_ZORDER               =$0004;
     SWP_SHOW                 =$0008;
     SWP_HIDE                 =$0010;
     SWP_NOREDRAW             =$0020;
     SWP_NOADJUST             =$0040;
     SWP_ACTIVATE             =$0080;
     SWP_DEACTIVATE           =$0100;
     SWP_EXTSTATECHANGE       =$0200;
     SWP_MINIMIZE             =$0400;
     SWP_MAXIMIZE             =$0800;
     SWP_RESTORE              =$1000;
     SWP_FOCUSACTIVATE        =$2000;
     SWP_FOCUSDEACTIVATE      =$4000;
     SWP_NOAUTOCLOSE          =$8000;
     {SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW }
     SWP_SPEED                =$008B;
     {SWP_SIZE | SWP_MOVE | SWP_SHOW }
     SWP_ACT                  =$000B;

     CS_MOVENOTIFY            =$00000001;
     CS_SIZEREDRAW            =$00000004;
     CS_HITTEST               =$00000008;
     CS_PUBLIC                =$00000010;
     CS_FRAME                 =$00000020;
     CS_CLIPCHILDREN          =$20000000;
     CS_CLIPSIBLINGS          =$10000000;
     CS_PARENTCLIP            =$08000000;
     CS_SAVEBITS              =$04000000;
     CS_SYNCPAINT             =$02000000;

     { WinQueryWindow() codes }

      QW_NEXT         =0;
      QW_PREV         =1;
      QW_TOP          =2;
      QW_BOTTOM       =3;
      QW_OWNER        =4;
      QW_PARENT       =5;
      QW_NEXTTOP      =6;
      QW_PREVTOP      =7;
      QW_FRAMEOWNER   =8;

      { Frame control IDs    }

      FID_SYSMENU                =$8002;
      FID_TITLEBAR               =$8003;
      FID_MINMAX                 =$8004;
      FID_MENU                   =$8005;
      FID_VERTSCROLL             =$8006;
      FID_HORZSCROLL             =$8007;
      FID_CLIENT                 =$8008;
      FID_DBE_APPSTAT            =$8010;
      FID_DBE_KBDSTAT            =$8011;
      FID_DBE_PECIC              =$8012;
      FID_DBE_KKPOPUP            =$8013;

CONST
     {IPF message base}
     HM_MSG_BASE              =$0220;
     {Messages applications can send to the IPF}
     HM_DISPLAY_HELP          =HM_MSG_BASE+$0002;
     HM_EXT_HELP              =HM_MSG_BASE+$0003;
     HM_GENERAL_HELP          =HM_EXT_HELP;
     HM_SET_HELP_WINDOW_TITLE =HM_MSG_BASE+$0007;
     HM_SET_SHOW_PANEL_ID     =HM_MSG_BASE+$0008;
     HM_REPLACE_HELP_FOR_HELP =HM_MSG_BASE+$0009;
     HM_REPLACE_USING_HELP    =HM_REPLACE_HELP_FOR_HELP;
     HM_HELP_INDEX            =HM_MSG_BASE+$000a;
     HM_HELP_CONTENTS         =HM_MSG_BASE+$000b;
     HM_KEYS_HELP             =HM_MSG_BASE+$000c;
     HM_SET_HELP_LIBRARY_NAME =HM_MSG_BASE+$000d;
     HM_ERROR                 =HM_MSG_BASE+$000e;
     HM_HELPSUBITEM_NOT_FOUND =HM_MSG_BASE+$000f;
     HM_QUERY_KEYS_HELP       =HM_MSG_BASE+$0010;
     HM_TUTORIAL              =HM_MSG_BASE+$0011;
     HM_EXT_HELP_UNDEFINED    =HM_MSG_BASE+$0012;
     HM_SET_OBJCOM_WINDOW     =HM_MSG_BASE+$0018;
     HM_UPDATE_OBJCOM_WINDOW_CHAIN=HM_MSG_BASE+$0019;
     HM_QUERY_DDF_DATA        =HM_MSG_BASE+$001a;
     HM_INVALIDATE_DDF_DATA   =HM_MSG_BASE+$001b;
     HM_QUERY                 =HM_MSG_BASE+$001c;
     HM_SET_COVERPAGE_SIZE    =HM_MSG_BASE+$001d;
     HM_GENERAL_HELP_UNDEFINED=HM_EXT_HELP_UNDEFINED;

     { Standard WinQueryWindowUShort/ULong() indices }

     QWS_USER                   =0;
     QWS_ID                     =-1;
     QWS_MIN                    =-1;
     QWL_USER                   =0;
     QWL_STYLE                  =-2;
     QWP_PFNWP                  =-3;
     QWL_HMQ                    =-4;
     QWL_RESERVED               =-5;
     QWL_PENDATA                =-7;
     QWL_MIN                    =-7;

     { WC_FRAME WinQueryWindowUShort/ULong() indices }
     QWL_HHEAP                  =$0004;
     QWL_HWNDFOCUSSAVE          =$0018;
     QWL_DEFBUTTON              =$0040;
     QWL_PSSCBLK                =$0048;
     QWL_PFEPBLK                =$004c;
     QWL_PSTATBLK               =$0050;
     QWS_FLAGS                  =$0008;
     QWS_RESULT                 =$000a;
     QWS_XRESTORE               =$000c;
     QWS_YRESTORE               =$000e;
     QWS_CXRESTORE              =$0010;
     QWS_CYRESTORE              =$0012;
     QWS_XMINIMIZE              =$0014;
     QWS_YMINIMIZE              =$0016;

     WS_VISIBLE         =$80000000;
     WS_DISABLED        =$40000000;
     WS_CLIPCHILDREN    =$20000000;
     WS_CLIPSIBLINGS    =$10000000;
     WS_PARENTCLIP      =$08000000;
     WS_SAVEBITS        =$04000000;
     WS_SYNCPAINT       =$02000000;
     WS_MINIMIZED       =$01000000;
     WS_MAXIMIZED       =$00800000;
     WS_ANIMATE         =$00400000;
     WS_GROUP           =$00010000;
     WS_TABSTOP         =$00020000;

     {Message box types }
     MB_OK                    =$0000;
     MB_OKCANCEL              =$0001;
     MB_RETRYCANCEL           =$0002;
     MB_ABORTRETRYIGNORE      =$0003;
     MB_YESNO                 =$0004;
     MB_YESNOCANCEL           =$0005;
     MB_CANCEL                =$0006;
     MB_ENTER                 =$0007;
     MB_ENTERCANCEL           =$0008;

     MB_NOICON                =$0000;
     MB_CUANOTIFICATION       =$0000;
     MB_ICONQUESTION          =$0010;
     MB_ICONEXCLAMATION       =$0020;
     MB_CUAWARNING            =$0020;
     MB_ICONASTERISK          =$0030;
     MB_ICONHAND              =$0040;
     MB_CUACRITICAL           =$0040;
     MB_QUERY                 =$0010;
     MB_WARNING               =$0020;
     MB_INFORMATION           =$0030;
     MB_CRITICAL              =$0040;
     MB_ERROR                 =$0040;
     MB_DEFBUTTON1            =$0000;
     MB_DEFBUTTON2            =$0100;
     MB_DEFBUTTON3            =$0200;
     MB_APPLMODAL             =$0000;
     MB_SYSTEMMODAL           =$1000;
     MB_HELP                  =$2000;
     MB_MOVEABLE              =$4000;

     { Message box return codes }
     MBID_OK                  =1;
     MBID_CANCEL              =2;
     MBID_ABORT               =3;
     MBID_RETRY               =4;
     MBID_IGNORE              =5;
     MBID_YES                 =6;
     MBID_NO                  =7;
     MBID_HELP                =8;
     MBID_ENTER               =9;
     MBID_ERROR               =$ffff;

     SV_SWAPBUTTON            =0;
     SV_DBLCLKTIME            =1;
     SV_CXDBLCLK              =2;
     SV_CYDBLCLK              =3;
     SV_CXSIZEBORDER          =4;
     SV_CYSIZEBORDER          =5;
     SV_ALARM                 =6;
     SV_RESERVEDFIRST1        =7;
     SV_RESERVEDLAST1         =8;
     SV_CURSORRATE            =9;
     SV_FIRSTSCROLLRATE       =10;
     SV_SCROLLRATE            =11;
     SV_NUMBEREDLISTS         =12;
     SV_WARNINGFREQ           =13;
     SV_NOTEFREQ              =14;
     SV_ERRORFREQ             =15;
     SV_WARNINGDURATION       =16;
     SV_NOTEDURATION          =17;
     SV_ERRORDURATION         =18;
     SV_RESERVEDFIRST         =19;
     SV_RESERVEDLAST          =19;
     SV_CXSCREEN              =20;
     SV_CYSCREEN              =21;
     SV_CXVSCROLL             =22;
     SV_CYHSCROLL             =23;
     SV_CYVSCROLLARROW        =24;
     SV_CXHSCROLLARROW        =25;
     SV_CXBORDER              =26;
     SV_CYBORDER              =27;
     SV_CXDLGFRAME            =28;
     SV_CYDLGFRAME            =29;
     SV_CYTITLEBAR            =30;
     SV_CYVSLIDER             =31;
     SV_CXHSLIDER             =32;
     SV_CXMINMAXBUTTON        =33;
     SV_CYMINMAXBUTTON        =34;
     SV_CYMENU                =35;
     SV_CXFULLSCREEN          =36;
     SV_CYFULLSCREEN          =37;
     SV_CXICON                =38;
     SV_CYICON                =39;
     SV_CXPOINTER             =40;
     SV_CYPOINTER             =41;
     SV_DEBUG                 =42;
     SV_CMOUSEBUTTONS         =43;
     SV_CPOINTERBUTTONS       =43;
     SV_POINTERLEVEL          =44;
     SV_CURSORLEVEL           =45;
     SV_TRACKRECTLEVEL        =46;
     SV_CTIMERS               =47;
     SV_MOUSEPRESENT          =48;
     SV_CXBYTEALIGN           =49;
     SV_CXALIGN               =49;
     SV_CYBYTEALIGN           =50;
     SV_CYALIGN               =50;
     SV_NOTRESERVED           =56;
     SV_EXTRAKEYBEEP          =57;
     SV_SETLIGHTS             =58;
     SV_INSERTMODE            =59;
     SV_MENUROLLDOWNDELAY     =64;
     SV_MENUROLLUPDELAY       =65;
     SV_ALTMNEMONIC           =66;
     SV_TASKLISTMOUSEACCESS   =67;
     SV_CXICONTEXTWIDTH       =68;
     SV_CICONTEXTLINES        =69;
     SV_CHORDTIME             =70;
     SV_CXCHORD               =71;
     SV_CYCHORD               =72;
     SV_CXMOTIONSTART         =73;
     SV_CYMOTIONSTART         =74;
     SV_BEGINDRAG             =75;
     SV_ENDDRAG               =76;
     SV_SINGLESELECT          =77;
     SV_OPEN                  =78;
     SV_CONTEXTMENU           =79;
     SV_CONTEXTHELP           =80;
     SV_TEXTEDIT              =81;
     SV_BEGINSELECT           =82;
     SV_ENDSELECT             =83;
     SV_BEGINDRAGKB           =84;
     SV_ENDDRAGKB             =85;
     SV_SELECTKB              =86;
     SV_OPENKB                =87;
     SV_CONTEXTMENUKB         =88;
     SV_CONTEXTHELPKB         =89;
     SV_TEXTEDITKB            =90;
     SV_BEGINSELECTKB         =91;
     SV_ENDSELECTKB           =92;
     SV_ANIMATION             =93;
     SV_ANIMATIONSPEED        =94;
     SV_MONOICONS             =95;
     SV_KBDALTERED            =96;
     SV_PRINTSCREEN           =97;
     SV_CSYSVALUES            =98;

     PU_POSITIONONITEM        =$0001;
     PU_HCONSTRAIN            =$0002;
     PU_VCONSTRAIN            =$0004;
     PU_NONE                  =$0000;
     PU_MOUSEBUTTON1DOWN      =$0008;
     PU_MOUSEBUTTON2DOWN      =$0010;
     PU_MOUSEBUTTON3DOWN      =$0018;
     PU_SELECTITEM            =$0020;
     PU_MOUSEBUTTON1          =$0040;
     PU_MOUSEBUTTON2          =$0080;
     PU_MOUSEBUTTON3          =$0100;
     PU_KEYBOARD              =$0200;

     { Scroll Bar Commands }
     SB_LINEUP                  =1;
     SB_LINEDOWN                =2;
     SB_LINELEFT                =1;
     SB_LINERIGHT               =2;
     SB_PAGEUP                  =3;
     SB_PAGEDOWN                =4;
     SB_PAGELEFT                =3;
     SB_PAGERIGHT               =4;
     SB_SLIDERTRACK             =5;
     SB_SLIDERPOSITION          =6;
     SB_ENDSCROLL               =7;

     { Scroll Bar messages }
     SBM_SETSCROLLBAR           =$01a0;
     SBM_SETPOS                 =$01a1;
     SBM_QUERYPOS               =$01a2;
     SBM_QUERYRANGE             =$01a3;
     SBM_SETTHUMBSIZE           =$01a6;

     {Font attribute for small font}
     FATTR_SEL_BOLD             =$0020;

     {fill options for GpiBox/GpiFullArc}
     DRO_FILL                   =1;
     DRO_OUTLINE                =2;
     DRO_OUTLINEFILL            =3;

     {background mixes}
     BM_ERROR                   =-1;
     BM_DEFAULT                 =0;
     BM_OR                      =1;
     BM_OVERPAINT               =2;
     BM_LEAVEALONE              =5;

     BM_XOR                     =4;
     BM_AND                     =6;
     BM_SUBTRACT                =7;
     BM_MASKSRCNOT              =8;
     BM_ZERO                    =9;
     BM_NOTMERGESRC             =10;
     BM_NOTXORSRC               =11;
     BM_INVERT                  =12;
     BM_MERGESRCNOT             =13;
     BM_NOTCOPYSRC              =14;
     BM_MERGENOTSRC             =15;
     BM_NOTMASKSRC              =16;
     BM_ONE                     =17;
     BM_SRCTRANSPARENT          =18;
     BM_DESTTRANSPARENT         =19;

TYPE
    THelpInit=RECORD
                    cb:LONGWORD;
                    ulReturnCode:LONGWORD;
                    pszTutorialName:POINTER;
                    phtHelptable:LONGWORD;
                    hmodHelptableModule:HMODULE;
                    hmodAccelActionBarModule:HMODULE;
                    idAcceltable:LONGWORD;
                    idActionBar:LONGWORD;

                    pszHelpWindowTitle:POINTER;
                    fShowPanelID:LONGWORD;
                    pszHelpLibraryName:POINTER;
             END;

    PToolBarInterior=^TToolBarInterior;
    TToolBarInterior=RECORD
                           Win:HWND;
                           id:LONGWORD;
                           x,y,cx,cy:LONGWORD;
                           Next:PToolBarInterior;
                     END;
    PStatusBarInterior=^TStatusBarInterior;
    TStatusBarInterior=RECORD
                           id:WORD;
                           x,y,cx,cy:LONGWORD;
                           item:String;
                           Col:LONGINT;
                           Next:PStatusBarInterior;
                     END;

     PMenuHelpItems=^TMenuHelpItems;
     TMenuHelpItems=RECORD
                          StatusID:WORD;
                          MenuID:WORD;
                          HelpText:String;
                          Col:LONGWORD;
                          Next:PMenuHelpItems;
                    END;

    POINTS=Record
                 x,y:Integer;
           End;

CONST {Common command constants}
     CM_TILE       =100;
     CM_CASCADE    =101;
     CM_CLOSE      =102;
     CM_CLOSEALL   =103;
     CM_NEXT       =104;
     CM_OPEN       =105;
     CM_SAVEAS     =106;
     CM_NEW        =107;
     CM_SAVE       =108;
     CM_SAVEALL    =109;
     CM_ABOUT      =110;
     CM_QUIT       =111;
     CM_FILE       =112;
     CM_EDIT       =113;
     CM_SEARCH     =114;
     {item 115 reserved}
     CM_WINDOW     =116;
     CM_HELP       =117;
     CM_DEBUG      =118;
     CM_OPTIONS    =119;
     {item 120-126 reserved}
     CM_LIST       =127;

     CM_HELPONHELP  =30001;
     CM_EXTENDEDHELP=30002;

     CM_KEYSHELP    =30003;
     CM_HELPINDEX   =30004;
     CM_HELPCONTENTS=30005;



IMPLEMENTATION

BEGIN
END.
