UNIT PMDialog;

{**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
*          General Unit for Object-PM  (C) 1993,94 R. Nrnberger          *
*                                                                         *
*                                                                         *
***************************************************************************}


INTERFACE

USES PMObject,PmTypes;


CONST
     {List box notification messages}

     LN_SELECT                 =1;
     LN_SETFOCUS               =2;
     LN_KILLFOCUS              =3;
     LN_SCROLL                 =4;
     LN_ENTER                  =5;

     {Entry Field  messages}

     EM_QUERYCHANGED           =$0140;
     EM_QUERYSEL               =$0141;
     EM_SETSEL                 =$0142;
     EM_SETTEXTLIMIT           =$0143;

TYPE PListBoxItems=^TListBoxItems;
     TListBoxItems=RECORD
                         item:String;
                         _index:WORD;
                         Data:POINTER; {Private data}
                         cbData:LONGWORD; {Count of private data}
                         Next:PListBoxItems;
                   END;


TYPE TDialog=OBJECT
                   HwndDlg:Hwnd;
                   {*******Do not change this location -- its hard coded***}
                   FUNCTION DialogHandleEvent(Dlg:HWND;msg:LONGWORD;
                                        Para1,Para2:LONGWORD;VAR Handled:BOOLEAN):
                                        LONGWORD;VIRTUAL;
                   {*******************************************************}
                   CONSTRUCTOR Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                                    pCreateParams:Pointer);
                   DESTRUCTOR Done;
                   PROCEDURE ExecDialog(VAR r:LONGWORD);VIRTUAL;
                   PROCEDURE GetDlg(VAR Dlg:HWND);VIRTUAL;
                   PROCEDURE CenterDlgBox(Dlg:HWND);VIRTUAL;
                   PROCEDURE WMInitDlg(VAR Msg:TMessage);VIRTUAL WM_INITDLG;
                   PROCEDURE WMControl(VAR Msg:TMessage);VIRTUAL WM_CONTROL;
             END;


VAR FileOpenDlgWildCards:STRING;
    FileOpenDlgTitle:String[40];
    FileOpenDlgOkName:String[40];
    FileSaveDlgWildCards:STRING;
    FileSaveDlgTitle:String[40];
    FileSaveDlgOkName:String[40];
    DialogVMT:POINTER;


FUNCTION FileOpenDialog(Win:HWND;Wildcards:String;VAR result:String):Boolean;
FUNCTION FileSaveDialog(Win:HWND;VAR result:String):Boolean;

FUNCTION ListBoxInsertString(Dlg:HWND;where:LONGINT;s:string):WORD;
PROCEDURE FillListBox(Dlg:HWND;id:LONGWORD;List:PListBoxItems);
PROCEDURE NewListBoxItem(VAR List:PListBoxItems;item:String;Data:POINTER;
                         cbData:LONGWORD;Sort:BOOLEAN);
PROCEDURE DialogGetText(Dlg:HWND;id:LONGWORD;VAR s:String;cb:BYTE);
PROCEDURE DialogSetText(Dlg:HWND;id:LONGWORD;s:String);
PROCEDURE ListBoxGetSelItem(Dlg:HWND;id:LONGWORD;VAR result:TListBoxItems;
                            VAR List:PListBoxItems;Erase:BOOLEAN);
PROCEDURE DeleteListBox(VAR List:PListBoxItems);
PROCEDURE SetTextLimit(Dlg:HWND;id:LONGWORD;Limit:BYTE);
PROCEDURE SetMenuText(Frame:HWND;Id:LONGWORD;s:string);
PROCEDURE InsertSubMenu(Frame:HWND;MainMenuID:WORD;pos:INTEGER;id:WORD;s:STRING);
PROCEDURE RemoveSubMenu(Frame:HWND;id:WORD);
PROCEDURE RemoveSubMenuByPos(Frame:HWND;MainMenuID:WORD;pos:Integer);
PROCEDURE SetCheckBoxState(Dlg:HWND;Id:LONGWORD;Setit:LONGWORD);
FUNCTION GetCheckBoxState(Dlg:HWND;Id:LONGWORD):LONGWORD;
FUNCTION GetRadioButtonState(Dlg:HWND;Id:LONGWORD):LONGWORD;
PROCEDURE SetRadioButtonState(Dlg:HWND;Id:LONGWORD;Setit:LONGWORD);

IMPLEMENTATION

CONST
     {List box messages}
     LM_QUERYITEMCOUNT         =$0160;
     LM_INSERTITEM             =$0161;
     LM_SETTOPINDEX            =$0162;
     LM_DELETEITEM             =$0163;
     LM_SELECTITEM             =$0164;
     LM_QUERYSELECTION         =$0165;
     LM_SETITEMTEXT            =$0166;
     LM_QUERYITEMTEXTLENGTH    =$0167;
     LM_QUERYITEMTEXT          =$0168;

     LM_SETITEMHANDLE          =$0169;
     LM_QUERYITEMHANDLE        =$016a;
     LM_SEARCHSTRING           =$016b;
     LM_SETITEMHEIGHT          =$016c;
     LM_QUERYTOPINDEX          =$016d;
     LM_DELETEALL              =$016e;

     {List box constants}

     LIT_CURSOR                =-4;
     LIT_ERROR                 =-3;
     LIT_MEMERROR              =-2;
     LIT_NONE                  =-1;
     LIT_FIRST                 =-1;

     {For LM_INSERTITEM msg}

     LIT_END                   =-1;
     LIT_SORTASCENDING         =-2;
     LIT_SORTDESCENDING        =-3;

     {Button control messages}

     BM_CLICK                  =$0120;
     BM_QUERYCHECKINDEX        =$0121;
     BM_QUERYHILITE            =$0122;
     BM_SETHILITE              =$0123;
     BM_QUERYCHECK             =$0124;
     BM_SETCHECK               =$0125;
     BM_SETDEFAULT             =$0126;

IMPORTS {Private}
       FUNCTION WinLoadDlg(pCreateParams:POINTER;idDld:LONGWORD;
                           hmod:HMODULE;DlgProc:POINTER;Owner:HWND;
                           Parent:HWND):LONGWORD:   PMWIN index 924;
       FUNCTION WinProcessDlg(hwndDlg:HWND):LONGWORD: PMWIN index 796;
       FUNCTION WinDefDlgProc(Para2,Para1:POINTER;msg:LONGWORD;hwnddlg:HWND):
                           LONGWORD:    PMWIn index 910;
       FUNCTION WinDestroyWindow(_hwnd:HWND):
                                    LONGWORD:                PMWIN index 728;
       PROCEDURE WinQueryWindowText(VAR Buf;
                                    cchBufferMax:LONGWORD;
                                    _hwnd:HWND):             PMWIN index 841;
       FUNCTION WinWindowFromID(id:LONGWORD;_hwnd:HWND):
                                HWND:                        PMWIN index 899;
       PROCEDURE WinShowWindow(fShow:LONGWORD;_hwnd:HWND):   PMWIN index 883;
       PROCEDURE WinEnableWindowUpdate(fEnable:LONGWORD;
                                       _hwnd:HWND):          PMWIN index 736;
       FUNCTION WinSendMsg(MPARAM2,MPARAM1:LONGWORD;
                           msg:LONGWORD;
                           _hwnd:HWND):LONGWORD:             PMWIN index 920;
       PROCEDURE WinSetWindowText(pszText:POINTER;
                                  _hwnd:HWND):               PMWIN index 877;
       PROCEDURE WinDisMissDlg(result:LONGWORD;Dlg:HWND):    PMWIN index 729;
       FUNCTION WinSendDlgItemMsg(para2,para1:LONGWORD;
                                  msg,id:LONGWORD;
                                  Dlg:HWND):LONGWORD:        PMWIN index 903;
       FUNCTION WinQueryWindowPos(_swp:SWP;
                                   _hwnd:HWND):LONGWORD:     PMWIN index 837;
       FUNCTION WinSetWindowPos(fl:LONGWORD;
                                 cy,cx,y,x:LONGWORD;
                                 hwndInsertBehind:HWND;
                                 _hwnd:HWND):LONGWORD:       PMWIN index 875;
       FUNCTION WinQueryWindow(cmd:LONGWORD;
                               _hwnd:HWND):LONGWORD:            PMWIN index 834;
END;


{***************************************************************************
*                                                                          *
*                 Common functions                                         *
*                                                                          *
****************************************************************************}

FUNCTION GetCheckBoxState(Dlg:HWND;Id:LONGWORD):LONGWORD;
BEGIN
     GetCheckBoxState:=WinSendDlgItemMsg(0,0,BM_QUERYCHECK,id,Dlg);
 END;

PROCEDURE SetCheckBoxState(Dlg:HWND;Id:LONGWORD;Setit:LONGWORD);
VAR
   para1:LONGWORD;
BEGIN
     IF Setit<>0 THEN Para1:=1
     ELSE Para1:=0;
     WinSendDlgItemMsg(0,para1,BM_SETCHECK,id,Dlg);
END;

FUNCTION GetRadioButtonState(Dlg:HWND;Id:LONGWORD):LONGWORD;
BEGIN
     GetRadioButtonState:=WinSendDlgItemMsg(0,0,BM_QUERYCHECK,id,Dlg);
END;

PROCEDURE SetRadioButtonState(Dlg:HWND;Id:LONGWORD;Setit:LONGWORD);
VAR
   para1:LONGWORD;
BEGIN
     IF Setit<>0 THEN Para1:=1
     ELSE Para1:=0;
     WinSendDlgItemMsg(0,para1,BM_SETCHECK,id,Dlg);
END;

PROCEDURE SetMenuText(Frame:HWND;Id:LONGWORD;s:string);
VAR HwndMenu:HWND;
    p:POINTER;
BEGIN
     HwndMenu:=WinWindowFromID($8005{FID_MENU},Frame);
     IF HwndMenu=0 THEN exit;
     p:=@s;
     inc(p);
     WinSendMsg(LONGWORD(p),id,$018e{MM_SETITEMTEXT},HwndMenu);
END;

PROCEDURE RemoveSubMenuByPos(Frame:HWND;MainMenuID:WORD;pos:Integer);
VAR HwndMenu:HWND;
    p,p1,p2:POINTER;
    mi:RECORD
             iPosition:INTEGER;
             afStyle:WORD;
             afAttribute:WORD;
             id:WORD;
             hwndSubMenu:HWND;
             hItem:LONGWORD;
       END;
    Menu:HWND;
BEGIN
    HwndMenu:=WinWindowFromID($8005{FID_MENU},Frame);
    IF HwndMenu=0 THEN exit;
    p1:=@mi;
    p2:=MPFROM2SHORT(MainMenuID,1);
    IF WinSendMsg(LONGWORD(p1),LONGWORD(p2),$0182{MM_QUERYITEM},HwndMenu)=0
      THEN exit;
    Menu:=mi.hwndSubMenu;
    WinSendMsg(0,pos,$01f1{MM_DELETEITEMBYPOS},Menu);
END;

PROCEDURE InsertSubMenu(Frame:HWND;MainMenuID:WORD;pos:INTEGER;id:WORD;
                        s:STRING);
VAR HwndMenu:HWND;
    p,p1,p2:POINTER;
    mi:RECORD
             iPosition:INTEGER;
             afStyle:WORD;
             afAttribute:WORD;
             id:WORD;
             hwndSubMenu:HWND;
             hItem:LONGWORD;
       END;
    Menu:HWND;
BEGIN
    HwndMenu:=WinWindowFromID($8005{FID_MENU},Frame);
    IF HwndMenu=0 THEN exit;
    p:=@s;
    inc(p);
    p1:=@mi;
    p2:=MPFROM2SHORT(MainMenuID,1);
    IF WinSendMsg(LONGWORD(p1),LONGWORD(p2),$0182{MM_QUERYITEM},HwndMenu)=0
      THEN exit;
    Menu:=mi.hwndSubMenu;
    IF Menu=0 THEN exit;
    mi.iPosition:=pos;
    IF id=65535 THEN mi.afStyle:=4  {MIS_SEPARATOR}
    ELSE mi.afStyle:=1;  {MIS_TEXT}
    mi.afAttribute:=0;
    mi.id:=id;
    mi.hwndSubMenu:=0;
    mi.hitem:=0;
    p1:=@mi;
    WinSendMsg(LONGWORD(p),LONGWORD(p1),$0180{MM_INSERTITEM},Menu);
END;

PROCEDURE RemoveSubMenu(Frame:HWND;id:WORD);
VAR HwndMenu:HWND;
    p:POINTER;
BEGIN
    HwndMenu:=WinWindowFromID($8005{FID_MENU},Frame);
    IF HwndMenu=0 THEN exit;
    p:=MPFROM2SHORT(id,1);
    WinSendMsg(0,LONGWORD(p),$0181{MM_DELETEITEM},hwndMenu);
END;


PROCEDURE DeleteListBox(VAR List:PListBoxItems);
VAR
   Help:PListBoxItems;
BEGIN
     WHILE List<>NIL DO
     BEGIN
          Help:=List^.Next;
          IF List^.cbData<>0 THEN IF List^.Data<>NIL THEN
           FreeMem(List^.Data,List^.cbData);
          Dispose(List);
          List:=Help;
     END;
END;

PROCEDURE ListBoxGetSelItem(Dlg:HWND;id:LONGWORD;VAR result:TListBoxItems;
                            VAR List:PListBoxItems;Erase:BOOLEAN);
VAR HwndElement:HWND;
    _index:WORD;
    Help,HList:PListBoxItems;
    pbSource,pbDest:^Byte;
Label l;
BEGIN
     HwndElement:=WinWindowFromID(id,Dlg);
     _index:=WinSendMsg(0,LIT_FIRST,LM_QUERYSELECTION,HwndElement);
     Result.Item:='';
     Result._index:=65535;
     HList:=List;
     WHILE HList<>NIL DO
     BEGIN
          IF HList^._index=_Index THEN
          BEGIN
               Result:=HList^;
               IF result.cbData>0 THEN if result.Data<>NIL THEN
               BEGIN
                    GetMem(result.Data,result.cbData);
                    pbsource:=HList^.Data;
                    pbDest:=result.Data;
                    move(pbSource^,pbDest^,result.cbData);
               END;
               goto l;
          END;
          HList:=HList^.Next;
     END;
l:
     Result.Next:=NIL;
     IF Erase THEN DeleteListBox(List);
END;

PROCEDURE NewListBoxItem(VAR List:PListBoxItems;item:String;Data:POINTER;
                         cbData:LONGWORD;Sort:BOOLEAN);
VAR dummy:PListBoxItems;
    Prev:PListBoxItems;
LABEL l,l1;
BEGIN
     IF List=NIL THEN
     BEGIN
          New(List);
          dummy:=List;
          dummy^.Next:=NIL;
     END
     ELSE
     BEGIN
          IF Sort THEN
          BEGIN
               dummy:=List;
               Prev:=NIL;
               WHILE dummy<>NIL DO
               BEGIN
                    IF dummy^.Item>Item THEN goto l;
                    Prev:=dummy;
                    dummy:=dummy^.Next;
               END;
               {No Item found --> Append at end of List}
               New(Prev^.Next);
               dummy:=Prev^.Next;
               dummy^.Next:=NIL;
               goto l1;
l:
               {Insert the item at this position}
               IF Prev=NIL THEN {At start of the list}
               BEGIN
                    dummy:=List;
                    New(List);
                    List^.Next:=dummy;
                    dummy:=List;
               END
               ELSE {at position after Prev}
               BEGIN
                    dummy:=Prev^.Next;
                    New(Prev^.Next);
                    Prev:=Prev^.Next;
                    Prev^.Next:=dummy;
                    dummy:=Prev;
               END;
          END
          ELSE
          BEGIN
               dummy:=List;
               WHILE dummy^.Next<>NIL do dummy:=dummy^.Next;
               New(dummy^.Next);
               dummy:=dummy^.Next;
               dummy^.Next:=NIL;
          END;
     END;
l1:
     dummy^.item:=item;
     dummy^._index:=0;
     dummy^.Data:=Data;
     dummy^.cbData:=cbData;
END;

FUNCTION ListBoxInsertString(Dlg:HWND;where:LONGINT;
                             s:string):WORD;
VAR
    p:POINTER;
    _index:WORD;
BEGIN
     p:=@s;
     inc(p);
     _index:=WinSendMsg(LONGWORD(p),where,LM_INSERTITEM,Dlg);
     ListBoxInsertString:=_Index;
END;

PROCEDURE FillListBox(Dlg:HWND;id:LONGWORD;List:PListBoxItems);
VAR
   HwndElement:HWND;
   p:POINTER;
   s:String;
BEGIN
     HwndElement:=WinWindowFromID(id,Dlg);
     WinEnableWindowUpdate(0,hwndElement);

     WHILE List<>NIL DO
     BEGIN
          List^._Index:=ListBoxInsertString(HwndElement,LIT_END,
                                            List^.item);
          List:=List^.Next;
     END;
     WinShowWindow(1,HwndElement);
END;

PROCEDURE DialogSetText(Dlg:HWND;id:LONGWORD;s:String);
VAR
    HwndElement:HWND;
    t:BYTE;
    p:POINTER;
BEGIN
     HwndElement:=WinWindowFromID(id,Dlg);
     p:=@s;
     Inc(p);
     WinSetWindowText(p,HwndElement);
END;

PROCEDURE DialogGetText(Dlg:HWND;id:LONGWORD;VAR s:String;cb:BYTE);
VAR
    HwndElement:HWND;
    t:BYTE;
BEGIN
     HwndElement:=WinWindowFromID(id,Dlg);
     WinQueryWindowText(s[1],cb,HwndElement);
     FOR t:=1 TO cb-1 DO IF s[t]=#0 THEN
     BEGIN
          s[0]:=chr(t-1);
          WHILE s[length(s)]=#32 do dec(s[0]);
          exit;
     END;
     s[0]:=#0;
END;

PROCEDURE SetTextLimit(Dlg:HWND;id:LONGWORD;Limit:BYTE);
VAR
   HwndElement:HWND;
BEGIN
     HwndElement:=WinWindowFromID(id,Dlg);
     WinSendMsg(0,Limit,EM_SETTEXTLIMIT,HwndElement);
END;

{***************************************************************************
*                                                                          *
*            Methods for TDIALOG                                           *
*                                                                          *
****************************************************************************}

PROCEDURE TDialog.GetDlg(VAR Dlg:HWND);
BEGIN
     Dlg:=hwnddlg;
END;

PROCEDURE TDialog.CenterDlgBox(Dlg:HWND);
VAR
   swpParent:SWP;
   swpDialog:SWP;
   xDiv,yDiv,xdiv1,ydiv1:LONGWORD;
   DlgParent:HWND;
BEGIN
     DlgParent:=WinQueryWindow(QW_PARENT,Dlg);
     WinQueryWindowPos (swpParent,DlgParent);
     WinQueryWindowPos (swpDialog,Dlg);
     xDiv:=swpParent.cx DIV 2;
     yDiv:=swpParent.cy DIV 2;
     xdiv1:=swpDialog.cx DIV 2;
     ydiv1:=swpDialog.cy DIV 2;
     IF xdiv>xdiv1 THEN
      swpDialog.x:=xdiv-xdiv1;
     IF ydiv>ydiv1 THEN
      swpDialog.y:=ydiv-ydiv1;
     WinSetWindowPos (swpDialog.fl OR SWP_ACTIVATE,swpDialog.cy,
                      swpDialog.cx,swpDialog.y,
                      swpDialog.x,swpDialog.HwndInsertBehind,Dlg);
END;

PROCEDURE TDialog.WMInitDlg(VAR Msg:TMessage);
BEGIN
     CenterDlgBox(Msg.Win);
     Msg.Result:=1; {!!!} {Dont remove this - Radiobuttons wont work}
END;

PROCEDURE TDialog.WMControl(VAR Msg:TMessage);
BEGIN
END;


FUNCTION TDialog.DialogHandleEvent(Dlg:HWND;msg:LONGWORD;Para1,Para2:
                             LONGWORD;VAR Handled:BOOLEAN):LONGWORD;
VAR H:BOOLEAN;
    r:LONGWORD;
    DmtFound:BOOLEAN;
    _Msg:TMessage;
BEGIN
     r:=0;
     H:=FALSE;  {not handled}
     _Msg.Win:=Dlg;
     _Msg.Para1:=LONGWORD(Para1);
     _Msg.Para2:=LONGWORD(Para2);
     _Msg.Message:=Msg;
     _Msg.Handled:=TRUE;
     _msg.Result:=0;
     DMTFound:=FALSE;
     {Check for dynamic methods}
     ASM
        MOV EDI,$!SELF
        MOV EDI,[EDI+4]   ;DMT table address
        MOV ECX,[EDI+0]   ;DMT table size
        SHR ECX,3         ;Divide by 8
        CMP ECX,0
        JE !NoDMT         ;no dynamic methods
        ADD EDI,4         ;onto first DMT entry
        MOV EAX,$Msg
!DMTLoop:
        CMP EAX,[EDI+0]
        JE !DMTHere       ;Message found
        ADD EDI,8         ;next DMT entry
        LOOP !DMTLoop
        JMP !NoDMT
!DMTHere:
        MOVB $DMTFound,1
        LEA EAX,$_Msg
        PUSH EAX          ;Parameter for dynamic method call
        MOV EAX,[EDI+4]   ;Method index in VMT
        DEC EAX
        SHL EAX,2         ;multiply with 4
        MOV EDI,$!SELF
        PUSH EDI          ;VMT for dynamic method
        MOV EDI,[EDI+0]   ;Get VMT address
        ADD EDI,EAX       ;Calculate method
        db ffh,17h       ;CALL NEAR32 [EDI+0] --> in Methode springen
!NoDMT:
      END;
      IF DMTFound THEN
      BEGIN
           H:=_Msg.Handled;
           r:=_Msg.Result;
     END;
     Handled:=H;
     DialogHandleEvent:=r;
END;


PROCEDURE StdDlgProc(para2,para1:POINTER;Msg,Win:LONGWORD);ASM;
BEGIN
     ASM
        PUSH EBP

        MOV EBP,ESP
        SUB ESP,2
        ;Save parameters as it is SYSTEM Calling Convention
        PUSH EDI
        PUSH ESI
        PUSH EBX

        MOVW [EBP-2],0   ;Not Handled
        PUSHL $Win
        PUSHL $Msg
        PUSHL $para1
        PUSHL $para2
        LEA EAX,[EBP-2]  ;Handled
        PUSH EAX
        MOV EDI,_DialogVMT
        PUSH EDI         ;VMT Pointer
        MOV EDI,[EDI+0]  ;get VMT pointer for AppHandleEvent
        db ffh,17h       ;CALL NEAR32 [EDI+0] --> Jump into method

        MOV BL,[EBP-2]
        CMP BL,0
        JNE !hh

        ;not handled -> Call default Dialog handler
        PUSHL $para2
        PUSHL $para1
        PUSHL $msg
        PUSHL $win
        MOV AL,4
        CALLDLL PMWin,910   ;WinDefDlgProc
        ADD ESP,16
!hh:
        ;Get registers as it is SYSTEM calling convention
        POP EBX
        POP ESI
        POP EDI
        LEAVE
        RETN32
     END;
END;

CONSTRUCTOR TDialog.Init(Parent,Owner:HWND;hmod:HModule;idDlg:LONGWORD;
                         PCreateParams:Pointer);
BEGIN
     DialogVMT:=SELF;
     hwnddlg:=0;
     hwnddlg:=WinLoadDlg(PCreateParams,idDlg,hmod,@StdDlgProc,Owner,Parent);
END;

DESTRUCTOR TDialog.Done;
BEGIN
END;

PROCEDURE TDialog.ExecDialog(VAR r:LONGWORD);
BEGIN
     r:=WinProcessDlg(hwnddlg);
     WinDestroyWindow(hwnddlg);
END;


TYPE PFileDlg=^FileDlg;
     FileDlg=record
                   cbSize:LONGWORD;        { Size of FILEDLG structure.}
                   fl:LONGWORD;            { FDS_ flags. Alter behavior of dlg. }
                   ulUser:LONGWORD;        { User defined field. }
                   lReturn:LONGWORD;       { Result code from dialog dismissal. }
                   lSRC:LONGWORD;          { System return code. }
                   pszTitle:POINTER;       { String to display in title bar.}
                   pszOKButton:POINTER;    { String to display in OK button. }
                   pfnDlgProc:POINTER;     { Entry point to custom dialog proc. }
                   pszIType:POINTER;       { Pointer to string }
                   papszITypeList:POINTER;
                   pszIDrive:POINTER;
                   papszIDriveList:POINTER;
                   hMod:LONGWORD;   { Custom File Dialog template.       }
                   szFullFile:ARRAY[0..259] OF Char;
                   papszFQFilename:POINTER;
                   ulFQFCount:LONGWORD;  { Number of files selected }
                   usDlgId:WORD;         { Custom dialog id.}
                   x:WORD;               { X coordinate of the dialog  }
                   y:WORD;               { Y coordinate of the dialog  }
                   sEAType:WORD;         { Selected files EA Type. }
             END;

FUNCTION FileOpenDialog(Win:HWND;VAR result:String):Boolean;
VAR Dlg:FileDlg;
    t:BYTE;
BEGIN
     fillchar(dlg,sizeof(FileDlg),0); {Clear Dialog structure}
     ASM
        LEA EDI,$dlg
        ADD EDI,20   ;to pszTitle
        MOV EAX,OFFSET(_FileOpenDlgTitle)
        INC EAX
        MOV [EDI+0],EAX

        LEA EDI,$dlg
        ADD EDI,24  ;to pszOKButton
        MOV EAX,OFFSET(_FileOpenDlgOkName)
        INC EAX
        MOV [EDI+0],EAX

        LEA EDI,$dlg
        ADD EDI,52  ;to szFullFile
        MOV ESI,OFFSET(_FileOpenDlgWildCards)
        MOV CL,[ESI+0]
        INC ESI
        MOVZX ECX,CL
        INC ECX
        CLD
        REP
        MOVSB
     END;
     dlg.cbSize:=sizeof(Filedlg);
     dlg.fl:=$901;  {FDS_OPEN_DIALOG | FDS_CENTER | FDS_ENABLEFILELB }
     ASM
        LEA EAX,$Dlg
        PUSH EAX
        PUSHL $Win
        PUSHL 1   ;Owner is HWND_DESKTOP
        MOV AL,3
        CALLDLL PMCTLS,4  ;WinFileDlg
        ADD ESP,12
     END;
     IF Dlg.lReturn=1 THEN {DID_OK}
     BEGIN
          asm
             MOV EDI,$result
             INC EDI
             LEA ESI,$dlg
             ADD ESI,52  ;to szFullFile
             MOV CX,0
!next:
             MOV AL,[ESI+0]
             CMP AL,0
             JE !ec
             MOV [EDI+0],AL
             INC EDI
             INC ESI
             INC CX
             JMP !next
!ec:
             MOV EDI,$result
             MOV [EDI+0],CL  ;set length
          end;
          FileOpenDialog:=TRUE;
     END
     ELSE
     BEGIN
          result:='';
          FileOpenDialog:=FALSE;
     END;
     FOR t:=1 TO length(result) DO result[t]:=upcase(result[t]);
END;

FUNCTION FileSaveDialog(Win:HWND;VAR result:String):Boolean;
VAR Dlg:FileDlg;
    t:BYTE;
BEGIN
     fillchar(dlg,sizeof(FileDlg),0); {Clear Dialog structure}
     asm
        LEA EDI,$dlg
        ADD EDI,20   ;to pszTitle
        MOV EAX,OFFSET(_FileSaveDlgTitle)
        INC EAX
        MOV [EDI+0],EAX

        LEA EDI,$dlg
        ADD EDI,24  ;to pszOKButton
        mOV EAX,OFFSET(_FileSaveDlgOkName)
        INC EAX
        MOV [EDI+0],EAX

        LEA EDI,$dlg
        ADD EDI,52  ;to szFullFile
        MOV ESI,OFFSET(_FileSaveDlgWildCards)
        MOV CL,[ESI+0]
        INC ESI
        MOVZX ECX,CL
        INC ECX
        CLD
        REP
        MOVSB
     end;
     Dlg.cbSize:=sizeof(Filedlg);
     Dlg.fl:=$a01;  {FDS_SAVEAS_DIALOG | FDS_CENTER | FDS_ENABLEFILELB }
     asm
        LEA EAX,$Dlg
        PUSH EAX
        PUSHL $Win
        PUSHL 1   ;Owner is HWND_DESKTOP
        MOV AL,3
        CALLDLL PMCTLS,4  ;WinFileDlg
        ADD ESP,12
     end;
     IF Dlg.lReturn=1 THEN {DID_OK}
     BEGIN
          asm
             MOV EDI,$result
             INC EDI
             LEA ESI,$dlg
             ADD ESI,52  ;to szFullFile
             MOV CX,0
!next_1:
             MOV AL,[ESI+0]
             CMP AL,0
             JE !ec_1
             MOV [EDI+0],AL
             INC EDI
             INC ESI
             INC CX
             JMP !next_1
!ec_1:
             MOV EDI,$result
             MOV [EDI+0],CL  ;set length
          end;
          FileSaveDialog:=TRUE;
     END
     ELSE
     BEGIN
          result:='';
          FileSaveDialog:=FALSE;
     END;
     FOR t:=1 TO length(result) DO result[t]:=upcase(result[t]);
END;


BEGIN
     FileOpenDlgTitle:='Open a file';
     FileOpenDlgWildcards:='*.*';
     FileOpenDlgOkname:='Open';
     FileSaveDlgTitle:='Save file as';
     FileSaveDlgWildcards:='*.*';
     FileSaveDlgOkname:='Save';
END. 























































 























































