#ifndef SYSCAT_H
#define SYSCAT_H

/*===========================================================================
    Raima SQL System Catalog
    RDM DDL Specification

    Copyright (c) 1991-1994 Raima Corporation.  All Rights Reserved.
===========================================================================*/

/* database syscat record/key structure declarations */

struct sysvals {
   short version;
   short dbid;
   short instid;
   short tableid;
   short viewid;
   short colid;
   short joinid;
   short procid;
   short userid;
};

struct sysparms {
   short maxstring;
   short maxsubqvals;
   short sortpgsz;
   short maxdbs;
   short maxtables;
   short maxedges;
   short maxviews;
   short maxprocs;
   short maxudfs;
   short histprec;
   short sortlimit;
   short colstats;
   long optyield;
   long optlimit;
   double cpuratio;
   short locktime;
   char currsymb;
   char decsymb;
   char thousymb;
   char wildall;
   char wildone;
   short caltype;
   short date_format;
   char date_sep;
   short maxprecision;
   short maxscale;
   short mergelimit;
   short uselogins;
};

struct sysschema {
   char name[33];
   char owner_name[15];
   short tot_vers;
};

struct sysdb {
   short dbid;
   short currver;
   short version;
   short pgsize;
   char device[10];
   short tot_tables;
   short tot_columns;
   short tot_joins;
   short tot_files;
   short tot_edges;
   char src_file[16];
   short noinsts;
   short sysnulls;
   short sysrefs;
   DB_ADDR defn;
};

struct sysinstance {
   char name[33];
   short instid;
   short dbid;
   char device[10];
   struct {
      long updstats_date;
      long updstats_time;
   } updstats;
};

struct systabstat {
   short tableid;
   short instid;
   long nopages;
   long norows;
};

struct sysndxstat {
   short indexno;
   short active;
   long nopages;
   long norows;
   long nodistinct;
   short depth;
   short hist_prec;
   short hist_slsize;
   DB_ADDR histogram;
};

struct syscolstat {
   DB_ADDR hilo_blob;
};

struct sysfile {
   char name[33];
   char device[10];
   short dbid;
   short fileid;
   short pgsize;
   char type[6];
   short src_line;
};

struct sysindex {
   char name[33];
   short dbid;
   short indexno;
   long keyid;
   char type;
   short src_line;
};

struct sysindexcol {
   char type;
   short seqno;
};

struct systable {
   char name[33];
   short dbid;
   short tableid;
   short tabno;
   short recid;
   short userid;
   short colid;
   DB_ADDR defn;
   DB_ADDR p_code;
   DB_ADDR comment;
   short src_line;
   short public_access;
};

struct sysview {
   char name[33];
   short dbid;
   short viewid;
   short disposition;
   short type;
   DB_ADDR p_code;
   DB_ADDR comment;
   short public_access;
};

struct syslookup {
   short type;
   char qual_name[33];
   char name[33];
   DB_ADDR comment;
   DB_ADDR tabcols;
};

struct systableid {
   short refscnt;
};

struct syscolumn {
   char name[33];
   short dbid;
   short tableid;
   char table_type;
   short colid;
   short colno;
   long fieldid;
   short data_type;
   short size[3];
   char prec;
   char scale;
   short col_type;
   long pkfield;
   short setid;
   DB_ADDR comment;
   short deflt_type;
   char deflt_val[20][1];
   DB_ADDR deflt_blob;
   DB_ADDR hilo_blob;
   short src_line;
   short public_access;
   DB_ADDR c_data_blob;
};

struct sysproc {
   char name[33];
   short procid;
   short disposition;
   short inpargs;
   DB_ADDR p_code;
   DB_ADDR comment;
   char module[33];
   char device[10];
};

struct sysjoin {
   char name[33];
   char ordering[7];
   short dbid;
   short joinid;
   short setid;
   short src_line;
};

struct syskey {
   char type;
   short updates;
   short refcnt;
   DB_ADDR ndx;
   DB_ADDR cols[8];
};

struct sysforkey {
   DB_ADDR cols[8];
   DB_ADDR ndx;
   char type;
};

struct sysedge {
   short sourceid;
   short destid;
   char one_or_many;
   char access;
};

struct sysjoincol {
   char type;
};

struct sysfunc {
   char type;
   char name[33];
   char module[33];
   char device[10];
   DB_ADDR comment;
};

struct sysfilter {
   char name[33];
   short auto_commit;
   char module[33];
   char device[10];
   DB_ADDR comment;
};

struct sysuser {
   char name[15];
   char login_proc[33];
   char logout_proc[33];
   short userid;
   short command_access;
};

struct sysright {
   short userid;
   short type;
   short access;
   DB_ADDR entity;
};

struct syserror {
   short errcode;
   short errtype;
   short errinfo;
   char errid[22];
   char sqlstate[6];
   char summary[49];
};

struct syserrline {
   char txtln[84];
};

struct syscomment {
   char txtln[133];
};

struct sysobject {
   DB_ADDR head;
   long size;
};

struct sysobj62 {
   DB_ADDR nxtb;
   char bytes[62][1];
};

struct sysobj134 {
   DB_ADDR nxtb;
   char bytes[134][1];
};

struct sysobj330 {
   DB_ADDR nxtb;
   char bytes[330][1];
};

struct sysobj500 {
   DB_ADDR nxtb;
   char bytes[500][1];
};

struct sysobj1010 {
   DB_ADDR nxtb;
   char bytes[1010][1];
};

struct systypes {
   short data_type;
   char type_name[33];
   char literal_prefix[17];
   long prec;
   char create_params[33];
};

struct sysseclog {
   struct {
      long issued_date;
      long issued_time;
   } issued;
};

struct systext {
   char txtln[133];
};

struct sysschema_db_name {
   char name[33];
};

struct sysdb_db_key {
   short dbid;
};

struct sysinstance_inst_name {
   char name[33];
};

struct sysinstance_dbdev_key {
   char device[10];
   short dbid;
};

struct sysinstance_inst_key {
   short instid;
};

struct systabstat_stat_key {
   short instid;
   short tableid;
};

struct sysfile_file_name {
   char name[33];
   short dbid;
};

struct sysindex_key_name {
   char name[33];
   short dbid;
};

struct systable_tab_key {
   short tableid;
};

struct systable_tab_name {
   char name[33];
   short dbid;
};

struct sysview_view_key {
   short viewid;
};

struct sysview_view_name {
   char name[33];
   short dbid;
};

struct syslookup_by_type {
   short type;
   char qual_name[33];
   char name[33];
};

struct syslookup_by_qual {
   char qual_name[33];
   char name[33];
};

struct syslookup_by_name {
   char name[33];
};

struct syscolumn_col_name {
   char name[33];
   short tableid;
   char table_type;
};

struct sysproc_proc_key {
   short procid;
};

struct sysproc_proc_name {
   char name[33];
};

struct sysjoin_join_key {
   short joinid;
};

struct sysjoin_join_name {
   char name[33];
   short dbid;
};

struct syskey_pkey {
   DB_ADDR cols[8];
};

struct sysforkey_fkey {
   DB_ADDR cols[8];
};

struct sysedge_edge_key {
   short sourceid;
   short destid;
};

struct sysfunc_func_name {
   char name[33];
};

struct sysfilter_filter_name {
   char name[33];
};

struct sysuser_user_name {
   char name[15];
};

struct sysuser_login_name {
   char login_proc[33];
};

struct sysuser_logout_name {
   char login_proc[33];
};

struct sysright_right_key {
   DB_ADDR entity;
   short userid;
};

struct syserror_err_code_key {
   short errcode;
};

struct syserror_err_id_key {
   char errid[22];
};

/* record, field and set table entry definitions */

/* File Id Constants */

/* Record Name Constants */
#define SYSVALS 10000
#define SYSPARMS 10001
#define SYSSCHEMA 10002
#define SYSDB 10003
#define SYSINSTANCE 10004
#define SYSTABSTAT 10005
#define SYSNDXSTAT 10006
#define SYSCOLSTAT 10007
#define SYSFILE 10008
#define SYSINDEX 10009
#define SYSINDEXCOL 10010
#define SYSTABLE 10011
#define SYSVIEW 10012
#define SYSLOOKUP 10013
#define SYSTABLEID 10014
#define SYSCOLUMN 10015
#define SYSDEPENDS 10016
#define SYSPROC 10017
#define SYSJOIN 10018
#define SYSKEY 10019
#define SYSFORKEY 10020
#define SYSEDGE 10021
#define SYSJOINCOL 10022
#define SYSFUNC 10023
#define SYSFILTER 10024
#define SYSUSER 10025
#define SYSRIGHT 10026
#define SYSERROR 10027
#define SYSERRLINE 10028
#define SYSCOMMENT 10029
#define SYSOBJECT 10030
#define SYSOBJ62 10031
#define SYSOBJ134 10032
#define SYSOBJ330 10033
#define SYSOBJ500 10034
#define SYSOBJ1010 10035
#define SYSTYPES 10036
#define SYSSECLOG 10037
#define SYSTEXT 10038

/* Field Name Constants */
#define SYSVALS_VERSION 0L
#define SYSVALS_DBID 1L
#define SYSVALS_INSTID 2L
#define SYSVALS_TABLEID 3L
#define SYSVALS_VIEWID 4L
#define SYSVALS_COLID 5L
#define SYSVALS_JOINID 6L
#define SYSVALS_PROCID 7L
#define SYSVALS_USERID 8L
#define SYSPARMS_MAXSTRING 1000L
#define SYSPARMS_MAXSUBQVALS 1001L
#define SYSPARMS_SORTPGSZ 1002L
#define SYSPARMS_MAXDBS 1003L
#define SYSPARMS_MAXTABLES 1004L
#define SYSPARMS_MAXEDGES 1005L
#define SYSPARMS_MAXVIEWS 1006L
#define SYSPARMS_MAXPROCS 1007L
#define SYSPARMS_MAXUDFS 1008L
#define SYSPARMS_HISTPREC 1009L
#define SYSPARMS_SORTLIMIT 1010L
#define SYSPARMS_COLSTATS 1011L
#define SYSPARMS_OPTYIELD 1012L
#define SYSPARMS_OPTLIMIT 1013L
#define SYSPARMS_CPURATIO 1014L
#define SYSPARMS_LOCKTIME 1015L
#define SYSPARMS_CURRSYMB 1016L
#define SYSPARMS_DECSYMB 1017L
#define SYSPARMS_THOUSYMB 1018L
#define SYSPARMS_WILDALL 1019L
#define SYSPARMS_WILDONE 1020L
#define SYSPARMS_CALTYPE 1021L
#define SYSPARMS_DATE_FORMAT 1022L
#define SYSPARMS_DATE_SEP 1023L
#define SYSPARMS_MAXPRECISION 1024L
#define SYSPARMS_MAXSCALE 1025L
#define SYSPARMS_MERGELIMIT 1026L
#define SYSPARMS_USELOGINS 1027L
#define SYSSCHEMA_NAME 2000L
#define SYSSCHEMA_OWNER_NAME 2001L
#define SYSSCHEMA_TOT_VERS 2002L
#define SYSSCHEMA_DB_NAME 2003L
#define SYSDB_DBID 3000L
#define SYSDB_CURRVER 3001L
#define SYSDB_VERSION 3002L
#define SYSDB_PGSIZE 3003L
#define SYSDB_DEVICE 3004L
#define SYSDB_TOT_TABLES 3005L
#define SYSDB_TOT_COLUMNS 3006L
#define SYSDB_TOT_JOINS 3007L
#define SYSDB_TOT_FILES 3008L
#define SYSDB_TOT_EDGES 3009L
#define SYSDB_SRC_FILE 3010L
#define SYSDB_NOINSTS 3011L
#define SYSDB_SYSNULLS 3012L
#define SYSDB_SYSREFS 3013L
#define SYSDB_DEFN 3014L
#define SYSDB_DB_KEY 3015L
#define SYSINSTANCE_NAME 4000L
#define SYSINSTANCE_INSTID 4001L
#define SYSINSTANCE_DBID 4002L
#define SYSINSTANCE_DEVICE 4003L
#define SYSINSTANCE_UPDSTATS 4004L
#define SYSINSTANCE_UPDSTATS_DATE 4005L
#define SYSINSTANCE_UPDSTATS_TIME 4006L
#define SYSINSTANCE_INST_NAME 4007L
#define SYSINSTANCE_DBDEV_KEY 4008L
#define SYSINSTANCE_INST_KEY 4009L
#define SYSTABSTAT_TABLEID 5000L
#define SYSTABSTAT_INSTID 5001L
#define SYSTABSTAT_NOPAGES 5002L
#define SYSTABSTAT_NOROWS 5003L
#define SYSTABSTAT_STAT_KEY 5004L
#define SYSNDXSTAT_INDEXNO 6000L
#define SYSNDXSTAT_ACTIVE 6001L
#define SYSNDXSTAT_NOPAGES 6002L
#define SYSNDXSTAT_NOROWS 6003L
#define SYSNDXSTAT_NODISTINCT 6004L
#define SYSNDXSTAT_DEPTH 6005L
#define SYSNDXSTAT_HIST_PREC 6006L
#define SYSNDXSTAT_HIST_SLSIZE 6007L
#define SYSNDXSTAT_HISTOGRAM 6008L
#define SYSCOLSTAT_HILO_BLOB 7000L
#define SYSFILE_NAME 8000L
#define SYSFILE_DEVICE 8001L
#define SYSFILE_DBID 8002L
#define SYSFILE_FILEID 8003L
#define SYSFILE_PGSIZE 8004L
#define SYSFILE_TYPE 8005L
#define SYSFILE_SRC_LINE 8006L
#define SYSFILE_FILE_NAME 8007L
#define SYSINDEX_NAME 9000L
#define SYSINDEX_DBID 9001L
#define SYSINDEX_INDEXNO 9002L
#define SYSINDEX_KEYID 9003L
#define SYSINDEX_TYPE 9004L
#define SYSINDEX_SRC_LINE 9005L
#define SYSINDEX_KEY_NAME 9006L
#define SYSINDEXCOL_TYPE 10000L
#define SYSINDEXCOL_SEQNO 10001L
#define SYSTABLE_NAME 11000L
#define SYSTABLE_DBID 11001L
#define SYSTABLE_TABLEID 11002L
#define SYSTABLE_TABNO 11003L
#define SYSTABLE_RECID 11004L
#define SYSTABLE_USERID 11005L
#define SYSTABLE_COLID 11006L
#define SYSTABLE_DEFN 11007L
#define SYSTABLE_P_CODE 11008L
#define SYSTABLE_COMMENT 11009L
#define SYSTABLE_SRC_LINE 11010L
#define SYSTABLE_PUBLIC_ACCESS 11011L
#define SYSTABLE_TAB_KEY 11012L
#define SYSTABLE_TAB_NAME 11013L
#define SYSVIEW_NAME 12000L
#define SYSVIEW_DBID 12001L
#define SYSVIEW_VIEWID 12002L
#define SYSVIEW_DISPOSITION 12003L
#define SYSVIEW_TYPE 12004L
#define SYSVIEW_P_CODE 12005L
#define SYSVIEW_COMMENT 12006L
#define SYSVIEW_PUBLIC_ACCESS 12007L
#define SYSVIEW_VIEW_KEY 12008L
#define SYSVIEW_VIEW_NAME 12009L
#define SYSLOOKUP_TYPE 13000L
#define SYSLOOKUP_QUAL_NAME 13001L
#define SYSLOOKUP_NAME 13002L
#define SYSLOOKUP_COMMENT 13003L
#define SYSLOOKUP_TABCOLS 13004L
#define SYSLOOKUP_BY_TYPE 13005L
#define SYSLOOKUP_BY_QUAL 13006L
#define SYSLOOKUP_BY_NAME 13007L
#define SYSTABLEID_REFSCNT 14000L
#define SYSCOLUMN_NAME 15000L
#define SYSCOLUMN_DBID 15001L
#define SYSCOLUMN_TABLEID 15002L
#define SYSCOLUMN_TABLE_TYPE 15003L
#define SYSCOLUMN_COLID 15004L
#define SYSCOLUMN_COLNO 15005L
#define SYSCOLUMN_FIELDID 15006L
#define SYSCOLUMN_DATA_TYPE 15007L
#define SYSCOLUMN_SIZE 15008L
#define SYSCOLUMN_PREC 15009L
#define SYSCOLUMN_SCALE 15010L
#define SYSCOLUMN_COL_TYPE 15011L
#define SYSCOLUMN_PKFIELD 15012L
#define SYSCOLUMN_SETID 15013L
#define SYSCOLUMN_COMMENT 15014L
#define SYSCOLUMN_DEFLT_TYPE 15015L
#define SYSCOLUMN_DEFLT_VAL 15016L
#define SYSCOLUMN_DEFLT_BLOB 15017L
#define SYSCOLUMN_HILO_BLOB 15018L
#define SYSCOLUMN_SRC_LINE 15019L
#define SYSCOLUMN_PUBLIC_ACCESS 15020L
#define SYSCOLUMN_C_DATA_BLOB 15021L
#define SYSCOLUMN_COL_NAME 15022L
#define SYSPROC_NAME 17000L
#define SYSPROC_PROCID 17001L
#define SYSPROC_DISPOSITION 17002L
#define SYSPROC_INPARGS 17003L
#define SYSPROC_P_CODE 17004L
#define SYSPROC_COMMENT 17005L
#define SYSPROC_MODULE 17006L
#define SYSPROC_DEVICE 17007L
#define SYSPROC_PROC_KEY 17008L
#define SYSPROC_PROC_NAME 17009L
#define SYSJOIN_NAME 18000L
#define SYSJOIN_ORDERING 18001L
#define SYSJOIN_DBID 18002L
#define SYSJOIN_JOINID 18003L
#define SYSJOIN_SETID 18004L
#define SYSJOIN_SRC_LINE 18005L
#define SYSJOIN_JOIN_KEY 18006L
#define SYSJOIN_JOIN_NAME 18007L
#define SYSKEY_TYPE 19000L
#define SYSKEY_UPDATES 19001L
#define SYSKEY_REFCNT 19002L
#define SYSKEY_NDX 19003L
#define SYSKEY_COLS 19004L
#define SYSKEY_PKEY 19005L
#define SYSFORKEY_COLS 20000L
#define SYSFORKEY_NDX 20001L
#define SYSFORKEY_TYPE 20002L
#define SYSFORKEY_FKEY 20003L
#define SYSEDGE_SOURCEID 21000L
#define SYSEDGE_DESTID 21001L
#define SYSEDGE_ONE_OR_MANY 21002L
#define SYSEDGE_ACCESS 21003L
#define SYSEDGE_EDGE_KEY 21004L
#define SYSJOINCOL_TYPE 22000L
#define SYSFUNC_TYPE 23000L
#define SYSFUNC_NAME 23001L
#define SYSFUNC_MODULE 23002L
#define SYSFUNC_DEVICE 23003L
#define SYSFUNC_COMMENT 23004L
#define SYSFUNC_FUNC_NAME 23005L
#define SYSFILTER_NAME 24000L
#define SYSFILTER_AUTO_COMMIT 24001L
#define SYSFILTER_MODULE 24002L
#define SYSFILTER_DEVICE 24003L
#define SYSFILTER_COMMENT 24004L
#define SYSFILTER_FILTER_NAME 24005L
#define SYSUSER_NAME 25000L
#define SYSUSER_LOGIN_PROC 25001L
#define SYSUSER_LOGOUT_PROC 25002L
#define SYSUSER_USERID 25003L
#define SYSUSER_COMMAND_ACCESS 25004L
#define SYSUSER_USER_NAME 25005L
#define SYSUSER_LOGIN_NAME 25006L
#define SYSUSER_LOGOUT_NAME 25007L
#define SYSRIGHT_USERID 26000L
#define SYSRIGHT_TYPE 26001L
#define SYSRIGHT_ACCESS 26002L
#define SYSRIGHT_ENTITY 26003L
#define SYSRIGHT_RIGHT_KEY 26004L
#define SYSERROR_ERRCODE 27000L
#define SYSERROR_ERRTYPE 27001L
#define SYSERROR_ERRINFO 27002L
#define SYSERROR_ERRID 27003L
#define SYSERROR_SQLSTATE 27004L
#define SYSERROR_SUMMARY 27005L
#define SYSERROR_ERR_CODE_KEY 27006L
#define SYSERROR_ERR_ID_KEY 27007L
#define SYSERRLINE_TXTLN 28000L
#define SYSCOMMENT_TXTLN 29000L
#define SYSOBJECT_HEAD 30000L
#define SYSOBJECT_SIZE 30001L
#define SYSOBJ62_NXTB 31000L
#define SYSOBJ62_BYTES 31001L
#define SYSOBJ134_NXTB 32000L
#define SYSOBJ134_BYTES 32001L
#define SYSOBJ330_NXTB 33000L
#define SYSOBJ330_BYTES 33001L
#define SYSOBJ500_NXTB 34000L
#define SYSOBJ500_BYTES 34001L
#define SYSOBJ1010_NXTB 35000L
#define SYSOBJ1010_BYTES 35001L
#define SYSTYPES_DATA_TYPE 36000L
#define SYSTYPES_TYPE_NAME 36001L
#define SYSTYPES_LITERAL_PREFIX 36002L
#define SYSTYPES_PREC 36003L
#define SYSTYPES_CREATE_PARAMS 36004L
#define SYSSECLOG_ISSUED 37000L
#define SYSSECLOG_ISSUED_DATE 37001L
#define SYSSECLOG_ISSUED_TIME 37002L
#define SYSTEXT_TXTLN 38000L

/* Set Name Constants */
#define SYSDBVERS 20000
#define SYSDBINSTS 20001
#define SYSINSTSTATS 20002
#define SYSTABNDXSTATS 20003
#define SYSTABCOLSTATS 20004
#define SYSDBFILES 20005
#define SYSDBINDEXES 20006
#define SYSINDEXSORT 20007
#define SYSDBTABLES 20008
#define SYSCONTAINS 20009
#define SYSTABINDEXES 20010
#define SYSDBVIEWS 20011
#define SYSTABLES 20012
#define SYSTABCOLS 20013
#define SYSISORTCOLS 20014
#define SYSVIEWCOLS 20015
#define SYSLOOKUPCOLS 20016
#define SYSVIEWUSES 20017
#define SYSUSEDVIEW 20018
#define SYSUSEDTABLE 20019
#define SYSDBJOINS 20020
#define SYSKEYS 20021
#define SYSREFS 20022
#define SYSREFBY 20023
#define SYSMEMBERS 20024
#define SYSEDGES 20025
#define SYSJOINSORT 20026
#define SYSJSORTCOLS 20027
#define SYSUSERVIEWS 20028
#define SYSUSERPROCS 20029
#define SYSPERMISSIONS 20030
#define SYSERRDESC 20031
#define SYSSECUSER 20032
#define SYSSECOBJ 20033
#define SYSVIEWTEXT 20034
#define SYSPROCTEXT 20035
#define SYSSECTEXT 20036

/* Field Sizes */
#define SIZEOF_SYSVALS_VERSION 2
#define SIZEOF_SYSVALS_DBID 2
#define SIZEOF_SYSVALS_INSTID 2
#define SIZEOF_SYSVALS_TABLEID 2
#define SIZEOF_SYSVALS_VIEWID 2
#define SIZEOF_SYSVALS_COLID 2
#define SIZEOF_SYSVALS_JOINID 2
#define SIZEOF_SYSVALS_PROCID 2
#define SIZEOF_SYSVALS_USERID 2
#define SIZEOF_SYSPARMS_MAXSTRING 2
#define SIZEOF_SYSPARMS_MAXSUBQVALS 2
#define SIZEOF_SYSPARMS_SORTPGSZ 2
#define SIZEOF_SYSPARMS_MAXDBS 2
#define SIZEOF_SYSPARMS_MAXTABLES 2
#define SIZEOF_SYSPARMS_MAXEDGES 2
#define SIZEOF_SYSPARMS_MAXVIEWS 2
#define SIZEOF_SYSPARMS_MAXPROCS 2
#define SIZEOF_SYSPARMS_MAXUDFS 2
#define SIZEOF_SYSPARMS_HISTPREC 2
#define SIZEOF_SYSPARMS_SORTLIMIT 2
#define SIZEOF_SYSPARMS_COLSTATS 2
#define SIZEOF_SYSPARMS_OPTYIELD 4
#define SIZEOF_SYSPARMS_OPTLIMIT 4
#define SIZEOF_SYSPARMS_CPURATIO 8
#define SIZEOF_SYSPARMS_LOCKTIME 2
#define SIZEOF_SYSPARMS_CURRSYMB 1
#define SIZEOF_SYSPARMS_DECSYMB 1
#define SIZEOF_SYSPARMS_THOUSYMB 1
#define SIZEOF_SYSPARMS_WILDALL 1
#define SIZEOF_SYSPARMS_WILDONE 1
#define SIZEOF_SYSPARMS_CALTYPE 2
#define SIZEOF_SYSPARMS_DATE_FORMAT 2
#define SIZEOF_SYSPARMS_DATE_SEP 1
#define SIZEOF_SYSPARMS_MAXPRECISION 2
#define SIZEOF_SYSPARMS_MAXSCALE 2
#define SIZEOF_SYSPARMS_MERGELIMIT 2
#define SIZEOF_SYSPARMS_USELOGINS 2
#define SIZEOF_SYSSCHEMA_NAME 33
#define SIZEOF_SYSSCHEMA_OWNER_NAME 15
#define SIZEOF_SYSSCHEMA_TOT_VERS 2
#define SIZEOF_SYSDB_DBID 2
#define SIZEOF_SYSDB_CURRVER 2
#define SIZEOF_SYSDB_VERSION 2
#define SIZEOF_SYSDB_PGSIZE 2
#define SIZEOF_SYSDB_DEVICE 10
#define SIZEOF_SYSDB_TOT_TABLES 2
#define SIZEOF_SYSDB_TOT_COLUMNS 2
#define SIZEOF_SYSDB_TOT_JOINS 2
#define SIZEOF_SYSDB_TOT_FILES 2
#define SIZEOF_SYSDB_TOT_EDGES 2
#define SIZEOF_SYSDB_SRC_FILE 16
#define SIZEOF_SYSDB_NOINSTS 2
#define SIZEOF_SYSDB_SYSNULLS 2
#define SIZEOF_SYSDB_SYSREFS 2
#define SIZEOF_SYSDB_DEFN 4
#define SIZEOF_SYSINSTANCE_NAME 33
#define SIZEOF_SYSINSTANCE_INSTID 2
#define SIZEOF_SYSINSTANCE_DBID 2
#define SIZEOF_SYSINSTANCE_DEVICE 10
#define SIZEOF_SYSINSTANCE_UPDSTATS_DATE 4
#define SIZEOF_SYSINSTANCE_UPDSTATS_TIME 4
#define SIZEOF_SYSTABSTAT_TABLEID 2
#define SIZEOF_SYSTABSTAT_INSTID 2
#define SIZEOF_SYSTABSTAT_NOPAGES 4
#define SIZEOF_SYSTABSTAT_NOROWS 4
#define SIZEOF_SYSNDXSTAT_INDEXNO 2
#define SIZEOF_SYSNDXSTAT_ACTIVE 2
#define SIZEOF_SYSNDXSTAT_NOPAGES 4
#define SIZEOF_SYSNDXSTAT_NOROWS 4
#define SIZEOF_SYSNDXSTAT_NODISTINCT 4
#define SIZEOF_SYSNDXSTAT_DEPTH 2
#define SIZEOF_SYSNDXSTAT_HIST_PREC 2
#define SIZEOF_SYSNDXSTAT_HIST_SLSIZE 2
#define SIZEOF_SYSNDXSTAT_HISTOGRAM 4
#define SIZEOF_SYSCOLSTAT_HILO_BLOB 4
#define SIZEOF_SYSFILE_NAME 33
#define SIZEOF_SYSFILE_DEVICE 10
#define SIZEOF_SYSFILE_DBID 2
#define SIZEOF_SYSFILE_FILEID 2
#define SIZEOF_SYSFILE_PGSIZE 2
#define SIZEOF_SYSFILE_TYPE 6
#define SIZEOF_SYSFILE_SRC_LINE 2
#define SIZEOF_SYSINDEX_NAME 33
#define SIZEOF_SYSINDEX_DBID 2
#define SIZEOF_SYSINDEX_INDEXNO 2
#define SIZEOF_SYSINDEX_KEYID 4
#define SIZEOF_SYSINDEX_TYPE 1
#define SIZEOF_SYSINDEX_SRC_LINE 2
#define SIZEOF_SYSINDEXCOL_TYPE 1
#define SIZEOF_SYSINDEXCOL_SEQNO 2
#define SIZEOF_SYSTABLE_NAME 33
#define SIZEOF_SYSTABLE_DBID 2
#define SIZEOF_SYSTABLE_TABLEID 2
#define SIZEOF_SYSTABLE_TABNO 2
#define SIZEOF_SYSTABLE_RECID 2
#define SIZEOF_SYSTABLE_USERID 2
#define SIZEOF_SYSTABLE_COLID 2
#define SIZEOF_SYSTABLE_DEFN 4
#define SIZEOF_SYSTABLE_P_CODE 4
#define SIZEOF_SYSTABLE_COMMENT 4
#define SIZEOF_SYSTABLE_SRC_LINE 2
#define SIZEOF_SYSTABLE_PUBLIC_ACCESS 2
#define SIZEOF_SYSVIEW_NAME 33
#define SIZEOF_SYSVIEW_DBID 2
#define SIZEOF_SYSVIEW_VIEWID 2
#define SIZEOF_SYSVIEW_DISPOSITION 2
#define SIZEOF_SYSVIEW_TYPE 2
#define SIZEOF_SYSVIEW_P_CODE 4
#define SIZEOF_SYSVIEW_COMMENT 4
#define SIZEOF_SYSVIEW_PUBLIC_ACCESS 2
#define SIZEOF_SYSLOOKUP_TYPE 2
#define SIZEOF_SYSLOOKUP_QUAL_NAME 33
#define SIZEOF_SYSLOOKUP_NAME 33
#define SIZEOF_SYSLOOKUP_COMMENT 4
#define SIZEOF_SYSLOOKUP_TABCOLS 4
#define SIZEOF_SYSTABLEID_REFSCNT 2
#define SIZEOF_SYSCOLUMN_NAME 33
#define SIZEOF_SYSCOLUMN_DBID 2
#define SIZEOF_SYSCOLUMN_TABLEID 2
#define SIZEOF_SYSCOLUMN_TABLE_TYPE 1
#define SIZEOF_SYSCOLUMN_COLID 2
#define SIZEOF_SYSCOLUMN_COLNO 2
#define SIZEOF_SYSCOLUMN_FIELDID 4
#define SIZEOF_SYSCOLUMN_DATA_TYPE 2
#define SIZEOF_SYSCOLUMN_SIZE 6
#define SIZEOF_SYSCOLUMN_PREC 1
#define SIZEOF_SYSCOLUMN_SCALE 1
#define SIZEOF_SYSCOLUMN_COL_TYPE 2
#define SIZEOF_SYSCOLUMN_PKFIELD 4
#define SIZEOF_SYSCOLUMN_SETID 2
#define SIZEOF_SYSCOLUMN_COMMENT 4
#define SIZEOF_SYSCOLUMN_DEFLT_TYPE 2
#define SIZEOF_SYSCOLUMN_DEFLT_VAL 20
#define SIZEOF_SYSCOLUMN_DEFLT_BLOB 4
#define SIZEOF_SYSCOLUMN_HILO_BLOB 4
#define SIZEOF_SYSCOLUMN_SRC_LINE 2
#define SIZEOF_SYSCOLUMN_PUBLIC_ACCESS 2
#define SIZEOF_SYSCOLUMN_C_DATA_BLOB 4
#define SIZEOF_SYSPROC_NAME 33
#define SIZEOF_SYSPROC_PROCID 2
#define SIZEOF_SYSPROC_DISPOSITION 2
#define SIZEOF_SYSPROC_INPARGS 2
#define SIZEOF_SYSPROC_P_CODE 4
#define SIZEOF_SYSPROC_COMMENT 4
#define SIZEOF_SYSPROC_MODULE 33
#define SIZEOF_SYSPROC_DEVICE 10
#define SIZEOF_SYSJOIN_NAME 33
#define SIZEOF_SYSJOIN_ORDERING 7
#define SIZEOF_SYSJOIN_DBID 2
#define SIZEOF_SYSJOIN_JOINID 2
#define SIZEOF_SYSJOIN_SETID 2
#define SIZEOF_SYSJOIN_SRC_LINE 2
#define SIZEOF_SYSKEY_TYPE 1
#define SIZEOF_SYSKEY_UPDATES 2
#define SIZEOF_SYSKEY_REFCNT 2
#define SIZEOF_SYSKEY_NDX 4
#define SIZEOF_SYSKEY_COLS 32
#define SIZEOF_SYSFORKEY_COLS 32
#define SIZEOF_SYSFORKEY_NDX 4
#define SIZEOF_SYSFORKEY_TYPE 1
#define SIZEOF_SYSEDGE_SOURCEID 2
#define SIZEOF_SYSEDGE_DESTID 2
#define SIZEOF_SYSEDGE_ONE_OR_MANY 1
#define SIZEOF_SYSEDGE_ACCESS 1
#define SIZEOF_SYSJOINCOL_TYPE 1
#define SIZEOF_SYSFUNC_TYPE 1
#define SIZEOF_SYSFUNC_NAME 33
#define SIZEOF_SYSFUNC_MODULE 33
#define SIZEOF_SYSFUNC_DEVICE 10
#define SIZEOF_SYSFUNC_COMMENT 4
#define SIZEOF_SYSFILTER_NAME 33
#define SIZEOF_SYSFILTER_AUTO_COMMIT 2
#define SIZEOF_SYSFILTER_MODULE 33
#define SIZEOF_SYSFILTER_DEVICE 10
#define SIZEOF_SYSFILTER_COMMENT 4
#define SIZEOF_SYSUSER_NAME 15
#define SIZEOF_SYSUSER_LOGIN_PROC 33
#define SIZEOF_SYSUSER_LOGOUT_PROC 33
#define SIZEOF_SYSUSER_USERID 2
#define SIZEOF_SYSUSER_COMMAND_ACCESS 2
#define SIZEOF_SYSRIGHT_USERID 2
#define SIZEOF_SYSRIGHT_TYPE 2
#define SIZEOF_SYSRIGHT_ACCESS 2
#define SIZEOF_SYSRIGHT_ENTITY 4
#define SIZEOF_SYSERROR_ERRCODE 2
#define SIZEOF_SYSERROR_ERRTYPE 2
#define SIZEOF_SYSERROR_ERRINFO 2
#define SIZEOF_SYSERROR_ERRID 22
#define SIZEOF_SYSERROR_SQLSTATE 6
#define SIZEOF_SYSERROR_SUMMARY 49
#define SIZEOF_SYSERRLINE_TXTLN 84
#define SIZEOF_SYSCOMMENT_TXTLN 133
#define SIZEOF_SYSOBJECT_HEAD 4
#define SIZEOF_SYSOBJECT_SIZE 4
#define SIZEOF_SYSOBJ62_NXTB 4
#define SIZEOF_SYSOBJ62_BYTES 62
#define SIZEOF_SYSOBJ134_NXTB 4
#define SIZEOF_SYSOBJ134_BYTES 134
#define SIZEOF_SYSOBJ330_NXTB 4
#define SIZEOF_SYSOBJ330_BYTES 330
#define SIZEOF_SYSOBJ500_NXTB 4
#define SIZEOF_SYSOBJ500_BYTES 500
#define SIZEOF_SYSOBJ1010_NXTB 4
#define SIZEOF_SYSOBJ1010_BYTES 1010
#define SIZEOF_SYSTYPES_DATA_TYPE 2
#define SIZEOF_SYSTYPES_TYPE_NAME 33
#define SIZEOF_SYSTYPES_LITERAL_PREFIX 17
#define SIZEOF_SYSTYPES_PREC 4
#define SIZEOF_SYSTYPES_CREATE_PARAMS 33
#define SIZEOF_SYSSECLOG_ISSUED_DATE 4
#define SIZEOF_SYSSECLOG_ISSUED_TIME 4
#define SIZEOF_SYSTEXT_TXTLN 133

#endif    /* SYSCAT_H */
