#ifndef SRVBCD_H
#define SRVBCD_H

/**********************************************************************/
/*
    srvbcd.h  -      RSQL system binary-coded-decimal function header.
       
    This header is for use with the sql version of the bcd library,
    this is a stripped down version of the client bcd library.  Don't 
    blame me for not having the two versions in the same source file.

    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
*/
/**********************************************************************/

#define BCD_LESS        0
#define BCD_LESSEQ      1
#define BCD_EQ          2
#define BCD_GREATER     3
#define BCD_GREATEREQ   4

#define SRV_BCDBYTES    16     /* Max allowed storage space in database.      */
#define SRV_BCDDISPLEN  33     /* 31 digits, sign and decimal place           */  
#define SRV_BCDDLEN     66     /* Normalized digits left and right of '.' + 4 */

short REXTERNAL BCDAdd(DECIMAL *v1, DECIMAL *v2, DECIMAL *r);

short REXTERNAL BCDSub(DECIMAL *v1, DECIMAL *v2, DECIMAL *r);

short REXTERNAL BCDMult(DECIMAL *v1, DECIMAL *v2, DECIMAL *r);

short REXTERNAL BCDDiv(DECIMAL *v1, DECIMAL *v2, DECIMAL *r);

short REXTERNAL BCDCmp(DECIMAL *v1, short op, DECIMAL *v2);

short REXTERNAL BCDEqZero(DECIMAL *r);

short REXTERNAL BCDtoChar(DECIMAL *v, char *r, short len, short prec, short scale);

short REXTERNAL BCDtoShort(DECIMAL *v, short *r, short prec, short scale);

short REXTERNAL BCDtoLong(DECIMAL *v, long *r, short prec, short scale);

short REXTERNAL BCDtoFloat(DECIMAL *v, float *r, short prec, short scale);

short REXTERNAL BCDtoDouble(DECIMAL *v, double *r, short prec, short scale);

short REXTERNAL ChartoBCD(char *v, DECIMAL *r);

short REXTERNAL ShorttoBCD(short v, DECIMAL *r);

short REXTERNAL LongtoBCD(long v, DECIMAL *r);

short REXTERNAL FloattoBCD(float v, DECIMAL *r);

short REXTERNAL DoubletoBCD(double v, DECIMAL *r);

short REXTERNAL BCDChgSign(DECIMAL *r);

short REXTERNAL BCDSign(DECIMAL *v);

short REXTERNAL BCDOverFlow(DECIMAL *v);

short REXTERNAL BCDPrecLoss(DECIMAL *v);

void  REXTERNAL BCDNormalize(DECIMAL *r, short prec);

short REXTERNAL BCDUnNormalize(DECIMAL *r, short prec, short scale);

#endif
/**********************************************************************/
/*
$Header:   P:/PAT/INCLUDE/VCS/SRVBCD.H_V   1.1   18 Apr 1994 12:12:12   RICHM  $
*/
/**********************************************************************/

