/*===========================================================================
    sqlxdefs.h - ODBC level 1 and 2 constant and type definitions.

    Used on both client and server side.

    Raima Corporation version.
    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
===========================================================================*/
#ifndef SQLXDEFS_H
#define SQLXDEFS_H
#include "sqldefs.h"

#ifdef __cplusplus
extern "C" {
#endif

#define SQL_DATE             9
#define SQL_TIME            10
#define SQL_TIMESTAMP       11

#define SQL_LONGVARCHAR     (-1)
#define SQL_BINARY          (-2)
#define SQL_VARBINARY       (-3)
#define SQL_LONGVARBINARY   (-4)
#define SQL_BIGINT          (-5)
#define SQL_TINYINT         (-6)
#define SQL_BIT             (-7)

/* sqlxdefs.h redefines from that in sqldefs.h for ODBC extended types */
#undef  SQL_TYPE_MIN
#define SQL_TYPE_MIN        (-7)

#define SQL_ALL_TYPES       0

#define SQL_MODE_READ_WRITE     0
#define SQL_MODE_READ_ONLY      1

/* SQLDriverConnect options */
#define SQL_DRIVER_NOPROMPT             0
#define SQL_DRIVER_COMPLETE             1
#define SQL_DRIVER_PROMPT               2
#define SQL_DRIVER_COMPLETE_REQUIRED    3

/* C data type to SQL data type mapping */
#define SQL_C_DATE          SQL_DATE
#define SQL_C_TIME          SQL_TIME
#define SQL_C_TIMESTAMP     SQL_TIMESTAMP
#define SQL_C_BINARY        SQL_BINARY
#define SQL_C_BIT           SQL_BIT
#define SQL_C_TINYINT       SQL_TINYINT

/* ODBC date, time struct defns + timezone */
typedef struct tagDATE_STRUCT {
    short year;
    short month;
    short day;
} DATE_STRUCT;

typedef struct  tagTIME_STRUCT {
    short hour;
    short minute;
    short second;
} TIME_STRUCT;

typedef struct tagTIMESTAMP_STRUCT {
    short year;
    short month;
    short day;
    short hour;
    short minute;
    short second;
    long  fraction;
} TIMESTAMP_STRUCT;

/* Defines for SQLGetFunctions */

/* Core Functions           */
#define SQL_API_SQLALLOCCONNECT         1
#define SQL_API_SQLALLOCENV             2
#define SQL_API_SQLALLOCSTMT            3
#define SQL_API_SQLBINDCOL              4
#define SQL_API_SQLCANCEL               5
#define SQL_API_SQLCOLATTRIBUTES        6
#define SQL_API_SQLCONNECT              7
#define SQL_API_SQLDESCRIBECOL          8
#define SQL_API_SQLDISCONNECT           9
#define SQL_API_SQLERROR                10
#define SQL_API_SQLEXECDIRECT           11
#define SQL_API_SQLEXECUTE              12
#define SQL_API_SQLFETCH                13
#define SQL_API_SQLFREECONNECT          14
#define SQL_API_SQLFREEENV              15
#define SQL_API_SQLFREESTMT             16
#define SQL_API_SQLGETCURSORNAME        17
#define SQL_API_SQLNUMRESULTCOLS        18
#define SQL_API_SQLPREPARE              19
#define SQL_API_SQLROWCOUNT             20
#define SQL_API_SQLSETCURSORNAME        21
#define SQL_API_SQLSETPARAM             22
#define SQL_API_SQLTRANSACT             23

#define SQL_NUM_FUNCTIONS               23
#define SQL_EXT_API_START               40

/* Level 1 Functions        */
#define SQL_API_SQLCOLUMNS              40
#define SQL_API_SQLDRIVERCONNECT        41
#define SQL_API_SQLGETCONNECTOPTION     42
#define SQL_API_SQLGETDATA              43
#define SQL_API_SQLGETFUNCTIONS         44
#define SQL_API_SQLGETINFO              45
#define SQL_API_SQLGETSTMTOPTION        46
#define SQL_API_SQLGETTYPEINFO          47
#define SQL_API_SQLPARAMDATA            48
#define SQL_API_SQLPUTDATA              49
#define SQL_API_SQLSETCONNECTOPTION     50
#define SQL_API_SQLSETSTMTOPTION        51
#define SQL_API_SQLSPECIALCOLUMNS       52
#define SQL_API_SQLSTATISTICS           53
#define SQL_API_SQLTABLES               54

/* Level 2 Functions        */
#define SQL_API_SQLBROWSECONNECT        55
#define SQL_API_SQLCOLUMNPRIVILEGES     56
#define SQL_API_SQLDATASOURCES          57
#define SQL_API_SQLDESCRIBEPARAM        58
#define SQL_API_SQLEXTENDEDFETCH        59
#define SQL_API_SQLFOREIGNKEYS          60
#define SQL_API_SQLMORERESULTS          61
#define SQL_API_SQLNATIVESQL            62
#define SQL_API_SQLNUMPARAMS            63
#define SQL_API_SQLPARAMOPTIONS         64
#define SQL_API_SQLPRIMARYKEYS          65
#define SQL_API_SQLPROCEDURECOLUMNS     66
#define SQL_API_SQLPROCEDURES           67
#define SQL_API_SQLSETPOS               68
#define SQL_API_SQLSETSCROLLOPTIONS     69
#define SQL_API_SQLTABLEPRIVILEGES      70

#define SQL_EXT_API_LAST                70
#define SQL_NUM_EXTENSIONS (SQL_EXT_API_LAST-SQL_EXT_API_START+1)

/* Defines for SQLGetInfo */
#define SQL_INFO_FIRST                   0

#define SQL_ACTIVE_CONNECTIONS           0
#define SQL_ACTIVE_STATEMENTS            1
#define SQL_DATA_SOURCE_NAME             2
#define SQL_DRIVER_HDBC                  3
#define SQL_DRIVER_HENV                  4
#define SQL_DRIVER_HSTMT                 5
#define SQL_DRIVER_NAME                  6
#define SQL_DRIVER_VER                   7
#define SQL_FETCH_DIRECTION              8
#define SQL_ODBC_API_CONFORMANCE         9
#define SQL_ODBC_VER                    10
#define SQL_ROW_UPDATES                 11
#define SQL_ODBC_SAG_CLI_CONFORMANCE    12
#define SQL_SERVER_NAME                 13
#define SQL_SEARCH_PATTERN_ESCAPE       14
#define SQL_ODBC_SQL_CONFORMANCE        15

#define SQL_DATABASE_NAME               16
#define SQL_DBMS_NAME                   17
#define SQL_DBMS_VER                    18

#define SQL_ACCESSIBLE_TABLES           19
#define SQL_ACCESSIBLE_PROCEDURES       20
#define SQL_PROCEDURES                  21
#define SQL_CONCAT_NULL_BEHAVIOR        22
#define SQL_CURSOR_COMMIT_BEHAVIOR      23
#define SQL_CURSOR_ROLLBACK_BEHAVIOR    24
#define SQL_DATA_SOURCE_READ_ONLY       25
#define SQL_DEFAULT_TXN_ISOLATION       26
#define SQL_EXPRESSIONS_IN_ORDERBY      27
#define SQL_IDENTIFIER_CASE             28
#define SQL_IDENTIFIER_QUOTE_CHAR       29
#define SQL_MAX_COLUMN_NAME_LEN         30
#define SQL_MAX_CURSOR_NAME_LEN         31
#define SQL_MAX_OWNER_NAME_LEN          32
#define SQL_MAX_PROCEDURE_NAME_LEN      33
#define SQL_MAX_QUALIFIER_NAME_LEN      34
#define SQL_MAX_TABLE_NAME_LEN          35
#define SQL_MULT_RESULT_SETS            36
#define SQL_MULTIPLE_ACTIVE_TXN         37
#define SQL_OUTER_JOINS                 38
#define SQL_OWNER_TERM                  39
#define SQL_PROCEDURE_TERM              40
#define SQL_QUALIFIER_NAME_SEPARATOR    41
#define SQL_QUALIFIER_TERM              42
#define SQL_SCROLL_CONCURRENCY          43
#define SQL_SCROLL_OPTIONS              44
#define SQL_TABLE_TERM                  45
#define SQL_TXN_CAPABLE                 46
#define SQL_USER_NAME                   47

#define SQL_CONVERT_FUNCTIONS           48
#define SQL_NUMERIC_FUNCTIONS           49
#define SQL_STRING_FUNCTIONS            50
#define SQL_SYSTEM_FUNCTIONS            51
#define SQL_TIMEDATE_FUNCTIONS          52

#define SQL_CONVERT_BIGINT              53
#define SQL_CONVERT_BINARY              54
#define SQL_CONVERT_BIT                 55
#define SQL_CONVERT_CHAR                56
#define SQL_CONVERT_DATE                57
#define SQL_CONVERT_DECIMAL             58
#define SQL_CONVERT_DOUBLE              59
#define SQL_CONVERT_FLOAT               60
#define SQL_CONVERT_INTEGER             61
#define SQL_CONVERT_LONGVARCHAR         62
#define SQL_CONVERT_NUMERIC             63
#define SQL_CONVERT_REAL                64
#define SQL_CONVERT_SMALLINT            65
#define SQL_CONVERT_TIME                66
#define SQL_CONVERT_TIMESTAMP           67
#define SQL_CONVERT_TINYINT             68
#define SQL_CONVERT_VARBINARY           69
#define SQL_CONVERT_VARCHAR             70
#define SQL_CONVERT_LONGVARBINARY       71

#define SQL_TXN_ISOLATION_OPTION        72
#define SQL_ODBC_SQL_OPT_IEF            73

#define SQL_INFO_LAST                   73
#define SQL_INFO_DRIVER_START           1000
#define SQL_CORRELATION_NAME            65000
#define SQL_NON_NULLABLE_COLUMNS        65001

/* "SQL_CONVERT_" return values */
#define SQL_CVT_CHAR                0x00000001L
#define SQL_CVT_NUMERIC             0x00000002L
#define SQL_CVT_DECIMAL             0x00000004L
#define SQL_CVT_INTEGER             0x00000008L
#define SQL_CVT_SMALLINT            0x00000010L
#define SQL_CVT_FLOAT               0x00000020L
#define SQL_CVT_REAL                0x00000040L
#define SQL_CVT_DOUBLE              0x00000080L
#define SQL_CVT_VARCHAR             0x00000100L
#define SQL_CVT_LONGVARCHAR         0x00000200L
#define SQL_CVT_BINARY              0x00000400L
#define SQL_CVT_VARBINARY           0x00000800L
#define SQL_CVT_BIT                 0x00001000L
#define SQL_CVT_TINYINT             0x00002000L
#define SQL_CVT_BIGINT              0x00004000L
#define SQL_CVT_DATE                0x00008000L
#define SQL_CVT_TIME                0x00010000L
#define SQL_CVT_TIMESTAMP           0x00020000L
#define SQL_CVT_LONGVARBINARY       0x00040000L

/* Conversion functions */
#define SQL_FN_CVT_CONVERT          0x00000001L

/* String functions */
#define SQL_FN_STR_CONCAT           0x00000001L
#define SQL_FN_STR_INSERT           0x00000002L
#define SQL_FN_STR_LEFT             0x00000004L
#define SQL_FN_STR_LTRIM            0x00000008L
#define SQL_FN_STR_LENGTH           0x00000010L
#define SQL_FN_STR_LOCATE           0x00000020L
#define SQL_FN_STR_LCASE            0x00000040L
#define SQL_FN_STR_REPEAT           0x00000080L
#define SQL_FN_STR_REPLACE          0x00000100L
#define SQL_FN_STR_RIGHT            0x00000200L
#define SQL_FN_STR_RTRIM            0x00000400L
#define SQL_FN_STR_SUBSTRING        0x00000800L
#define SQL_FN_STR_UCASE            0x00001000L
#define SQL_FN_STR_ASCII            0x00002000L
#define SQL_FN_STR_CHAR             0x00004000L

/* Numeric functions */
#define SQL_FN_NUM_ABS              0x00000001L
#define SQL_FN_NUM_ACOS             0x00000002L
#define SQL_FN_NUM_ASIN             0x00000004L
#define SQL_FN_NUM_ATAN             0x00000008L
#define SQL_FN_NUM_ATAN2            0x00000010L
#define SQL_FN_NUM_CEILING          0x00000020L
#define SQL_FN_NUM_COS              0x00000040L
#define SQL_FN_NUM_COT              0x00000080L
#define SQL_FN_NUM_EXP              0x00000100L
#define SQL_FN_NUM_FLOOR            0x00000200L
#define SQL_FN_NUM_LOG              0x00000400L
#define SQL_FN_NUM_MOD              0x00000800L
#define SQL_FN_NUM_SIGN             0x00001000L
#define SQL_FN_NUM_SIN              0x00002000L
#define SQL_FN_NUM_SQRT             0x00004000L
#define SQL_FN_NUM_TAN              0x00008000L
#define SQL_FN_NUM_PI               0x00010000L
#define SQL_FN_NUM_RAND             0x00020000L

/* Time/date functions */
#define SQL_FN_TD_NOW               0x00000001L
#define SQL_FN_TD_CURDATE           0x00000002L
#define SQL_FN_TD_DAYOFMONTH        0x00000004L
#define SQL_FN_TD_DAYOFWEEK         0x00000008L
#define SQL_FN_TD_DAYOFYEAR         0x00000010L
#define SQL_FN_TD_MONTH             0x00000020L
#define SQL_FN_TD_QUARTER           0x00000040L
#define SQL_FN_TD_WEEK              0x00000080L
#define SQL_FN_TD_YEAR              0x00000100L
#define SQL_FN_TD_CURTIME           0x00000200L
#define SQL_FN_TD_HOUR              0x00000400L
#define SQL_FN_TD_MINUTE            0x00000800L
#define SQL_FN_TD_SECOND            0x00001000L

/* System functions */
#define SQL_FN_SYS_USERNAME         0x00000001L
#define SQL_FN_SYS_DBNAME           0x00000002L
#define SQL_FN_SYS_IFNULL           0x00000004L

/* ODBC SQL Conformance values */
#define SQL_OSC_MINIMUN             0x0000
#define SQL_OSC_CORE                0x0001
#define SQL_OSC_EXTENDED            0x0002

/* Scroll options */
#define SQL_SO_FORWARD_ONLY         0x00000001L
#define SQL_SO_KEYSET_DRIVEN        0x00000002L
#define SQL_SO_DYNAMIC              0x00000004L
#define SQL_SO_MIXED                0x00000008L

/* Scroll concurrency options */
#define SQL_SCCO_READ_ONLY          0x00000001L
#define SQL_SCCO_LOCK               0x00000002L
#define SQL_SCCO_OPT_TIMESTAMP      0x00000004L
#define SQL_SCCO_OPT_VALUES         0x00000008L

/* Fetch direction options */
#define SQL_FD_FETCH_NEXT           0x00000001L
#define SQL_FD_FETCH_FIRST          0x00000002L
#define SQL_FD_FETCH_LAST           0x00000004L
#define SQL_FD_FETCH_PREV           0x00000008L
#define SQL_FD_FETCH_ABSOLUTE       0x00000010L
#define SQL_FD_FETCH_RELATIVE       0x00000020L
#define SQL_FD_FETCH_RESUME         0x00000040L

/* Transaction isolation options */
#define SQL_TXN_READ_UNCOMMITTED        0x00000001L
#define SQL_TXN_READ_COMMITTED          0x00000002L
#define SQL_TXN_REPEATABLE_READ         0x00000004L
#define SQL_TXN_SERIALIZABLE            0x00000008L
#define SQL_TXN_VERSIONING              0x00000010L
#define SQL_TXN_REPEATABLE_UNCOMMITTED  0x00000020L

/* Correlation name option values */
#define SQL_CN_NONE        0x0000
#define SQL_CN_DIFFERENT   0x0001
#define SQL_CN_ANY         0x0002

/* Non Nullable Column option values */
#define SQL_NNC_NULL       0x0000
#define SQL_NNC_NON_NULL   0x0001

/* options for SQLSetStmtOption() */
#define SQL_QUERY_TIMEOUT           0
#define SQL_MAX_ROWS                1
#define SQL_NOSCAN                  2
#define SQL_MAX_LENGTH              3
#define SQL_ASYNC_ENABLE            4
#define SQL_BIND_TYPE               5
#define SQL_CALENDAR                6

/* Suboption for SQL_BIND_TYPE */
#define SQL_BIND_BY_COLUMN          0

/* options for SQLSetConnectOption/SQLGetConnectOption */
#define SQL_ACCESS_MODE             101
#define SQL_AUTOCOMMIT              102
#define SQL_LOGIN_TIMEOUT           103
#define SQL_OPT_TRACE               104
#define SQL_OPT_TRACEFILE           105
#define SQL_TRANSLATE_DLL           106
#define SQL_TRANSLATE_OPTION        107
#define SQL_TXN_ISOLATION           108
#define SQL_CONNECT_OPT_DRVR_START  1000
#define SQL_OPT_VENDOR              1001
#define SQL_OPT_VALCONVERSION       1002
#define SQL_CURRENT_QUALIFIER       65000

#define SQL_AUTOCOMMIT_OFF          0L
#define SQL_AUTOCOMMIT_ON           1L

/*  Column types and scopes in SQLSpecialColumns.  */
#define SQL_BEST_ROWID              1
#define SQL_ROWVER                  2

#define SQL_SCOPE_CURROW            0
#define SQL_SCOPE_TRANSACTION       1
#define SQL_SCOPE_SESSION           2

/* SQLStatistics() defines */
#define SQL_INDEX_UNIQUE            0
#define SQL_INDEX_ALL               1
#define SQL_ENSURE                  1
#define SQL_QUICK                   0

#ifdef __cplusplus
}
#endif

/*
$Header:   P:/PAT/INCLUDE/VCS/SQLXDEFS.H_V   1.19   18 Apr 1994 12:12:10   RICHM  $
*/
#endif
