/*-------------------------------------------------------------------------
    sqlscalr.h  -  SQL scalar function type definition table
                   (Common to both server & sddlp)

    Copyright (c) 1993-1994 Raima Corporation.  All Rights Reserved.
-------------------------------------------------------------------------*/
#ifndef SQL_SCALAR_H
#define SQL_SCALAR_H

/* atypes are encoded as follows:

    SQL_NUMERIC   => any numeric type
    SQL_FLOAT     => SQL_REAL or SQL_DOUBLE
    SQL_CHAR      => SQL_CHAR or SQL_VARCHAR
    SQL_INTEGER   => SQL_SMALLINT or SQL_INTEGER
    SQL_DATE      => SQL_DATE or SQL_TIMESTAMP
    SQL_TIME      => SQL_TIME or SQL_TIMESTAMP
*/
SCALAR_FCNS ScalarFcnTypes[] = {
/*  function   noargs  rtype       rlen  atypes[] */
    {"ABS",         1, 0,             0, {SQL_NUMERIC}},
    {"ACOS",        1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"ASCII",       1, SQL_SMALLINT,  0, {SQL_CHAR}},
    {"ASIN",        1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"ATAN",        1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"ATAN2",       2, SQL_DOUBLE,    0, {SQL_FLOAT, SQL_FLOAT}},
    {"CEILING",     1, SQL_INTEGER,   0, {SQL_NUMERIC}},
    {"CHAR",        1, SQL_CHAR,      2, {SQL_INTEGER}},
    {"CONCAT",      2, SQL_CHAR,     -2, {SQL_CHAR, SQL_CHAR}},
    {"CONVERT",    -1},  /* unused - convert implemented as op code */
    {"COS",         1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"COT",         1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"CURDATE",     0, SQL_DATE,      0},
    {"CURTIME",     0, SQL_TIME,      0},
    {"DAYOFMONTH",  1, SQL_SMALLINT,  0, {SQL_DATE}},
    {"DAYOFWEEK",   1, SQL_SMALLINT,  0, {SQL_DATE}},
    {"DAYOFYEAR",   1, SQL_SMALLINT,  0, {SQL_DATE}},
    {"EXP",         1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"FLOOR",       1, SQL_INTEGER,   0, {SQL_NUMERIC}},
    {"HOUR",        1, SQL_SMALLINT,  0, {SQL_TIME}},
    {"IFNULL",      2, SQL_NOVAL},   /* the rules are too complex - needs special case */
    {"INSERT",      4, SQL_CHAR,     -2, {SQL_CHAR, SQL_INTEGER, SQL_INTEGER, SQL_CHAR}},
    {"LCASE",       1, SQL_CHAR,     -1, {SQL_CHAR}},
    {"LEFT",        2, SQL_CHAR,     -1, {SQL_CHAR, SQL_INTEGER}},
    {"LENGTH",      1, SQL_INTEGER,   0, {SQL_CHAR}},
    {"LOCATE",      3, SQL_INTEGER,   0, {SQL_CHAR, SQL_CHAR, SQL_INTEGER}},
    {"LOG",         1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"LTRIM",       1, SQL_CHAR,     -1, {SQL_CHAR}},
    {"MINUTE",      1, SQL_SMALLINT,  0, {SQL_TIME}},
    {"MOD",         2, SQL_INTEGER,   0, {SQL_INTEGER, SQL_INTEGER}},
    {"MONTH",       1, SQL_SMALLINT,  0, {SQL_DATE}},
    {"NOW",         0, SQL_TIMESTAMP, 0},
    {"PI",          0, SQL_DOUBLE,    0},
    {"QUARTER",     1, SQL_SMALLINT,  0, {SQL_DATE}},
    {"RAND",        1, SQL_DOUBLE,    0, {SQL_INTEGER}},
    {"REPEAT",      2, SQL_CHAR,     -3, {SQL_CHAR, SQL_INTEGER}},
    {"REPLACE",     3, SQL_CHAR,     -2, {SQL_CHAR, SQL_CHAR, SQL_CHAR}},
    {"RIGHT",       2, SQL_CHAR,     -1, {SQL_CHAR, SQL_INTEGER}},
    {"RTRIM",       1, SQL_CHAR,     -1, {SQL_CHAR}},
    {"SECOND",      1, SQL_SMALLINT,  0, {SQL_TIME}},
    {"SIGN",        1, SQL_SMALLINT,  0, {SQL_NUMERIC}},
    {"SIN",         1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"SQRT",        1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"SUBSTRING",   3, SQL_CHAR,     -1, {SQL_CHAR, SQL_INTEGER, SQL_INTEGER}},
    {"TAN",         1, SQL_DOUBLE,    0, {SQL_FLOAT}},
    {"UCASE",       1, SQL_CHAR,     -1, {SQL_CHAR}},
    {"WEEK",        1, SQL_SMALLINT,  0, {SQL_DATE}},
    {"YEAR",        1, SQL_SMALLINT,  0, {SQL_DATE}},
    {"DATABASE",    0, SQL_CHAR,      256},
    {"USER",        0, SQL_CHAR,      NAMELEN},
    {"AGE",         1, SQL_INTEGER,   0, {SQL_DATE}}
};
#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/SQLSCALR.H_V   1.2   18 Apr 1994 12:12:06   RICHM  $
*/
