/*===========================================================================
    sqlrds.h - RDS SQL extensions header.

    Raima Corporation version.
    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
===========================================================================*/
#ifndef SQLRDS_H
#define SQLRDS_H
#include "sqlext.h"
#include "sqlrdefs.h"
#include "rmcomp.h"
#include "caldefs.h"

#ifdef __cplusplus
extern "C" {
#endif

/* user call-back error function */
typedef long (REXTERNAL * ECALLBACK) (void RFAR *, void RFAR *,
                                       void RFAR *, long);

/* ======================================================================
    Raima SQL Extensions Prototypes
*/
RETCODE REXTERNAL SQLConnectWith(
    HDBC                hdbc,
    RDM_SESS            sess_id
);

/* ======================================================================
    Return description of c_data table column
*/
RETCODE REXTERNAL SQLCDataColumn(
    HSTMT               hstmt,
    UCHAR RFAR         *tabQual,
    SWORD               tabQualLen,
    UCHAR RFAR         *tabName,
    SWORD               tabNameLen,
    UCHAR RFAR         *colName,
    SWORD               colNameLen
);

/* ======================================================================
    Return description of c_data result column
*/
RETCODE REXTERNAL SQLDescribeCData(
    HSTMT         hstmt,
    UWORD         col,
    UWORD         fld,
    UCHAR RFAR   *fldname,
    SWORD         buflen,
    SWORD RFAR   *outlen,
    SWORD RFAR   *type,
    SWORD RFAR   *unsgd,
    SWORD RFAR   *noflds,
    SWORD RFAR   *dims)
;

RETCODE REXTERNAL SQLDescribeStmt(
    HSTMT               hstmt,
    UWORD RFAR         *type
);

RETCODE REXTERNAL SQLExtendedTransact(
    HENV                henv,
    HDBC                hdbc,
    UWORD               option,
    UCHAR RFAR         *markid,
    SWORD               mlen
);

RETCODE REXTERNAL SQLSessionId(
    HDBC                hdbc,
    RDM_SESS RFAR      *sess_id
);

RETCODE REXTERNAL SQLDBHandle(
    HDBC                hdbc,
    UCHAR RFAR         *dbname,
    RDM_DB RFAR        *phDb
);

RETCODE REXTERNAL SQLDbaToRowId(
    HSTMT               hstmt,
    UCHAR RFAR         *tblname,
    DB_ADDR             dba,
    UDWORD RFAR        *rowid
);

RETCODE REXTERNAL SQLRowIdToDba(
    HSTMT               hstmt,
    UCHAR RFAR         *tblname,
    UDWORD              rowid,
    DB_ADDR RFAR       *dba
);

RETCODE REXTERNAL SQLRowDba(
    HSTMT               hstmt,
    UCHAR RFAR         *tblname,
    DB_ADDR RFAR       *dba
);

RETCODE REXTERNAL SQLRowId(
    HSTMT               hstmt,
    UCHAR RFAR         *tblname,
    UDWORD RFAR        *rowid
);

RETCODE REXTERNAL SQLWhenever(
    HDBC                hdbc,
    HSTMT               hstmt,
    SWORD               code,
    ECALLBACK           fcn
);

RETCODE REXTERNAL SQLTransactStatus(
    HDBC                hdbc,
    SWORD RFAR         *pStatus
);

RETCODE REXTERNAL SQLAllocCData(
    HDBC                hdbc,
    UCHAR RFAR         *tabQual,
    SWORD               tabQualLen,
    UCHAR RFAR         *tabName,
    SWORD               tabNameLen,
    UCHAR RFAR         *colName,
    SWORD               colNameLen,
    HCDATA RFAR        *phCData
);

RETCODE REXTERNAL SQLFreeCData(
    HCDATA              hCData
);

RETCODE REXTERNAL SQLSetCData(
    HCDATA              hCData,
    void RFAR          *vp
);

RETCODE REXTERNAL VALUnpackDate(
    DATE_VAL RFAR      *dvp,
    DATE_STRUCT RFAR   *dsp
);

RETCODE REXTERNAL VALUnpackTime(
    TIME_VAL RFAR      *tvp,
    TIME_STRUCT RFAR   *tsp
);

RETCODE REXTERNAL VALUnpackTimestamp(
    TIMESTAMP_VAL RFAR    *tsvp,
    TIMESTAMP_STRUCT RFAR *tssp
);

RETCODE REXTERNAL VALPackDate(
    DATE_STRUCT RFAR   *dsp,
    DATE_VAL RFAR      *dvp
);

RETCODE REXTERNAL VALPackTime(
    TIME_STRUCT RFAR   *tsp,
    TIME_VAL RFAR      *tvp
);

RETCODE REXTERNAL VALPackTimestamp(
    TIMESTAMP_STRUCT RFAR *tssp,
    TIMESTAMP_VAL RFAR    *tsvp
);

RETCODE REXTERNAL BCDAllocEnv(
    unsigned char       max_precision,
    unsigned char       max_scale,
    BCD_HENV RFAR      *hBCDp
);


RETCODE REXTERNAL BCDFreeEnv(
    BCD_HENV            hBCD
);

RETCODE REXTERNAL BCDUnpack(
    BCD_HENV            hBCD,
    BCD_VAL RFAR       *bv,
    char RFAR          *cp,
    size_t              len
);

RETCODE REXTERNAL BCDPack(
    BCD_HENV            hBCD,
    char RFAR          *cp,
    unsigned char       precision,
    unsigned char       scale,
    BCD_VAL RFAR       *rv, 
    size_t              len
);

RETCODE REXTERNAL BCDAdd(
    BCD_HENV            hBCD,
    char RFAR          *lv,
    char RFAR          *rv, 
    char RFAR          *result,
    size_t              rlen
);

RETCODE REXTERNAL BCDSubtract(
    BCD_HENV            hBCD,
    char RFAR          *lv,
    char RFAR          *rv, 
    char RFAR          *result,
    size_t              rlen
);

RETCODE REXTERNAL BCDMultiply(
    BCD_HENV            hBCD,
    char RFAR          *lv,
    char RFAR          *rv, 
    char RFAR          *result,
    size_t              rlen
);

RETCODE REXTERNAL BCDDivide(
    BCD_HENV            hBCD,
    char RFAR          *lv,
    char RFAR          *rv, 
    char RFAR          *result,
    size_t              rlen
);

RETCODE REXTERNAL BCDCompare(
    BCD_HENV            hBCD,
    char RFAR          *lv,
    char RFAR          *rv,
    short RFAR         *cmp
);

RETCODE REXTERNAL BCDStatus(
    BCD_HENV            hBCD,
    BCD_VAL RFAR       *bcd
);


#ifdef __cplusplus
}
#endif

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/SQLRDS.H_V   1.20   02 Jun 1994 13:55:50   RANDY  $
*/
