/*===========================================================================
    sqlext.h - extensions header for ODBC level 1 & 2 compliant applications.

    Raima Corporation version.
    Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
===========================================================================*/
#ifndef SQLEXT_H
#define SQLEXT_H
#include "sql.h"
#include "sqlxdefs.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================
    Raima SQL ODBC Level 1 Function Prototypes
*/
RETCODE REXTERNAL SQLColumns(
    HSTMT               hstmt,
    UCHAR  RFAR        *tabQual,
    SWORD               tabQualLen,
    UCHAR  RFAR        *tabOwner,
    SWORD               tabOwnerLen,
    UCHAR  RFAR        *tabName,
    SWORD               tabNameLen,
    UCHAR  RFAR        *colName,
    SWORD               colNameLen
);

#ifndef WINDOWS
#ifndef OS2DEF_INCLUDED
#ifndef WIN32_NT
typedef long HWND;
#endif
#endif
#endif

RETCODE REXTERNAL SQLDriverConnect(
    HDBC                hdbc,
    HWND                hwnd,
    UCHAR  RFAR        *strIn,
    SWORD               strInLen,
    UCHAR  RFAR        *strOut,
    SWORD               strOutMax,
    SWORD  RFAR        *actualOutLen,
    UWORD               driverOption
);

RETCODE REXTERNAL SQLGetConnectOption(
    HDBC                hdbc,
    UWORD               option,
    PTR                 data
);

RETCODE REXTERNAL SQLGetData(
    HSTMT               hstmt,
    UWORD               colNum,
    SWORD               cnvType,
    PTR                 outBuff,
    SDWORD              outBuffLen,
    SDWORD RFAR        *actualOutLen
);

RETCODE REXTERNAL SQLGetFunctions(
    HDBC                hdbc,
    UWORD               function,
    UWORD  RFAR        *exists
);

RETCODE REXTERNAL SQLGetInfo(
    HDBC                hdbc,
    UWORD               infoType,
    PTR                 outBuff,
    SWORD               outBuffLen,
    SWORD  RFAR        *actualOutLen
);

RETCODE REXTERNAL SQLGetStmtOption(
    HSTMT               hstmt,
    UWORD               option,
    PTR                 data
);

RETCODE REXTERNAL SQLGetTypeInfo(
    HSTMT               hstmt,
    SWORD               sqlType
);

RETCODE REXTERNAL SQLParamData(
    HSTMT               hstmt,
    PTR    RFAR        *outBuff
);

RETCODE REXTERNAL SQLPutData(
    HSTMT               hstmt,
    PTR                 inBuff,
    SDWORD              inBuffLen
);

RETCODE REXTERNAL SQLSetConnectOption(
    HDBC                hdbc,
    UWORD               option,
    UDWORD              toValue
);

RETCODE REXTERNAL SQLSetStmtOption(
    HSTMT               hstmt,
    UWORD               option,
    UDWORD              toValue
);

RETCODE REXTERNAL SQLSpecialColumns(
    HSTMT               hstmt,
    UWORD               colType,
    UCHAR  RFAR        *tabQual,
    SWORD               tabQualLen,
    UCHAR  RFAR        *tabOwner,
    SWORD               tabOwnerLen,
    UCHAR  RFAR        *tabName,
    SWORD               tabNameLen,
    UWORD               scope,
    UWORD               nullable
);

RETCODE REXTERNAL SQLStatistics(
    HSTMT               hstmt,
    UCHAR  RFAR        *tabQual,
    SWORD               tabQualLen,
    UCHAR  RFAR        *tabOwner,
    SWORD               tabOwnerLen,
    UCHAR  RFAR        *tabName,
    SWORD               tabNameLen,
    UWORD               unique,
    UWORD               accuracy
);

RETCODE REXTERNAL SQLTables(
    HSTMT               hstmt,
    UCHAR  RFAR        *tabQual,
    SWORD               tabQualLen,
    UCHAR  RFAR        *tabOwner,
    SWORD               tabOwnerLen,
    UCHAR  RFAR        *tabName,
    SWORD               tabNameLen,
    UCHAR  RFAR        *tabType,
    SWORD               tabTypeLen
);


/* Level 2 Prototypes */
RETCODE REXTERNAL SQLBrowseConnect(
    HDBC                hdbc,
    UCHAR  RFAR        *strIn,
    SWORD               strInLen,
    UCHAR  RFAR        *strOut,
    SWORD               strOutLen,
    SWORD  RFAR        *actualOutLen
);

RETCODE REXTERNAL SQLColumnPrivileges(
    HSTMT               hstmt,
    UCHAR  RFAR        *tabQual,
    SWORD               tabQualLen,
    UCHAR  RFAR        *tabOwner,
    SWORD               tabOwnerLen,
    UCHAR  RFAR        *tabName,
    SWORD               tabNameLen,
    UCHAR  RFAR        *colName,
    SWORD               colNameLen
);

RETCODE REXTERNAL SQLDataSources(
    HENV                henv,
    UWORD               direction,
    UCHAR  RFAR        *srcName,
    SWORD               srcNameLen,
    SWORD  RFAR        *actualNameLen,
    UCHAR  RFAR        *description,
    SWORD               descLen,
    SWORD  RFAR        *actualDescLen
);

RETCODE REXTERNAL SQLDescribeParam(
    HSTMT               hstmt,
    UWORD               paramNum,
    SWORD  RFAR        *sqlType,
    UDWORD RFAR        *precision,
    SWORD  RFAR        *scale,
    SWORD  RFAR        *nullable
);
               
RETCODE REXTERNAL SQLExtendedFetch(
    HSTMT               hstmt,
    UWORD               fetchType,
    SDWORD              rowNum,
    UDWORD RFAR        *actualRows,
    UWORD  RFAR        *rowStatArray
);

RETCODE REXTERNAL SQLForeignKeys(
    HSTMT               hstmt,
    UCHAR  RFAR        *priTabQual,
    SWORD               priTabQualLen,
    UCHAR  RFAR        *priTabOwner,
    SWORD               priTabOwnerLen,
    UCHAR  RFAR        *priTabName,
    SWORD               priTabNameLen,
    UCHAR  RFAR        *forTabQual,
    SWORD               forTabQualLen,
    UCHAR  RFAR        *forTabOwner,
    SWORD               forTabOwnerLen,
    UCHAR  RFAR        *forTabName,
    SWORD               forTabNameLen
);

RETCODE REXTERNAL SQLMoreResults(
    HSTMT               hstmt
);

RETCODE REXTERNAL SQLNativeSql(
    HDBC                hdbc,
    UCHAR  RFAR        *sqlIn,
    SDWORD              sqlInLen,
    UCHAR  RFAR        *nativeOut,
    SDWORD              nativeOutLen,
    SDWORD RFAR        *actualOutLen
);

RETCODE REXTERNAL SQLNumParams(
    HSTMT             hstmt,
    SWORD RFAR      * numParms
);

RETCODE REXTERNAL SQLParamOptions(
    HSTMT               hstmt,
    UDWORD              numParams,
    UDWORD RFAR        *indexBuf
);

RETCODE REXTERNAL SQLPrimaryKeys(
    HSTMT               hstmt,
    UCHAR  RFAR        *tabQual,
    SWORD               tabQualLen,
    UCHAR  RFAR        *tabOwner,
    SWORD               tabOwnerLen,
    UCHAR  RFAR        *tabName,
    SWORD               tabNameLen
);

RETCODE REXTERNAL SQLProcedureColumns(
    HSTMT               hstmt,
    UCHAR  RFAR        *procQual,
    SWORD               procQualLen,
    UCHAR  RFAR        *procOwner,
    SWORD               procOwnerLen,
    UCHAR  RFAR        *procName,
    SWORD               procNameLen,
    UCHAR  RFAR        *colName,
    SWORD               colNameLen
);

RETCODE REXTERNAL SQLProcedures(
    HSTMT               hstmt,
    UCHAR  RFAR        *procQual,
    SWORD               procQualLen,
    UCHAR  RFAR        *procOwner,
    SWORD               procOwnerLen,
    UCHAR  RFAR        *procName,
    SWORD               procNameLen
);

RETCODE REXTERNAL SQLSetPos(
    HSTMT               hstmt,
    UWORD               rowIndex,
    BOOL                refresh,
    BOOL                lock
);

RETCODE REXTERNAL SQLSetScrollOptions(
    HSTMT               hstmt,
    UWORD               concurrency,
    SDWORD              numRowKeys,
    UWORD               numRows
);

RETCODE REXTERNAL SQLTablePrivileges(
    HSTMT               hstmt,
    UCHAR  RFAR        *tabQual,
    SWORD               tabQualLen,
    UCHAR  RFAR        *tabOwner,
    SWORD               tabOwnerLen,
    UCHAR  RFAR        *tabName,
    SWORD               tabNameLen
);

#ifdef __cplusplus
}
#endif

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/SQLEXT.H_V   1.8   18 Apr 1994 12:11:58   RICHM  $
*/
