/*----------------------------------------------------------------------
   rdsbasic.h:  fundamental definitions for all Velocis code

   This file should be included in all programs which use Velocis.  It
   contains basic, standard type definitions.

   Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RDSBASIC_H
#define RDSBASIC_H

#ifdef __cplusplus
extern "C" {
#endif

/* ordinal incremented whenever client and server become incompatable */
#define RDS_COMPATABILITY  (1)  /* checked during s_login() */

#ifndef RDS_SYS
#define RDS_SYS         /* Velocis (used by some RDM code) */
#endif

#include "platform.h"

/* Totally portable macro to get the number of elements in an array of
 * ANYTHING:
 */
#define RLEN(x)     (sizeof(x) / sizeof(x[0]))

/* Common typedefs for prototypes */
typedef unsigned short RDM_SESS;   /* Session handle */
typedef unsigned long  RDM_DB;     /* Database handle */

#define S_OKAY        0	    /* normal return, okay */

/* the following two definitions must be changed together */
typedef short DB_SHORT;
#define DB_SHORT_LEN 2

typedef unsigned short DB_USHORT;
typedef unsigned long DB_ULONG;

#define MAXRECORDS 16777215L
#define NULL_DBA 0L
#define NO_DB 0L        /* invalid database handle */
#define NO_SESS 0       /* invalid session handle */
#define MAXDIMS 3

/* RDM database address */
#define DB_ADDR unsigned long

/* RDM file number */
#define FILE_NO DB_USHORT

/* file address: page or record number */
#define F_ADDR long

/* DB_ADDR encodeing/decoding */
#define FILEMASK 0xFFL
#define ADDRMASK 0x00FFFFFFL
#define FILESHIFT 24

typedef void (REXTERNAL * ERRORPROC) (short, RDM_SESS, void RFAR *);

/* Get the session handle given the database handle */
#define MAKE_SESS(d) ((RDM_SESS)((d>>16)&0xffff))
#define MAKE_DBN(h) ((short)(h&0xffff))
#define MAKE_HDB(s,d) (((RDM_DB)s << 16) | ((RDM_DB)d & 0xffffL))

#define FILENMLEN  48
#define OBJNAMELEN 48


/* NOTE:  the following definitions are used within RDS, but are not needed
 * by external users.  For release, they should (and will) be put under an
 *      "#ifdef RDSINTDEF"
 */

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

#ifndef DWORDPAD
#define DWORDPAD(a) ((sizeof(double)-(a)%sizeof(double))%sizeof(double))
#endif

#ifndef WORDPAD
#ifdef SOLARIS
#define WORDPAD(a) ((sizeof(double)-(a)%sizeof(double))%sizeof(double))
#elif defined(AIX)
#define WORDPAD(a) ((8-(a)%8)%8)
#else
#define WORDPAD(a) ((sizeof(int)-(a)%sizeof(int))%sizeof(int))
#endif
#endif


#ifdef __cplusplus
}
#endif

#endif /* RDSBASIC_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/RDSBASIC.H_V   1.15   11 Nov 1994 08:36:14   BRADB  $
*/
