/*----------------------------------------------------------------------------
   rdmint.h:  internal RDS engine routines, not for use by customers

   Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------------*/

#ifndef RDMINT_H
#define RDMINT_H

/* utility functions */

short REXTERNAL d_AddrCmp(
    DB_ADDR RFAR *d1,
    DB_ADDR RFAR *d2,
    RDM_DB  hDb
);

short REXTERNAL d_BldcompKey(
    short   fld,
    char RFAR *rec,
    short   recinplen,
    char RFAR *key,
    short   keyoutlen,
    short   cflag,
    RDM_DB  hDb
);

short REXTERNAL d_BoundaryKey(
    short   fld,
    short   fcn,
    DB_ADDR RFAR *dba,
    RDM_DB  hDb
);

short REXTERNAL d_DataRecordRead(
    DB_ADDR dba,
    void RFAR *buff,
    DB_SHORT recordsize,
    RDM_DB  hDb
);

short REXTERNAL d_FieldCmp(
    long       field,
    char RFAR *f1,
    char RFAR *f2,
    RDM_DB     hDb
);

short REXTERNAL d_initfile(
    FILE_NO  fno,
    RDM_DB   hDb
);
short REXTERNAL d_initialize(
    RDM_DB   hDb
);

short REXTERNAL d_isSqlAdmin(
    short *isSqladmin,      /* set to TRUE if sqladmin, FALSE otherwise */
    RDM_SESS hSess
);

short REXTERNAL d_isDbOpen(
    char *dbname
);

short REXTERNAL d_getDbdNameFromDb(
    const char *dbname,     /* name of database instance */
    char *dbdname,          /* name of corresponding database template */
    short tempDb            /* whether temporary */
);

short REXTERNAL d_InsertKey(
    long    field,
    char RFAR *key_val,
    short   length,
    DB_ADDR dba,
    RDM_DB  hDb
);

short REXTERNAL d_LocateKey(
    short   fld,
    char RFAR *key_val,
    short   length,
    DB_ADDR RFAR *dba,
    short lockOpt,
    RDM_DB  hDb
);

short REXTERNAL d_PageRead(
    FILE_NO fno,
    long    page_no,
    void RFAR *buff,
    short   pgsize,
    RDM_DB  hDb
);

short REXTERNAL d_PageZeroRead(
    FILE_NO fno,
    void RFAR *pz_val,
    short   length,
    RDM_DB  hDb
);

short REXTERNAL d_ScanKey(
    short   fld,
    short   fcn,
    DB_ADDR RFAR *dba,
    RDM_DB  hDb
);


short REXTERNAL d_OptTst(
    void RFAR *fld_ptr,
    short   fldptrlen,
    char RFAR *rec,
    short   reclen,
    RDM_DB  hDb
);

short REXTERNAL d_GetIndexDepth(
    FILE_NO  fno,
    short RFAR *depth,
    RDM_DB   hDb
);

short REXTERNAL d_GetServerName(
    char RFAR * RFAR *name
);

short REXTERNAL d_SetServerName(
    char RFAR *name
);

short REXTERNAL d_getDiskFreeSpace(
    unsigned long RFAR *pAvail,
    char RFAR *devname,
    RDM_SESS hSess
);

short REXTERNAL d_setMinFreeSpace(
    unsigned long minFree,
    RDM_SESS hSess
);

#endif /* RDMINT_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/RDMINT.H_V   1.6   17 Feb 1995 18:25:06   BRADB  $
*/
