/*----------------------------------------------------------------------
   rdm.h: Velocis standard header file

   This file should be included in all programs which use RDM.  It
   contains database status/error code definitions and standard type
   definitions.

   Copyright (c) 1984-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef RDM_H
#define RDM_H

#ifdef __cplusplus
extern "C" {
#endif

#include "rdsbasic.h"

#define dbd_VERSION "S3.00\032"

/* record number indicator */
#define RECMARK 10000
/* field number indicator = rec * FLDMARK + fld_in_rec */
#define FLDMARK 1000L
/* set number indicator - must be greater than RECMARK */
#define SETMARK 20000

#define TRANS_ID_LEN 21
#define USERNAMELEN 15


/*
------------------------------------------------------------------------------
     Freeing options at d0_trend/d0_trabort
------------------------------------------------------------------------------
*/
#define RDLOCKS   1
#define WRLOCKS   2
#define RWLOCKS   3

#define CRLOCK  0
#define CMLOCK  1
#define COLOCK  2
#define CSLOCK  3
#define CRSLOCK 4
#define DBALOCK 5
#define RTLOCK  6
#define STLOCK  7
typedef struct _GROUPLOCK {
    short ftype;	/* function type - CRLOCK, CMLOCK, COLOCK,
					   CSLOCK, CRSLOCK, DBALOCK,
					   RTLOCK, STLOCK */
    short rstype;	/* record or set constant */
    DB_ADDR dba;	/* database address (if required) */
    RDM_DB hdb;		/* database number of entity */
    unsigned short odnum;	/* open database number (reserved) */
    char lmode;         /* lock mode, 'w' or 'r' */
} GROUPLOCK;

typedef struct _CHGINFO {
    char chgName[8];
    unsigned long curofs;
} CHGINFO;


/*
------------------------------------------------------------------------------
    Dictionary Tables
------------------------------------------------------------------------------
*/

#define OPEN 'o'	/* applies to file or database */
#define CLOSED 'c'	/* applies to file or database */
#define DATA 'd'
#define KEY 'k'

typedef struct FILE_ENTRY_S {
    char     ft_name[FILENMLEN];/* name of file */
    DB_SHORT ft_desc;		/* file descriptor */
    char     ft_status;		/* 'o'=opened, 'c'=closed */
    char     ft_type;		/* 'd'=data,   'k'=key */
    DB_USHORT ft_slots;		/* record slots per page */
    DB_USHORT ft_slsize;	/* size of record slots in bytes */
    DB_USHORT ft_pgsize;	/* size of page */
    DB_USHORT ft_flags;		/* 0x0002 is set if file is static */
}     FILE_ENTRY;


typedef struct RECORD_ENTRY_S {
    DB_USHORT rt_file;		/* file table entry of file containing record */
    DB_USHORT rt_len;		/* total length of record */
    DB_USHORT rt_data;		/* offset to start of data in record */
    DB_USHORT rt_fields;	/* first field def in field_table */
    DB_SHORT rt_fdtot;		/* total number of fields in record (note --
				 * set to (-1) if this is the system record */
    DB_SHORT rt_flags;		/* 0x0001 is set if record is timestamped
				   0x0002 is set if record is static */
}     RECORD_ENTRY;


#define FIRST      'f'
#define LAST       'l'
#define ASCENDING  'a'
#define DESCENDING 'd'
#define NOORDER    'n'
#define NEXT       'n'
typedef struct SET_ENTRY_S {
    DB_SHORT st_order;		/* 'f'=first, 'l'=last, 'a'=ascending,
				   'd'=descending, 'n'=no order */
    DB_SHORT st_own_rt;		/* record table entry of owner */
    DB_SHORT st_own_ptr;	/* offset to set pointers in record */
    DB_SHORT st_members;	/* index of first member record in member
				   table */
    DB_SHORT st_memtot;		/* total number of members of set */
    DB_SHORT st_flags;		/* 0x0001 is set if record is timestamped */
}     SET_ENTRY;


typedef struct MEMBER_ENTRY_S {
    DB_SHORT mt_record;		/* record table entry for this member */
    DB_SHORT mt_mem_ptr;	/* offset to member ptrs in record */
    DB_SHORT mt_sort_fld;	/* sort table entry of first sort field */
    DB_SHORT mt_totsf;		/* total number of sort fields */
}     MEMBER_ENTRY;


typedef struct SORT_ENTRY_S {
    DB_USHORT se_fld;		/* field table entry of sort field */
    DB_USHORT se_set;		/* set table entry of sorted set */
}     SORT_ENTRY;


#define NOKEY      'n'
#define DUPLICATES 'd'
#define UNIQUE     'u'
#define CHARACTER  'c'
#define SHORTINT   's'
#define REGINT     'i'
#define LONGINT    'l'
#define FLOAT      'f'
#define DOUBLE     'F'
#define DBADDR     'd'
#define GROUPED    'g'
#define COMKEY     'k'
typedef struct FIELD_ENTRY_S {
    char     fd_key;		/* 'n'=none, 'd'=duplicates, 'u'=unique */
    unsigned char fd_type;	/* 'c'=char, 's'=short, 'i'=int, 'l'=long,
				   'd'=DB_ADDR, 'f' = float, 'D' = double,
				   'g'=grouped field, 'k' = compound key */
    DB_USHORT fd_len;		/* length of field in bytes */
    DB_USHORT fd_dim[MAXDIMS];	/* size of each array dimension */
    DB_USHORT fd_keyfile;	/* file_table entry for key file */
    DB_SHORT fd_keyno;		/* key prefix number */
    DB_USHORT fd_ptr;		/* offset to field in record or 1st compound
				   key field in key_table */
    DB_SHORT fd_rec;		/* record table entry of record containing
				   field */
    DB_USHORT fd_flags;	 /* 0x0001 is set if field in "by" clause of set spec
                            0x0002 is set if field member of struct field 
                            0x0004 is set if field is unsigned data type
			    0x0008 is set if field is an optional key
			    0x0010 is for Future Use
			    0x0020 is for Future Use
			    0x0040 TO 0x0200 is Optional Sort Method code
			    0x0400 TO 0x8000 is reserved */
}     FIELD_ENTRY;

/* dictionary attribute flags */
#define SORTFLD     0x0001	/* field is a set sort field */
#define STRUCTFLD   0x0002	/* field is sub-field of struct */
#define UNSIGNEDFLD 0x0004	/* field is unsigned */
#define STATIC      0x0002	/* file/record is static */
#define LOCAL       0x0004	/* file/record is local */
#define COMKEYED    0x0010	/* record/field contains/included in compound
				   key */

#define DB_ADDR_SIZE sizeof(long)
#define RECHDRSIZE (sizeof(DB_SHORT) + DB_ADDR_SIZE)

/* compound key table entry declaration */
typedef struct KEY_ENTRY_S {
    DB_SHORT kt_key;	/* compound key field number */
    DB_USHORT kt_field;	/* field number of included field */
    DB_SHORT kt_ptr;	/* offset to start of field data in key */
    DB_SHORT kt_sort;	/* 'a'=ascending, 'd'=descending, OR a usersort_d # */
}     KEY_ENTRY;

/* used for field offset computation */
typedef struct RECORD_SIZES_S {
    DB_USHORT rt_size;
    DB_USHORT rt_fields;
} RECORD_SIZES;

#define DICT_SIZES     0
#define DICT_FT	       1
#define DICT_RT	       2
#define DICT_FD	       3
#define DICT_ST	       4
#define DICT_MT	       5
#define DICT_SRT       6
#define DICT_KT	       7
#define DICT_REC_SIZES 8
#define DICT_FLD_SIZES 9

#define  icFile      0
#define  icRecord    1
#define  icField     2
#define  icSet       3
#define  icMember    4
#define  icSortRec   5
#define  icKey       6

typedef struct _SIZE_ENTRY {
    char  db_name[FILENMLEN];
    unsigned short size[7];
} SIZE_ENTRY;


/*
------------------------------------------------------------------------------
    Statistics
------------------------------------------------------------------------------
*/
#define N_STATS 54

#define STAT_READ                  0
#define STAT_BYTES_READ            1
#define STAT_WRITE                 2
#define STAT_BYTES_WRITE           3
#define STAT_OPEN_FILES            4
#define STAT_CLOSE_FILES           5
                                   
#define STAT_PGZERO_READ           6
#define STAT_PGZERO_WRITE          7
#define STAT_OPEN_DB_TABLES        8
#define STAT_CLOSE_DB_TABLES       9
#define STAT_OPEN_DBS              10
#define STAT_CLOSE_DBS             11
                                   
#define STAT_GROUP_LOCK_REQ        12
#define STAT_GROUP_LOCK_BLOCKED    13
#define STAT_GROUP_LOCK_TIMEOUT    14
#define STAT_INST_READ_LOCKS       15
#define STAT_TABLE_READ_LOCKS      16
#define STAT_INST_WRITE_LOCKS      17
#define STAT_TABLE_WRITE_LOCKS     18
#define STAT_FREED_LOCKS           19
                                   
#define STAT_DIO_PAGE_READ         20
#define STAT_DIO_PAGE_REMOVED      21
#define STAT_DIO_FINDPAGES         22
#define STAT_DIO_REUSE_LAST        23
#define STAT_DIO_PAGE_MODIFIED     24
                                   
#define STAT_TRBEGINS              25
#define STAT_TRENDS                26
#define STAT_TRABORTS              27
#define STAT_CHGLOG_WRITE          28
#define STAT_CHGLOGS               29
#define STAT_CHGLOGS_BYTES_WRITE   30
#define STAT_OPEN_CHGLOG           31
#define STAT_CLOSE_CHGLOG          32
#define STAT_TRROLLBACKS           33
#define STAT_CHECKPOINTS           34
#define STAT_PIGGYBACKS            35
                                   
#define STAT_SERVER_RPCS           36
#define STAT_LOGINS                37
#define STAT_LOGOUTS               38
#define STAT_CLIENT_ABORTS         39
                                   
#define STAT_REQUESTS              40
#define STAT_D_FCN_CALLS           41
#define STAT_DBERRS                42
#define STAT_NORM_REQUESTS         43
#define STAT_PRI_REQUESTS          44
#define STAT_SCHED_IDLE_TIME       45
#define STAT_SCHED_BUSY_TIME       46
#define STAT_DDLGEN                47
#define STAT_DDLP                  48
#define STAT_DBCHECK               49
#define STAT_DBDUMP                50
#define STAT_DBREV                 51
#define STAT_SDDL                  52
#define STAT_KEYPACK               53

/* constants used in permission api's in catalog */

#define DB_RDACC  0
#define DB_UPACC  1
#define DB_CRACC  2
#define DB_DELACC 4
#define DB_ALLACC 7

#ifdef __cplusplus
}
#endif

#endif /* RDM_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/RDM.H_V   1.52   18 Apr 1994 12:10:56   RICHM  $
*/
