/*
    File: NCP.H
 Purpose: Include module for Network Communications Processor.
  Author: Brian Scott
    Date: 1-28-92
      02/09/93 MPG Netware port
 Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------------*/

#ifdef WIN32_NT
#define WINDLL
#endif

/******************* RETURN CODES **************************/

#define NCP_RC_SUCCESS                      0
#define NCP_RC_INTERNAL_ERROR               1
#define NCP_RC_INVALID_OPERATION            2
#define NCP_RC_INVALID_MODE                 3
#define NCP_RC_INVALID_SERVER_NAME          4
#define NCP_RC_INVALID_SESSION_ID           5
#define NCP_RC_QUEUE_EMPTY                  6
#define NCP_RC_INVALID_MSG_SIZE             7
#define NCP_RC_SESSION_DISCONNECTED         8
#define NCP_RC_SESSIONS_EXCEEDED            9
#define NCP_RC_NAME_SERVER_UNREACHABLE      10
#define NCP_RC_INVALID_CONNECT_DATA         11
#define NCP_RC_REMOTE_NODE_UNREACHABLE      12
#define NCP_RC_SERVER_UNAVAILABLE           13
#define NCP_RC_TRANSPORT_UNAVAILABLE        14
#define NCP_RC_SESSION_REJECT               15
#define NCP_RC_RESPONSE_NOT_RECEIVED        16
#define NCP_RC_DATA_COMPLETE                17
#define NCP_RC_DATA_INCOMPLETE              18
#define NCP_RC_INVALID_PROTOCOL             19
#define NCP_RC_SESSION_DISCONNECTING        20
#define NCP_RC_INSUFF_NET_RESOURCES         21
#define NCP_RC_NOT_IMPLEMENTED              22
#define NCP_RC_WINDOWS_NOT_ACTIVE           23
#define NCP_RC_VRDS_DEVICE_UNAVAILABLE      24
#define NCP_RC_VRDS_INCOMPATIBLE_VER        25
#define NCP_RC_MAX_RETURN_CODE              25

/******************* OPERATIONAL MODES AND STATES **************************/

#define NCP_MODE_SEND       0
#define NCP_MODE_NORMAL     1
#define NCP_MODE_PRIORITY   2
#define NCP_MODE_CLIENT     3
#define NCP_MODE_SERVER     4
#define NCP_MODE_WAIT       5
#define NCP_MODE_NO_WAIT    6
#define NCP_MODE_SIGNAL     7
#define NCP_MODE_NO_SIGNAL  8
#define NCP_MODE_PARTIAL    9
#define NCP_MODE_COMPLETE   10

#define NCP_SESS_STATE_DEALLOCATED   0
#define NCP_SESS_STATE_ALLOCATED     1
#define NCP_SESS_STATE_SEND_INIT     2
#define NCP_SESS_STATE_SEND          3
#define NCP_SESS_STATE_RECEIVE       4
#define NCP_SESS_STATE_RECEIVE_INIT  5
#define NCP_SESS_STATE_DISCONNECTING 6
#define NCP_SESS_STATE_LISTENING     7
#define NCP_SESS_STATE_CONNECTED     8

#define NCP_TYPE_MESSAGE    0
#define NCP_TYPE_LOGIN      1
#define NCP_TYPE_LOGOUT     2

#define NCP_ARCH_INTEL_MSC   1
#define NCP_ARCH_INTEL_SCO   2
#define NCP_ARCH_SPARC_SUN   3
#define NCP_ARCH_M68_SUN     4
#define NCP_ARCH_RS6000      4      /* HELP! another foul lie! */
#define NCP_ARCH_MAX_TYPE    4
#define NCP_ARCH_INTEL       NCP_ARCH_INTEL_MSC

/******************* CONSTANTS **************************/

#define NCP_C_MAX_BUF_SIZE             65000
#define NCP_C_MAX_MSG_SIZE             (NCP_C_MAX_BUF_SIZE - 28)
#define NCP_C_MAX_SESSIONS             254
#define NCP_C_MAX_SERVER_NAME          12
#define NCP_C_LOCAL_NODE_NAME          "LNNAME"
#define NCP_C_INPUT_BUF_SIZE           16384
#define NCP_C_OUTPUT_BUF_SIZE          16384
#define NCP_C_SESSCB_KEY               99

#ifdef WINSOCK
#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))
#endif

/***************** Control Blocks **********************/

typedef struct NIOCB_ { /* Network IO Control Block */
    unsigned short     usMsgLen;            /* Total Length of the message  */
    unsigned short     usBytesRemng;        /* Bytes left to send / receive */
    unsigned char      uchPriority;         /* Priority of the message.     */
    void               *pvMsgBuf;           /* Pointer to start of message  */
    char               *pchCurPos;          /* Current position in the message buf */
    unsigned char      bNewMessage;         /* Flag indicating start of new message*/
} NIOCB, *PNIOCB;

typedef struct SESSCB_ {  /* Session Control Block */
    unsigned char       uchState;       /* Session State */
    unsigned short      usSessionId;    /* Session Id    */
    unsigned char       uchRemoteSystemType;  /* System architecure of remote system */
} SESSCB, *PSESSCB;

typedef struct NCPCB_ {
    void      *pvTrpCB;         /* Pointer to the transport control block */
    void      *pvQueueCB;       /* Pointer to the queue control block     */
    PSESSCB   pSessCB;          /* Pointer to the session control blocks  */
    char      achServerName[NCP_C_MAX_SERVER_NAME+1];
    char      achNameServerNode[48];/* Netware File Server - 48byte limit */
    unsigned char uchMode;      /* Mode this NCP is in - Client/Server    */
    unsigned short usMaxSession;/* Max sessions available for this NCP    */
#ifdef __NETWARE_386__
    unsigned short usCurSessions;	/* Current # of sessions	    */
#endif
    unsigned short usInputBufSize;  /* Input buf size for each transport connection */
    unsigned short usOutputBufSize; /* Output buf size for each transport connection */
} NCPCB, *PNCPCB;

#ifdef NCP_DEBUG
#define ncperr(a)   ncperrLINE(a, __FILE__, __LINE__)
#endif

/******************* FUNCTION PROTOTYPES **************************/
#if !defined(UNIX) && !defined(WATC)
#ifdef WIN32_NT
#include <windows.h>
#define NCPENTRY APIENTRY
#elif defined(__BORLANDC__)
#define NCPENTRY pascal
#define NCPINTERNAL
#elif defined(__IBMC__) || defined (__IBMCPP__)
#define NCPENTRY
#define NCPINTERNAL
#elif defined(WINDOWS)
#define NCPENTRY _loadds pascal far
#define NCPINTERNAL far
#else
#define NCPENTRY pascal far
#define NCPINTERNAL far
#endif
#endif

#ifndef NCPENTRY
#define NCPENTRY
#endif

#ifndef NCPINTERNAL
#define NCPINTERNAL
#endif

#define NCP_STACK_SZ (1024 * sizeof(int))

unsigned short NCPENTRY n_term __ARGS((void));
unsigned short NCPENTRY n_init __ARGS((char *, unsigned short, unsigned char,
    char *, unsigned short, unsigned short));
unsigned short NCPENTRY n_send __ARGS((void *, unsigned short, unsigned short));
unsigned short NCPENTRY n_receive __ARGS((void **, unsigned short *,
    unsigned short *, unsigned char, short));
unsigned short NCPENTRY n_trans __ARGS((void *, unsigned short, void **,
    unsigned short *, unsigned short, unsigned char, unsigned char));
unsigned short NCPENTRY n_logout __ARGS((unsigned short));
unsigned short NCPENTRY n_login __ARGS((char *, char *, unsigned short *,
    unsigned short, unsigned long));
unsigned short NCPENTRY n_getBuf __ARGS((unsigned short, void **));
unsigned short NCPENTRY n_freeBuf __ARGS((void *));
unsigned short NCPENTRY n_setSems __ARGS((void *, void *));
void           NCPENTRY n_getRCString __ARGS((void *, short *, unsigned short));
unsigned short NCPENTRY n_getServerList __ARGS((char *, void **,
    unsigned short *));
unsigned short NCPENTRY n_getRemoteSysType __ARGS((unsigned short,
    unsigned char *));
void NCPENTRY n_ncperrinfo __ARGS((void *pvStringBuf, short *psBufLen,
    short sRetCode));

#ifdef NCP_DEBUG
unsigned short NCPENTRY ncperrLINE __ARGS((unsigned short, char *, short));
#else
unsigned short NCPENTRY ncperr __ARGS((unsigned short));
#endif

/*
$Header:   P:/PAT/INCLUDE/VCS/NCP.H_V   1.46   13 Dec 1994 08:00:44   BRADB  $
*/
