/*----------------------------------------------------------------------
   memtrap.h: routines to log memory allocations and de-allocations.

   This file is #include'd in rmcomp.h, when the environment variable
   INCL_MEMTRAP is defined.  Note that INCL_MEMTRAP is #undef'd in
   rmalloc.c and rm\*comp.c, so the underlying routines aren't zapped.

   Copyright (c) 1993-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef MEMTRAP_H
#define MEMTRAP_H

#ifndef NO_MEMTRAP_REDEFINES
#define rm_getMemory(a,b)      rm_LOG_getMemory (a, b, __FILE__, __LINE__)
#define rm_cGetMemory(a,b)     rm_LOG_cGetMemory (a, b, __FILE__, __LINE__)
#define rm_extendMemory(a,b,c) rm_LOG_extendMemory (a,b,c,__FILE__, __LINE__)
#define rm_Strdup(a,b)         rm_LOG_Strdup (a, b, __FILE__, __LINE__)
#define rm_freeMemory(a,b)     rm_LOG_freeMemory (a, b)
#define rm_zFreeMemory(a,b)    rm_LOG_zFreeMemory (a, b)
#define rm_growMemory(a,b,c)   rm_LOG_growMemory (a,b,c,__FILE__, __LINE__)
#endif

void *REXTERNAL rm_LOG_getMemory(
    size_t size,
    short tag,
    char *fileName,     /* location of allocation request -- source file ...*/
    int lineNum         /* ... and line number */
);
void *REXTERNAL rm_LOG_cGetMemory(
    size_t size,
    short tag,
    char *fileName,     /* location of allocation request -- source file ...*/
    int lineNum         /* ... and line number */
);
void RFAR *REXTERNAL rm_LOG_extendMemory(
    void RFAR *memblock,
    size_t newSize,
    short tag,
    char *fileName,     /* location of allocation request -- source file ...*/
    int lineNum         /* ... and line number */
);
void RFAR *REXTERNAL rm_LOG_growMemory(
    void RFAR *memblock,
    size_t newSize,
    short tag,
    char *fileName,     /* location of allocation request -- source file ...*/
    int lineNum         /* ... and line number */
);
char *REXTERNAL rm_LOG_Strdup(
    char *cp,
    short tag,
    char *fileName,     /* location of allocation request -- source file ...*/
    int lineNum         /* ... and line number */
);
void REXTERNAL rm_LOG_freeMemory(
    void *ptr,
    short tag  
);
void REXTERNAL rm_LOG_zFreeMemory(
    void **pptr,
    short tag 
);

#endif /* MEMTRAP_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/MEMTRAP.H_V   1.2   18 Apr 1994 12:10:16   RICHM  $
*/
