/*
    File: DPLDEFS.H
 Purpose: Include module for Data Portability Layer.
  Author: Brian Scott
    Date: 7-8-92

 Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------------*/

#ifndef DPLDEFS_H
#define DPLDEFS_H

#ifdef __cplusplus
extern "C" {
#endif

/************************** CONSTANTS *******************************/
#define  DPL_C_ROUNDUP                  0
#define  DPL_C_ROUNDUP_AND_LENGTH       -1
#define  DPL_C_XDR_ENC_CHAR_SIZE        4
#define  DPL_C_XDR_ENC_OPAQUE_SIZE      DPL_C_ROUNDUP_AND_LENGTH
#define  DPL_C_XDR_ENC_DOUBLE_SIZE      8
#define  DPL_C_XDR_ENC_FLOAT_SIZE       4
#define  DPL_C_XDR_ENC_INT_SIZE         4
#define  DPL_C_XDR_ENC_LONG_SIZE        8
#define  DPL_C_XDR_ENC_SHORT_SIZE       4
#define  DPL_C_XDR_ENC_U_CHAR_SIZE      4
#define  DPL_C_XDR_ENC_U_INT_SIZE       4
#define  DPL_C_XDR_ENC_U_LONG_SIZE      8
#define  DPL_C_XDR_ENC_U_SHORT_SIZE     4

/******************* DATA TYPES & MODIFIERS **************************/
#define DPL_DT_CHAR                0x0001
#define DPL_DT_DOUBLE              0x0002
#define DPL_DT_FLOAT               0x0003
#define DPL_DT_INT                 0x0004
#define DPL_DT_LONG                0x0005
#define DPL_DT_SHORT               0x0006
#define DPL_DT_OPAQUE              0x0007
#define DPL_DT_U_CHAR              0x0008
#define DPL_DT_U_INT               0x0009
#define DPL_DT_U_LONG              0x000a
#define DPL_DT_U_SHORT             0x000b
#define DPL_DT_OPEN_STRUCT         0x000c
#define DPL_DT_CLOSE_STRUCT        0x000d
#define DPL_DT_DATA_DESC           0x000e
#define DPL_DT_ASCIZ               0x000f
#define DPL_DT_MAX_TYPE            0x000f
#define DPL_DT_MOD_ARRAY           0x0100
#define DPL_DT_MOD_SOURCE_REF      0x0200
#define DPL_DT_MOD_TARGET_REF      0x0400
#define DPL_DT_MOD_ALIGNED         0x0800
#define DPL_DT_MOD_END_OF_STRUCT   0x1000
#define DPL_DT_MOD_FREE_MEM        0x2000
#define DPL_DT_MOD_NULL_PTR        0x4000
#define DPL_DT_MASK                0x00ff

/************** MODE PARAMETERS ********************************/
#define DPL_MODE_ALIGN      0x01
#define DPL_MODE_IGNORE_OVF 0x02

#ifdef __cplusplus
}
#endif

#ifndef UNIX
#define DPL_DEFAULT_ALIGNMENT 0
#else
#define DPL_DEFAULT_ALIGNMENT 1
#endif

#endif /* DPLDEFS_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/DPLDEFS.H_V   1.9   18 Apr 1994 12:10:02   RICHM  $
*/
