/*
    File: DPLDATA.H
 Purpose: Data structures for Data Portability Layer.
  Author: Brian Scott
    Date: 7-8-92

 Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
-----------------------------------------------------------------------------*/

#ifndef DPLDATA_H
#define DPLDATA_H

typedef union {
    unsigned short usVal;
    short          sVal;
    unsigned int   uiVal;
    int            iVal;
    float          fVal;
    double         dVal;
    char           chVal;
    unsigned char  uchVal;
    long   	       lVal;
    unsigned long  ulVal;
    void RFAR *    pvVal;
} DPLDATAVAL, RFAR *PDPLDATAVAL;

typedef struct {  /* Data Item Type */
    unsigned short usDataType; /* Data Type and Modifier */   
    unsigned short usSize;     /* Size if array or opaque */
    unsigned short usStructSize;
    DPLDATAVAL DataVal;        /* Holds the simple data value */
} DPLDATAITEM, RFAR *PDPLDATAITEM;

typedef struct DPLDATADESC_ {        /* Data Descriptor */
    unsigned short usInitAlloc;      /* Initial and future allocations */
    unsigned short usNumItems;       /* Number of Items in pDataItems List */
    unsigned short usMaxItems;       /* Max Data Item */
    unsigned short usCurItem;        /* Current Item being retrieved */
    unsigned short usDataStreamLen;  /* Size of the data stream in bytes */ 

/* HELP RichM sErrCode and usErrParm are only supported for rpc_putParm,
 * rpc_PutParms, and rpc_putStructParm -- not (?) rpc_putBoundParm */
    short          sErrCode;         /* error gotten while putting to this
                                        parameter list (S_OKAY if no errors) */
    unsigned short usErrParm;        /* if sErrCode!=S_OKAY, the number of
                                        the first parameter with an error */
    void RFAR *    pvDataStream;     /* Pointer to the data stream */
    PDPLDATAITEM   pDataItems;       /* List containing data descriptions */
} DPLDATADESC, RFAR *PDPLDATADESC;

#endif /* DPLDATA_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/DPLDATA.H_V   1.2   18 Apr 1994 12:10:00   RICHM  $
*/
