/*----------------------------------------------------------------------
   crpc.h: Prototypes for crpc.c.

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef CRPC_H
#define CRPC_H

short REXTERNAL RemLoginCall(
    char          *szServerName,
    PDPLDATADESC   pInParmList,
    PDPLDATADESC  *ppOutParmList,
    RDM_SESS      *hSess,
    short         *psFCNRetCode
);

short REXTERNAL RemLogoutCall(
    unsigned short hSess,
    PDPLDATADESC   pInParmList,
    PDPLDATADESC  *ppOutParmList,
    short         *psFCNRetCode
);

short REXTERNAL RemProcCall(
    unsigned short usSvcID,
    unsigned short usFcnID,
    unsigned short hSess,
    unsigned char  ucPriority,
    PDPLDATADESC   pInParmList,
    PDPLDATADESC  *ppOutParmList,
    short         *psFCNRetCode
);

short REXTERNAL ModRetCode(
    RDM_SESS hSess
);

short REXTERNAL ModRPCError(
    char *szFcnName,
    short sParmNum,
    short sRetCode
);

short REXTERNAL chk_callback(
    short    errCode,
    RDM_SESS hSess
);

short REXTERNAL RpcRtSize(
    short rec,
    RDM_DB hDb);

short REXTERNAL RpcFdSize(
    long field,
    RDM_DB hDb
);

short REXTERNAL RpcAddDb(
    RDM_DB hDb
);

void REXTERNAL RpcDelDb(
    RDM_DB hDb
);

void REXTERNAL RpcDelAllDb(
    RDM_SESS hSess
);

short REXTERNAL getCacheDD(
    short sItem,
    long  lElement,
    short *psItemCnt,
    short *psLength,
    PDPLDATAITEM *ppDD,
    RDM_DB  hDb
);

short REXTERNAL putCacheDD(
    short sItem,
    long  lElement,
    short sItemCnt,
    short *psLength,
    PDPLDATAITEM *ppDD,
    RDM_DB  hDb
);

void REXTERNAL freeCacheDB(
    RDM_DB  hDb
);

void REXTERNAL freeCache(
    RDM_SESS hSess
);

#endif

/*
$Header:   P:/PAT/INCLUDE/VCS/CRPC.H_V   1.9   26 Oct 1994 11:54:34   BRADB  $
*/
