/*----------------------------------------------------------------------
   chlog.h:  Velocis change log recording definitions

   Copyright (c) 1991-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef CHLOG_H
#define CHLOG_H

/* Change log codes */
#define CON 100		 /* Transaction Logical Modification Codes */
#define WRR 101
#define WRF 102
#define DIS 103
#define DEL 104
#define CRE 105
#define KST 106
#define KDL 107

#define TRB 200		 /* Change log file event markers */
#define TRE 201
#define TRM 202
#define UND 203
#define CHB 204
#define CHW 205
#define CHE 206
#define INI 207

#define FLS 300          /* Special instruction codes for change log thread */
#define SHD 301

/* Logical Reading Codes */
#define RDR 8
#define RDS 9

/* rollback abort codes */
#define UNDO 0
#define REDO 1
#define NOCH 1
#define FOUNDTRB 2  /* found trbegin */
#define FOUNDTRM 4  /* found mark */
#define FOUNDTRMB 8 /* found mark at trbegin */
/* Change log recording function prototypes */
void RINTERNAL chg_wrCON(
    short conType,
    DB_ADDR conRec,
    DB_ADDR conOwn,
    DB_ADDR conPrev
);

void RINTERNAL chg_wrWRR(
    short wrrType,
    DB_ADDR wrrRec,
    unsigned short wrrLen,
    void *wrrPreVal,
    void *wrrPostVal
);

void RINTERNAL chg_wrWRF(
    long wrfType,
    DB_ADDR wrfRec,
    unsigned short wrfLen,
    void *wrfPreVal,
    void *wrfPostVal
);

void RINTERNAL chg_wrDIS(
    short disType,
    DB_ADDR disRec,
    DB_ADDR disOwn,
    DB_ADDR disPrev
);

void RINTERNAL chg_wrDEL(
    short   delType,
    DB_ADDR delRec,
    unsigned short delLen,
    void *delVal
);

void RINTERNAL chg_wrCRE(
    short creType,
    DB_ADDR creRec,
    unsigned short crePostLen,
    void *crePostVal
);

void RINTERNAL chg_wrKST(
    long kstType,
    DB_ADDR kstRec
);

void RINTERNAL chg_wrKDL(
    long kdlType,
    DB_ADDR kdlRec
);

void RINTERNAL chg_wrINI(
    void
);

void RINTERNAL chg_wrTRB(
    const char *trbTrTag
);

void RINTERNAL chg_wrTRE(
    void
);

void RINTERNAL chg_wrTRM(
    const char *trmTrTag
);

void RINTERNAL chg_abort(
    void
);

short RINTERNAL chg_rollback(
    const char *trmTrTag
);

void RINTERNAL chg_wrUND(
    unsigned long undAddr,
    unsigned short txid
);

void RINTERNAL chg_wrCHB(
    void
);

void RINTERNAL chg_wrCHW(
    void
);

void RINTERNAL chg_wrCHE(
    void
);

char * RINTERNAL chg_fileName(
    void
);

void RINTERNAL chg_init(
    void
);

void RINTERNAL chg_Close(
    short doflush
);

void RINTERNAL chg_CheckCycle(
    void
);

void RINTERNAL chg_ShutDown(
    void
);

void RINTERNAL addTxID(
    unsigned short txid,
    long transPrev
);

void RINTERNAL delTxID(
    unsigned short 
);

void RINTERNAL UnModDbs(
    void
);

/* Structures written to the change log */
typedef struct _CHANGERECORD {
	unsigned short transID;		/* transaction Id */
	unsigned short transLogMod;	/* the logical modification code */
	unsigned short transChgLen;	/* the length of change record */
	unsigned short dbid;		/* the database Identifier */
	unsigned long transPrev;	/* file address of prev change rec */
	unsigned long transPrevID;	/* file address of prev rec */
        unsigned short seq;             /* sequencer */
} CHANGERECORD;


typedef struct _CONCHG {
	short conType;			/* set type constant */
	DB_ADDR conRec;			/* record being connected  */
	DB_ADDR conOwn;			/* current set owner */
	DB_ADDR conPrev;		/* Previous Member */
} CONCHG;


typedef struct _WRRCHG {
	short wrrType;			/* Record type constant */
	DB_ADDR wrrRec;		        /* Record being modified */
	unsigned short wrrLen;		/* Record Length */
} WRRCHG;


typedef struct _WRFCHG  {
	long wrfType;			/* Field type constant */
	DB_ADDR wrfRec;			/* Record being Modified */
	unsigned short wrfLen;		/* Field Length */
} WRFCHG;


typedef struct _DISCHG {
	short disType;			/* Set Type constant */
	DB_ADDR disRec;			/* Record being connected */
	DB_ADDR disOwn;			/* current set owner */
	DB_ADDR disPrev;		/* Previous member */
} DISCHG;


typedef struct _DELCHG {
        short   delType;                /* Record type */
        DB_ADDR delRec;                 /* Address of Record */
        unsigned short delLen;          /* Record data length */
} DELCHG;




typedef struct _CRECHG {
	short creType;			/* Record type */
	DB_ADDR creRec;			/* Address of record */
	unsigned short creLen;		/* Record Data Length */
} CRECHG;


typedef struct _KSTCHG {
	long kstType;			/* Key type */
	DB_ADDR kstRec;			/* Address of Record */
} KSTCHG;


typedef struct _KDLCHG {
	long kdlType;			/* Key Type */
	DB_ADDR kdlRec;			/* Address of record */
} KDLCHG;


typedef struct _TRBTRTAG {
	char trbTrTag[10];		/* Trans tag */
	long trbTime;			/* Time trans started */
} TRBTRTAG;



typedef struct _TRMMARKTAG {
	char trmTrTag[10];		/* Mark tag */
	long trmTime;
} TRMMARKTAG;


typedef struct _UNDMARKER {
	unsigned long unAddr;		/* Address within change log */
}  UNDMARKER;

typedef struct _ATL {
    unsigned short txid;
    unsigned long  transPrevID;
} ATL;

typedef struct _CHGLOGHDR {
    unsigned long  chgLogActSize;
    unsigned long  chgPrev;
    unsigned short chgSeq;
} CHGLOGHDR;

short RINTERNAL getChangeRec(
    CHANGERECORD *chgRec,
    char **modBuf,
    unsigned short *modBufLen,
    short handle,
    long fileAddr
);
short RINTERNAL proc_op(
    short optype,
    const char *trmTrTag,
    CHANGERECORD *chgRec,
    char **modBuf,
    unsigned short *modBufLen,
    short readLogFile
);

#endif
/*
$Header:   P:/PAT/INCLUDE/VCS/CHLOG.H_V   1.19   13 Oct 1994 14:57:54   RANDY  $
*/
