/*----------------------------------------------------------------------
   admrpcdd.h - data portability layer binding for s_ data structures

   Copyright (c) 1992-1994 Raima Corporation.  All Rights Reserved.
----------------------------------------------------------------------*/

#ifndef ADMRPCDD_H
#define ADMRPCDD_H

#ifdef SERVER_DD
#define DO_FREE_MEM DPL_DT_MOD_FREE_MEM
#else
#define DO_FREE_MEM 0
#endif

#define RPC_DD_FILEDEV_SIZE 4

static DPLDATAITEM aRpcDDFILE_DEV[RPC_DD_FILEDEV_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM, 0, sizeof(FILEDEV), 0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, FILELEN, 0, 0,         /* fname */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, DEVNAME_LEN, 0, 0,     /* fdevice */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT, 0, 0, 0};

#define RPC_DD_DBD_DBF_SIZE 11

static DPLDATAITEM aRpcDDDBD_DBF[RPC_DD_DBD_DBF_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM, 0, sizeof(DBD_DBF), 0,
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, DEVNAME_LEN, 0, 0, /* dbdfiledev */
     DPL_DT_OPEN_STRUCT, 0, 0, sizeof(struct dbase),    /* BEGIN db      */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, 13, 0, 0,          /* db.dbdname    */
     DPL_DT_U_SHORT, 0, 0, 0,                           /* db.dbid       */
     DPL_DT_LONG, 0, 0, 0,                              /* db.datecreate */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, 8, 0, 0,           /* db.createchg  */
     DPL_DT_U_LONG, 0, 0, 0,                            /* db.createofs  */
     DPL_DT_CHAR, 0, 0, 0,                              /* db.dbaccess   */
     DPL_DT_CLOSE_STRUCT, 0, 0, 0,                      /* END db        */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT, 0, 0, 0};


#define RPC_DD_USERINF_CHG_SIZE 8

static DPLDATAITEM aRpcDDUSERINF_CHG[RPC_DD_USERINF_CHG_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM, 0, sizeof(USERINF_CHG), 0,
     DPL_DT_OPEN_STRUCT, 0, sizeof(struct userinf), 0, /* BEGIN us    */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, 15, 0, 0,         /* us.username */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, 8, 0, 0,          /* us.userpass */
     DPL_DT_CHAR, 0, 0, 0,                             /* us.userpriv */
     DPL_DT_CLOSE_STRUCT, 0, 0, 0,                     /* END us      */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, DEVNAME_LEN, 0, 0, /* usdevice    */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT, 0, 0, 0};

#define RPC_DD_EM_CHG_SIZE 6

static DPLDATAITEM aRpcDDEM_CHG[RPC_DD_EM_CHG_SIZE] = {
     DPL_DT_OPEN_STRUCT | DO_FREE_MEM, 0, sizeof(EM_CHG), 0,
     DPL_DT_OPEN_STRUCT, 0, sizeof(struct extmodule), 0, /* BEGIN em   */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, 12, 0, 0,          /* em.emname  */
     DPL_DT_CLOSE_STRUCT, 0, 0, 0,                      /* END em     */
     DPL_DT_CHAR | DPL_DT_MOD_ARRAY, DEVNAME_LEN, 0, 0,  /* emdevice   */
     DPL_DT_CLOSE_STRUCT | DPL_DT_MOD_END_OF_STRUCT, 0, 0, 0};

#endif /* ADMRPCDD_H */

/*
$Header:   P:/PAT/INCLUDE/VCS/ADMRPCDD.H_V   1.10   07 Nov 1994 15:58:56   WAYNE  $
*/
