
                              README.ADS
        Windows, NT, and DOS386-Specific ADS and ARX Documentation

                           January 6, 1995


    This file includes documentation for supported compilers and other
    development tools for ADS and ARX for the Windows, NT, and DOS386
    platforms. This format enables us to update this documentation as
    development tools change and new tools become available.


========
Contents
========


0.0 - General Information/Warnings
1.0 - Supported compilers
  1.1 - ADS
  1.2 - ARX
2.0 - Supplied Sample files
  2.1 - ADS
  2.2 - ARX


DOS Specific
------------

3.0 - Building and debugging ADS programs for DOS386
  3.1 - Building ADS with Microsoft(R) Visual C++ version 1.1 (MSVC++)
  3.2 - Debugging ADS built with MSVC++ 1.1
  3.3 - Building ADS with MetaWare High C/C++(TM)
  3.4 - Debugging ADS built with High C/C++
  3.5 - Building ADS with Watcom(TM) C/C++
  3.6 - Debugging ADS built with Watcom C/C++

4.0 - Building and debugging ARX programs on the DOS386 platform
  4.1 - Building ARX
  4.2 - Debugging ARX


Windows Specific
----------------

5.0 - Building and debugging ADS programs for Windows
  5.1 - Building ADS with MSVC++ version 1.1
  5.2 - Debugging ADS using Codeview

6.0 - Building and debugging ARX programs on the Windows platform
  6.1 - Building ARX with MSVC++ version 1.1
  6.2 - Debugging ARX with Codeview


NT Specific
-----------

7.0 - Building and debugging ADS programs for NT
  7.1 - Building ADS with the MSVC++ 1.1 IDE
  7.2 - Building ADS with the MSVC++ 2.0 IDE
  7.3 - Debugging ADS with the MSVC++ 1.1 IDE
  7.4 - Debugging ADS with the MSVC++ 2.0 IDE

8.0 - Building and debugging ARX programs on the NT platform
  8.1 - Building ARX with the MSVC++ 1.1 IDE
  8.2 - Building ARX with the MSVC++ 2.0 IDE
  8.3 - Debugging ARX with the MSVC++ 1.1 IDE
  8.4 - Debugging ARX with the MSVC++ 2.0 IDE


====================================
0.0 GENERAL INFORMATION/WARNINGS
====================================

  - IMPORTANT WARNING:  The Phar Lap(R) TNT DOS-Extender(TM) currently
     used in AutoCAD Release 13 DOS386 does not support applications
     built with MSVC++ 2.0. So, MSVC++ 2.0 *CANNOT* be used to build
     ADS or ARX programs to work on the DOS386 platform.
     
     However, MSVC++ 2.0 can be used to build ADS and ARX programs for
     Windows and NT.

     Sometime after the initial release of AutoCAD R13,  Autodesk will
     update support for ARX to allow ARX programs built with MSVC++ 2.0
     to be used on the DOS386 platform.  However,  only MSVC++ 2.0 ARX
     programs that have been linked using a statically linked C runtime
     library (as opposed to using MSVCRT20.DLL) will work.

  - WARNING:  adsdef.h (#included in ads.h which is in turn #included
     in adslib.h) and winuser.h (#included in windows.h) both define X
     and Y, but differently. To avoid any problems, adsdef.h (or any
     header file that directly or indirectly #includes it) should be
     #included after any header files that directly or indirectly
     #include winuser.h. This will ensure that the correct X and Y
     definitions are used in all situations.

  - For the Windows and NT platforms there are debuggers available
    that are not documented in this file, but that may work for 
    debugging ADS programs in these environments. The following are
    some debuggers that have been used successfully at times during
    the AutoCAD development cycle. Autodesk does not in any way 
    endorse these debuggers nor does it supply any help in using them.

      BoundsChecker from Nu-Mega (NT and Windows)
      Win-Ice from Nu-Mega (Windows only)
      wdeb386 from Microsoft (Windows only)
      windbg and ntsd from Microsoft

  - Currently the Microsoft Visual C++ version 2.0 compiler and linker
    can only be used under the NT 3.5 operating system environment.
    
  - AutoCAD's ADS code must have byte structure alignment. In all the
    sample makefiles and batch files, as well as the MSVC++ IDE setup
    in this document file, this is accomplished by explicitly setting
    structure alignment to 1 globally for all code compiled.

    There is a #define available called "RADPACK" which, when set,
    causes all AutoCAD ADS specific code that needs to be byte
    aligned to be made so. Using this #define on the compile line 
    allows you to use other alignment for non-ADS portions of
    your code while retaining byte alignment where needed by ADS.

=======================
1.0 SUPPORTED COMPILERS
=======================


  1.1 - ADS
  ---------

    The following compilers are supported for DOS386 ADS:

    - Microsoft Visual C++ (MSVC++) 32-bit Version 1.1

    - MetaWare High C/C++ Version 3.21

    - Watcom C/C++ Version 10.0

    MSVC++ and MetaWare High C/C++ require the use of the linker provided
    in Phar Lap TNT DOS-Extender SDK 6.1


    The following compilers are supported for Windows and Windows NT(TM)

    - Microsoft Visual C++ (MSVC++) 32-bit Version 1.1

    - Microsoft Visual C++ (MSVC++) 32-bit Version 2.0


  1.2 - ARX
  ---------

    The following compilers are supported for ARX ADS:

    - Microsoft Visual C++ (MSVC++) 32-bit Version 1.1

    - Microsoft Visual C++ (MSVC++) 32-bit Version 2.0 (Windows and NT only)

    For ARX ADS the Phar Lap TNT DOS-Extender SDK is not required.


=========================
2.0 SAMPLE FILES SUPPLIED
=========================


  2.1 - ADS
  ---------

   DOS386
   ------

    The batch and make files are distributed in the directory dos\ads\sample.
    This directory currently contains the following files:

      mkmsvc13.bat   Demonstrates how to build an R13 DOS ADS program
                     using 32-bit MSVC++ 1.1 command-line compiler, 
                     Phar Lap 6.1 TNT SDK, and the updated DOSADS.LIB
                     supplied in the ADS subdirectory.

      msvcsamp.bat   Builds the R13 DOS ADS sample programs using
                     32-bit MSVC++ 1.1 command-line compiler, Phar 
                     Lap 6.1 TNT SDK, and the updated DOSADS.LIB 
                     supplied in the ADS subdirectory.

      msvcdbg.bat    Uses Phar Lap's SB386.EXE debugger to debug an 
                     R13 ADS application built with 32-bit MSVC++ 

      hc3xsamp.bat   Builds the R13 DOS ADS sample programs, or a
                     single program of your choice, using MetaWare
                     High C/C++ 3.x and Phar Lap 6.1 TNT SDK.

      hc3xdbg.bat    Uses Phar Lap's SB386.EXE debugger to debug an R13 
                     ADS application built with MetaWare High C/C++ 3.x.

      mkwc100.bat    Demonstrates how to build an R13 ADS program using
                     the Watcom C/C++ 10.0 compiler and linker.

   Windows/NT
   ----------

    The batch and make files are distributed in the directory win\ads\sample.
    This directory currently contains the following files:

      mksamp.bat     Batch file to set up environment for building Windows 
                     ADS sample programs with the 32-bit MSVC++ command-line 
                     compiler. Requires NMAKE and the make file MKSAMP.NT. 

      mksamp.nt      Make file which uses the 32-bit MSVC++ 1.1 or greater
                     command-line compiler to build the Windows ADS sample 
                     executables. Use MKSAMP.BAT to run this make file.
                     This make file includes the MSVC++ standard make file
                     for Win32s, NTWIN32.MAK.
                   
      winads.bat     Batch file to set up environment for building Windows  
                     ADS programs with the 32-bit MSVC++ command-line 
                     compiler. Requires NMAKE and the make file WINADS.MAK.

      winads.mak     Make file which uses the 32-bit MSVC++ 1.1 or greater 
                     command-line compiler to build a Windows ADS executable. 
                     Use WINADS.BAT to run this make file.
                     This make file does *not* include NTWIN32.MAK.


  2.2 - ARX (DOS386, Windows, and NT)
  -------------------------------------

    The batch and make files are distributed in the directory
    common\arx\sample. This directory currently contains the following
    batch and make files:

      mkarx.bat      Batch file to set up environment for building ARX
                     programs with the 32-bit MSVC++ 1.1 command-line
                     compiler. Requires NMAKE and the make file MKARX.MAK.

      mkarx.mak      Make file which uses the 32-bit MSVC++ 1.1 command-
                     line compiler to build an ARX program as a Dynamic
                     Link Library. Use MKARX.BAT to run this make file.
                     This make file does *not* include NTWIN32.MAK.

      mksamp.bat     Batch file to set up environment for building the ARX
                     sample programs with the 32-bit MSVC++ 1.1 command-
                     line compiler. Requires NMAKE and the make file 
                     MKSAMP.MAK.

      mksamp.nt      Make file which uses the 32-bit MSVC++ 1.1 command-
                     line compiler to build the ARX sample programs as
                     Dynamic Link Libraries with an extension of .ARX.
                     Use MKSAMP.BAT to run this make file. This make file 
                     includes the MSVC++ standard make file for Win32s, 
                     NTWIN32.MAK.

    NOTE: ARX DLLs built on the DOS platform will also work on the Windows
      and NT platforms. The reverse is also true.


====================================================
3.0 BUILDING AND DEBUGGING ADS PROGRAMS FOR DOS386
====================================================


  3.1 - Building ADS with Microsoft Visual C++
  --------------------------------------------

    files:
      MVCADS13.LIB  (DOS386 ADS library for MSVC++ 32-bit and Phar Lap 6.1)
      DOSADS.LIB    (Updated Phar Lap library -- see note below)
      MVCADS13.LNK  (386LINK indirect command file)
      MKMSVC13.BAT  (Sample batch file to build an ADS program)

    R13 DOS386 ADS using the MSVC++ 32-bit compiler is essentially the same
    as the method used by Phar Lap for R12. The only difference is that the 
    ADS library and linker response file names are different. So, for more
    information take a look at the documentation on building ADS programs
    with MSVC++ that comes with Phar Lap 6.1 (just remember the file name 
    changes for R13).

    To use the MKMSVC13.BAT file to build an ADS program, you will need
    to edit the batch file to set the paths to match your particular
    machine's environment. The batch file is documented, so changing the
    settings should be fairly straight forward.

    To use the MKMSVC13.BAT file, at the DOS command line type:

        MKMSCV13 <filename>

    where <filename> is the name of your source file without the .C
    extension.

    For more information take a look at the batch file.

    NOTE: For MSVC++ ADS the Phar Lap library DOSADS.LIB is used. This
      library comes with Phar Lap 6.1, but the version of this library that
      came with the initial release of Phar Lap 6.1 has a problem that causes
      errors when multiple ADS programs are (xunload)ed in an order other
      than the reverse of the order they were (xload)ed. Phar Lap has fixed
      this problem and the newer DOSADS.LIB is included with this AutoCAD
      release.

      The DOSADS.LIB file is located in the LIB subdirectory of the Phar
      Lap SDK directory tree. So, for Phar Lap 6.1, you will need to copy
      the newer file supplied with AutoCAD over the file already present in
      this directory.


  3.2 Debugging ADS programs built with MSVC++
  --------------------------------------------

    Debugging an MSVC++ ADS program in AutoCAD R13 DOS386 is essentially
    the same as the technique described in the Phar Lap document
    "Developing AutoCAD ADS Applications with Microsoft Visual C++,
    32-Bit Edition". However, you will need to use the msvcdbg.bat file
    supplied with AutoCAD instead of the dbgads.bat file supplied with
    Phar Lap. The msvcdbg.bat file will use the ads.cmd file in the Phar
    Lap BIN directory.

    First you will need to modify the msvcdbg.bat file to set the DOS
    environment variables to match your system.

    Now you are ready to start up the msvcdbg.bat file. The normal syntax
    to start this batch file is:

        msvcdbg [appname] [add'l SB386 switches]

    If you have a dual screen monitor setup you should also use the
    -SWAPMON switch to tell SB386 to use both monitors:

        msvcdbg [appname] -swapmon [add'l SB386 switches]

    If you do this, be sure that you have AutoCAD configured to use only
    a single monitor.

    Once you have started the MSVCDBG.BAT file you should see AutoCAD
    start up on the primary monitor. At the AutoCAD "Command:" prompt, you
    should (xload) your ADS program.

    WARNING: If you are using the Vibrant display driver that ships with
      AutoCAD, be sure you do NOT have the text screen up in its "dialog"
      mode when you (xload) your program. If you do, the debugger's 
      screen may be completely corrupted, preventing you from properly using
      the debugger.

    As the ADS program is (xload)ed, an int 3 will be triggered in the ADS
    program's startup code and the debugger will gain control. The
    source window will show the assembly code for the ADS program's
    startup code. At this point you are in your ADS program so you can
    use debugger commands to set breakpoints, watch points etc. Most
    likely, though, you will want to execute a little more code to get to
    some point where you can see your program's source. To do this you
    will need to use the 'g' command with the name of some function or
    other symbol in your source.

    For example, FACT.C has a function called "funcload". The debugger
    command "g funcload" will cause a temporary breakpoint to be set at
    the start of the function "funcload" and then start FACT going again
    until the temporary breakpoint at the start of funcload is triggered.
    At this point you should see the source of FACT.C in the source
    window of the debugger with the current line being the last line to
    be executed before the funcload function is entered.

    Now you can set break points and watch points based on line numbers
    as well as symbol names. If you elected to use the -HOTKEY debugger
    switch (described in the MSVCDBG.BAT files as well as the SB386
    manual), then you can also use the <CTRL>-<ALT> key combination to
    return control to the debugger at any time at which point you can set
    break points, watch points, etc.


  3.3 Building ADS using MetaWare High C/C++ 3.2x
  -----------------------------------------------

    files:
      ADS.LIB       (R13 DOS386 ADS library for MetaWare High C/C++)
      HC3XSAMP.BAT  (Sample batch file to build an ADS program)

    The batch file HC3XSAMP.BAT in the SAMPLES directory shows the proper
    environment and switch settings to build an ADS program for AutoCAD
    DOS386 using MetaWare High C/C++ 3.2x and Phar Lap 6.1.

    The batch file will build all the sample files or a single user
    specified file if the file name (with no extension) is fed to the
    batch file as the first parameter.

    You will need to edit the batch file to set the paths to match your
    particular machine's environment. The batch file is documented, so
    changing the settings should be fairly straightforward.

    For more information take a look at the batch file.


  3.4 Debugging ADS built with MetaWare High C/C++ 3.2x
  -----------------------------------------------------

    You will need to use Phar Lap's SB386.EXE debugger. Currently
    MetaWare's MDB debugger will not work with AutoCAD Release 13. This
    may change in the future. Contact MetaWare for more information.

    To debug an ADS program, first build the program with full debug
    information. The sample batch file HC3XSAMP.BAT has a compile/link
    line that includes the -g compiler switch and the -fullsym linker
    switch that will build a program with full debug information:

        hc386 %1.c %hcopts% -Hpro=hcsamp.pro -g -Hkeep -Hldopt=-fullsym

    This line is commented out in the batch file so if you wish to use it
    you will need to comment out the standard build line:

        hc386 %1.c %hcopts% -Hpro=hcsamp.pro -Hkeep

    and then uncomment the debug compile line.

    Once the program is built, you can use the HC3XDBG.BAT batch file to
    start up the debugger and AutoCAD with the symbol table of your ADS
    program. The HC3XDBG.BAT batch file will need to be edited to update
    the paths to fit your machine's environment. For more information on
    this take a look in the batch file.

    Once the settings are correct, you can execute the batch file with
    the name of your program (without the extension) as the first
    parameter. This will start up the debugger; tell it to load your
    program's symbol table, and launch AutoCAD.

    Once started, the debugger will come up and stop, waiting for input.
    Type "g" followed by <CR> to get it started loading AutoCAD.
    Execution will again stop when the ACADAPP.EXP ADS program is loaded
    via the ACAD.ADS autoload mechanism triggering an int 3. At this
    point type "r eip eip+1" followed by <CR>. This will step past
    the int 3. Now type "g" and press <CR> to continue loading
    AutoCAD.

    When AutoCAD is fully loaded and at the "Command:" prompt you may
    (xload) your ADS program.

    WARNING: If you are using the Vibrant display driver that ships with
      AutoCAD, be sure you do NOT have the text screen up in its "dialog"
      mode when you (xload) your program. If you do, the debugger's 
      screen may be completely corrupted, preventing you from properly using
      the debugger.

    When your ADS program xloads, it will trigger an int 3 which will
    pass control back to the debugger. At the debugger command line, you
    must execute the command "r eip eip+1" to step past the int 3. At
    this point you will need to use the debugger's "t" command to step
    through the code one line at a time until you are in your ADS
    program's startup code. This will take about 54 "t"s. The number
    may be different for different revisions of the ADS startup code so
    it would be best to execute the "t" commands manually once to
    determine the exact number of executions of "t" required. Once you
    know the exact number, you can use "t xx" where "xx" is the number
    of "t" commands you wish to have executed.

    To do this manually:

    1) Execute "t" commands until you get to the first "CALL" instruction
       in the code shown in the debugger's source window. This should 
       take about six "t" commands.

    2) Execute more "t" commands until you get to the first "CALLF"
       instruction. This should take about forty-seven "t" commands.

    3) Execute one "t" command to step into the "CALLF".

    At this point, you are inside the startup code of your ADS program.

    Now you need to reset the locations of the code and data segment
    selectors for the symbol table for your program. To do this:

    1) Type in "xr c cs" followed by <CR> to relocate the code segment 
       selector.

    2) Type in "xr 14 ds" followed by <CR> to relocate the data segment 
       selector.

    At this point you can set break points, watch points, etc. You must
    set at least one breakpoint in your code that will be triggered in
    order to allow the debugger to regain control at some point. If you
    elected to use the -HOTKEY debugger switch (described in the HC3XDBG.BAT 
    file as well as the SB386 manual), then you can also use the <CTRL>-<ALT> 
    key combination to return control to the debugger at any time at which 
    point you can set break points, watch points, etc.


  3.5 Building ADS programs using Watcom 10.0
  -------------------------------------------

    files:

      WCADS100.LIB   (R13 DOS386 ADS library for Watcom 10.0)
      MKWC100.BAT    (Sample batch file to build an ADS program)

    Using the Watcom compiler to build ADS programs for R13 DOS386 is the
    same as it was in R12. What's supplied with AutoCAD is the library
    file and a sample batch file that will build an ADS program. This
    batch file is very simple, but it does demonstrate the commands and
    switches.

    You will need to edit the mkwc100.bat file to set the DOS environment
    variables to match your system.

    To use the mkwc100.bat  file, at the DOS command line type:

        MKWC100 <filename>

    where <filename> is the name of your source file without the .C
    extension.

    If you are working with C++, the WPP386 compiler must be used
    instead of WCC386 so you will need to change this in the MKWC100.BAT
    file.


  3.6 Debugging ADS built with Watcom C/C++
  -----------------------------------------

    Currently Watcom's debugger will not work with AutoCAD(R) Release 13.
    Watcom is working on this. Contact them for more information.


==================================================================
4.0 BUILDING AND DEBUGGING ARX PROGRAMS ON THE DOS 386 PLATFORM
==================================================================

  4.1 Building ARX .DLLs using MSVC++ 32-bit under DOS
  ----------------------------------------------------

    files:
      rxapi.lib  (ARX library of ADS functions)
      mkarx.bat  (Sample batch file to build an ARX program)
      mkarx.mak  (Make file used by mkarx.bat)

    It is possible to build working ARX DLLs outside of the NT
    environment. You will need to use the MSVC++ 1.1 32-bit command-
    line compiler and linker.

    The batch file mkarx.bat will set the necessary DOS environment
    variables and then launch nmake.exe telling it to use the mkarx.mak
    make file. You will need to change the mkarx.bat file so that the
    PATH and SET statements are correct for your machine before you use
    it.

    To use mkarx.bat you need to provide it with one parameter which is
    the filename of the .CPP file (not .CC as they are in the samples
    directory) you wish to compile into an ARX .DLL. For example, to build
    FACT.CPP type "MKARX FACT" at the DOS command line.

    For more information take a look at the comments in the mkarx.bat and
    mkarx.mak files.


  4.2 Debugging ARX programs using Codeview(TM)
  ---------------------------------------------

    <NOTE: Currently the Phar Lap version of Codeview will not work with
      AutoCAD(R) Release 13. Phar Lap is working on this problem. When
      a Codeview version that will work with AutoCAD(R) Release 13 is
      available the following information should apply.


    First, build your ARX program with full debug information.

    Now, start up Codeview with the following command line:

      CVW.EXE /L <path and name of ARX DLL>.DLL <path to ACAD.EXE>/ACAD.EXE

    The /L tells Codeview to load debug information for the .DLL named.
    The last file name on the command line is the application that Codeview
    will actually launch when you tell it to "Go". For a 50 line VGA display
    in the Codeview window you can add a "/50" to the command line. If you
    have a dual monitor setup you can add a "/2" to make Codeview use the
    monochrome monitor for its text display.

    Once Codeview is running and has loaded the DLL's debug information,
    it will halt waiting for input from you. At this point you need to
    open a source window from Codeview with your ARX program's source
    file in it. Within the source window you can select lines to be
    breakpoints and select variables to view.

    Once you have set your breakpoints, type "G" in the command window or
    pick "Go" from the "Run" pulldown or just press the "F5" key. When
    you do this, Codeview will start up AutoCAD.
    
    Once AutoCAD has initialized and is at the "Command:" prompt, you can
    (ARXLOAD) your ARX program. Don't forget to specify the .DLL
    extension. When your program has loaded and AutoCAD is back at the
    "Command:" prompt, go ahead and execute your program so that one of
    the breakpoints you set is triggered. When the breakpoint is
    triggered, the Codeview window should come to the front sitting at
    the breakpoint you've set.


===================================================================
5.0 BUILDING AND DEBUGGING ADS PROGRAMS ON THE WINDOWS PLATFORM
===================================================================

  5.1 Building ADS using MSVC++ 32-bit
  ------------------------------------

    files:

      winads.bat     Sample batch file to build a Windows ADS program.
                     Requires WINADS.MAK.
      winads.mak     Sample makefile for Windows ADS.

    To Build a Windows ADS program in Windows, you will need the
    MSVC++ 1.1 32-bit edition command line compiler.

    You will need to edit the DOS environment variable settings in the
    winads.bat file so that they are properly initialized for your system.

    Unless your ADS program contains Windows specific code that requires
    a .def and/or .rc file, you will not need any .def or .rc files as
    was necessary in AutoCAD Release 12 for Windows.

    To build your program: 
     1) Open a DOS window (or work directly from DOS).
     2) At the DOS command prompt, execute the WINADS batch file with the 
        name of your source file as a parameter. 

    For example, to build FACT.C you would use:

      WINADS fact

  
  5.2 - Debugging ADS using Codeview
  ----------------------------------

    First, build your ADS program with full debug information.

    Now start up AutoCAD.

    Now, start up Codeview. You can create an icon in one of your Program
    Manager groups that executes the command:

      CVW.EXE

    If this executable is not in your path, then you will also need to 
    include the path to its location:

      <path>\CVW.EXE

    You can add a "/50" to the command line to get 50 line VGA display in
    the Codeview window. If you have a dual monitor system a /2 on the 
    command line will cause Codeview to use the monochrome screen for its
    display with AutoCAD on the color screen.

    You might also wish to specify the working directory to be the location
    of your ADS program's source code and executable.

    Once Codeview is running, it will bring up a dialog that allows you to
    choose the .EXE you wish to run and debug. Once you have made your
    selection, the dialog will go away and Codeview will halt waiting for
    input from you. At this point you need to open a source window from
    Codeview with your ADS program's source file in it. Within the source
    window you can select lines to be breakpoints and select variables to
    view.

    Once you have set your breakpoints, type "G" in the command window or
    pick "Go" from the "Run" pulldown or just press the "F5" key. When you
    do this Codeview will start up your application.

    Now switch back to the AutoCAD window and (XLOAD) your ADS program.
    When your program has loaded and AutoCAD is back at the "Command:"
    prompt, go ahead and execute your program so that one of the
    breakpoints you set is triggered. When the breakpoint is triggered,
    the Codeview window should come to the front sitting at the breakpoint
    you've set. You're on your way.


=====================================================
6.0 BUILDING AND DEBUGGING ARX PROGRAMS IN WINDOWS
=====================================================

  6.1 - Building ARX with MSVC++ 1.1
  ----------------------------------

    To build an ARX program in the Windows environment you must use the
    DOS command line version of the MSVC++ 1.1 compiler and linker. The
    method is the same as that used in the DOS environment (see section
    4.1). In order to get a DOS prompt, you must work in a DOS window.


  6.2 Debugging ARX with Codeview
  -------------------------------
     
    First, build your ARX program with full debug information.
        
    Now we run into an interesting problem with Win32s and Codeview. If
    the program being debugged (acad.exe in this case) starts up a second
    program (in this case any ADS program in the acad.ads file), 
    Codeview will lockup and so will acad.exe. If the ADS programs
    specified in the acad.ads file are already running when AutoCAD tries
    to (xload) them, AutoCAD will just attach to the running ADS programs
    rather than trying to start them up again.
    
    So, using File manager (or icons you create yourself), you need to
    execute all the programs specified in the ACAD.ADS file. An unmodified
    ACAD.ADS will have the file ACADAPP.EXE specified in it. So, at the 
    very least you will need to execute this ADS program.
    
    Now, start up Codeview with the following command line:

      CVW.EXE /L <path and name of ARX DLL>.DLL <path to ACAD.EXE>\ACAD.EXE
    
    The /L tells Codeview to load debug information for the .DLL named.
    The last file name on the command line is the application that Codeview
    will actually launch when you tell it to "Go". For a 50-line VGA display
    in the Codeview window, you can add a "/50" to the command line. If you
    have a dual monitor setup you can add a "/2" to make Codeview use the
    monochrome monitor for its text display.
    
    To run Codeview you can create an icon with the command line above and
    specify the working directory to be the location of your ARX program's
    source code and .dll.
    
    Once Codeview is running and has loaded the DLL's debug info, it will
    halt, waiting for input from you. At this point you need to open a 
    source window from Codeview with your ARX program's source file in it.
    Within the source window you can select lines to be breakpoints and
    select variables to view.
    
    Once you have set your breakpoints, type "G" in the command window or
    pick "Go" from the "Run" pulldown or just press the "F5" key. When you
    do this Codeview will start up AutoCAD.

    Once AutoCAD has initialized and is at the "Command:" prompt, you can 
    (ARXLOAD) your ARX program. Don't forget to specify the .dll extension.
    When your program has loaded and AutoCAD is back at the "Command:"
    prompt, go ahead and execute your program so that one of the 
    breakpoints you set is triggered. When the breakpoint is triggered,
    the Codeview window should come to the front located at the breakpoint
    you've set.

================================================
7.0 BUILDING AND DEBUGGING ADS PROGRAMS FOR NT
================================================

  7.1 Building ADS with the MSVC++ 1.1 IDE
  ----------------------------------------

    Here are settings that have been found to work for the 32-bit
    edition of MSVC++ to build standard ADS applications under NT.

    Create a Project containing the .c or (.cpp), rc, and .def files for
    your program and the WINADS.LIB file provided in the ADS directory of
    AutoCAD. Standard ADS apps are Windows EXEs.

    NOTE: Unless your ADS program contains Windows specific code that
     requires a .def and/or .rc file, you will not need any .def or .rc
     files.

    Now here are the Options pulldown settings that work (other settings
    may work too, but these are what have been tested):

    Options
      Project
        Project Type                      =  Windows application (.exe)
        Use MFC                           -> not selected
        Compiler
          Code Generation
            CPU                           =  80386
            Calling Convention            =  C/C++ (_cdecl) *
            Struct member byte alignment  =  1
          Custom Options                  -> defaults
          Custom Options C++              -> defaults
          Debug Options                   -> defaults
          Browser Info                    -> defaults
          Optimization                    -> defaults
          Precompiled Headers             -> default (which is to use them)
          Preprocessor
            Symbols and macros to define  =  WIN=1, ADS=1, _X86_, _WINDOWS 
                                            (and NDEBUG or _DEBUG)
          The other options I left blank
          Runtime                         =  Single-threaded (LIBC.LIB)
        Linker
          Debug                           -> defaults
          Image Attributes                -> defaults (all empty)
          Input                           -> defaults
          Miscellaneous                   -> defaults
          Output
            Name of output file           =  <your file name>.EXE
        Resources                         -> defaults


  7.2 Building ADS with the MSVC++ 2.0 IDE
  ----------------------------------------

    Create a Project containing the .c or (.cpp), rc, and .def files for
    your program and the WINADS.LIB file provided in the ADS directory of
    AutoCAD. Standard ADS apps are Windows EXEs.

    NOTE: Unless your ADS program contains Windows specific code that
     requires a .def and/or .rc file, you will not need any .def or .rc
     files.

    To create a project:

      1)  From the "File" pulldown, select "New".
      2)  Select "Project" in the dialog that appears.
      3)  In the next dialog, enter your desired project name in the
          appropriate edit box. Select "Application" as the project type.
          Fill in the directory information as you desire. Then select
          "Create".
      4)  The "Project files" dialog appears next. Here you select the
          source (.c, .cpp, etc.), definition (.def), resource (.rc),
          and library (.lib) files to use in your project.
        
          For a standard "plain" ADS program you shouldn't need any .def
          or .rc files, but you will need to include your source files
          and the winads.lib file in the WIN\ADS directory.
      5)  When selection is done select "Close" to close this
          dialog box.

    Now it's time to set up the build environment.

      6) In the "Project" pulldown, select "Settings" to bring
          up the "Project Settings" dialog. Initially the "Settings for:"
          list box should have both "Win32 Debug" and "Win32 Release"
          highlighted so all setting changes will apply to both.
      7)  Select the "C/C++" tab to bring forward the compiler settings.
          Here are the categories and appropriate settings. Settings
          not shown can be left as the default values. Other
          settings may work, but these have been tested:

          General
            Preprocessor Definitions 
              -> add "WIN=1, ADS=1, _X86_" to the list
          Code Generation
            Struct Member Alignment -> 1 byte
          Precompiled Headers -> defaults are adequate
          Optimizations -> defaults are adequate
          C Language -> defaults are adequate
          C++ Language -> defaults are adequate
          Preprocessor
            Additional Include Directories -> add in the path to the
              \common\ads directory and any others you may wish
          Listing Files -> defaults are adequate

      8)  Now select the "Link" tab to bring forward the linker settings.
          Here are the categories and appropriate settings. Settings not
          shown can be left as the default values. Other settings may
          work, but these have been tested:

          General
            Output File Name -> If you want a name other than the project
              name then enter it here.

            NOTE: If you do specify a file name,  you *must* include an
              ".exe" extension. MSVC++ 2.0 will not do this automatically.

          Output -> defaults are adequate
          Input -> defaults are adequate
          Customize -> defaults are adequate
          Debug -> defaults are adequate

      9) That does it for the settings, so select the "OK" button to
         close the dialog.

    Now you're ready to build.


  7.3 Debugging ADS with the MSVC++ 1.1 IDE
  -----------------------------------------

    Build your ADS program with full debug information.
    
    Now set your breakpoints. To do this you need to have your source in
    the edit window (use File/Open to access the necessary source files).
    You then set the cursor on the line where you want a break point and then
    use the "Breakpoints" option in the "Debug" pulldown (or press the F9
    key) to set the breakpoint.
    
    Now, Use the "Go" option in the "Debug" pulldown to launch your ADS
    program. In the lower left corner of the MSVC++ window you should see
    the message that symbols are being loaded and then nothing more should
    happen -- the program is loaded, but it uses a hidden window so you
    can't see anything.
    
    Now start up AutoCAD (if it's not already running) and (xload) your
    program. Once AutoCAD is loaded, do whatever is necessary to run your
    application.

    When code execution reaches a breakpoint in your program, the MSVC++
    IDE window should come to the top and the line with the breakpoint
    should be highlighted.
    
    You can now set watches and do whatever else you wish for debugging.


  7.4 Debugging ADS with the MSVC++ 2.0 IDE
  -----------------------------------------

    Build your ADS program with full debug information.
    
    Now set your breakpoints. To do this you need to have your source in
    the edit window (use File/Open to access the necessary source files).
    You then set the cursor on the line where you want a break point and then
    use the "Breakpoints" option in the "Debug" pulldown (or press the F9
    key) to set the breakpoint.
    
    Now, Use the "Go" option in the "Debug" pulldown to launch your ADS
    program. In the lower left corner of the MSVC++ window you should see
    the message that symbols are being loaded, the "Locals for" window
    should appear, and the "debug" toolbar should appear. At this point
    the program is loaded, but it uses a hidden window so you can't see
    anything.
    
    Now start up AutoCAD (if it's not already running) and (xload) your
    program. Once AutoCAD is loaded do whatever is  necessary to run your
    application.

    When code execution reaches a breakpoint in your program, the MSVC++
    IDE window should come to the top, and the line with the breakpoint
    should have a yellow arrow to the left of it, indicating a triggered
    breakpoint.
    
    You can now set watches and do whatever else you wish for debugging.


==========================================================
8.0 Building and debugging ARX programs on the NT platform
==========================================================

  8.1 Building ARX with the MSVC++ 1.1 IDE
  ----------------------------------------

    Here are the settings that have been found to work for the 32-bit
    edition of MSVC++ to build ARX applications under NT.

    NOTES: MSVC++'s IDE will create only a .dll, not an .arx (the default
           for ARX). So, when (arxload)ing the file into AutoCAD you will
           need to add the extension .dll to the file name:

                            (arxload "fact.dll")

           or you can manually rename or copy the created .DLL to a .ARX
           before you (arxload) it into AutoCAD.
  
    Create a Project containing the .cpp and .def files for your program
    and the rxapi.lib file provided in the ACRX\LIB directory of AutoCAD.
    ARX applications are Dynamic-link libraries.

    Now here are the Options pulldown settings that work (other settings
    will probably work too, but these are what have been tried):

    Options
      Project
        Project Type                      =  Dynamic-link library (.DLL)
        Use MFC                           -> not selected
        Compiler
          Code Generation
            CPU = 80386
            Calling Convention            =  C/C++ (_cdecl) *
          Custom Options                  -> defaults
          Custom Options C++              -> defaults
          Debug Options                   -> defaults
          Browser Info                    -> defaults
          Optimization                    -> defaults
          Precompiled Headers             -> default (which is to use them)
          Preprocessor
            Symbols and macros to define  =  RADPACK, ACRXAPP, _X86_ 
                                            (and NDEBUG or _DEBUG)
          The other options I left blank
          Runtime                         =  Multi-threaded (LIBCMT.LIB)
        Linker
          Debug                           -> defaults
          Image Attributes
            Stack allocations             -> defaults
            Base Address                  =  1c000000
            Entry point symbol            =  DllEntryPoint@12
          Input                           -> defaults
          Miscellaneous                   -> defaults
          Output
            Name of output file           =  <your file name>.DLL
                (NOTE: Specifying the extension .arx here will
                       be ignored.)
        Resources                         -> defaults


  8.2 Building ARX with the MSVC++ 2.0 IDE
  ----------------------------------------

    Create a Project containing the .cpp and .def files for your program
    and the rxapi.lib file provided in the ACRX\LIB directory of AutoCAD.
    ARX applications are Dynamic-link libraries.

    To create a project:

      1)  From the "File" pulldown, select "New".
      2)  Select "Project" in the dialog that appears.
      3)  In the next dialog, enter your desired project name in the
          appropriate edit box. Select "Dynamic Link Library" as the
          project type. Fill in the directory information as you desire.
          Then select "Create".
      4)  The "Project files" dialog appears next. Here you select the
          source (.cpp), definition (.def), resource (.rc), and library
          (.lib files to use in your project.
        
          For a "plain" ARX ADS program you shouldn't need any .rc files,
          but you will need to include your source files, a .def file
          (take a look at the sample RXADS files for examples of source
          and .def files), and the rxapi.lib file in the COMMON\ACRX\LIB
          directory.
      5)  When selection is done select "Close" to close this
          dialog box.

    Now it's time to set up the build environment.

      6)  In the "Project" pulldown, select "Settings" to bring
          up the "Project Settings" dialog. Initially the "Settings for:"
          list box should have both "Win32 Debug" and "Win32 Release"
          highlighted so all setting changes will apply to both.
      7)  Select the "C/C++" tab to bring forward the compiler settings.
          Here are the categories and appropriate settings. Settings
          not shown can be left as the default values. Other
          settings may work, but these have been tested:

          General
            Preprocessor Definitions -> add "RADPACK, ACRXAPP, _X86_" to
              the list
          Code Generation -> defaults are adequate
          Precompiled Headers -> defaults are adequate
          Optimizations -> defaults are adequate
          C Language -> defaults are adequate
          C++ Language -> defaults are adequate
          Preprocessor
            Additional Include Directories -> add in the path to the
              \common\ads and \common\acrx\inc directories and any
              others you may wish
          Listing Files -> defaults are adequate

      8)  Now select the "Link" tab to bring forward the linker settings.
          Here are the categories and appropriate settings. Settings not
          shown can be left as the default values. Other settings may
          work, but these have been tested:

          General
            Output File Name -> enter the desired name. If you use an
              extension other than .dll,  MSVC++ 2.0 will use it
              (unlike MSVC++ 1.1 which ignored the extension). We
              recommend that you use the extension .ARX because this
              is the default extension that AutoCAD will use for ARX
              applications.

            NOTE: MSVC++ 2.0 will not automatically place an extension
              on the final DLL file. So, if you do not include an
              extension then there will be no extension on the final
              DLL file.

          Output
            Base Address -> 1c000000
            Entry-Point Symbol -> DllEntryPoint@12
          Input -> defaults are adequate
          Customize -> defaults are adequate
          Debug -> defaults are adequate

      9) That does it for the settings, so select "OK" to
         close the dialog.

    Now you're ready to build.

    
  8.3 Debugging ARX with the MSVC++ 1.1 IDE
  -----------------------------------------
    
    Create the ARX .dll with full debug information in the compile and
    link.

    In the Options pulldown, select "Debug" to bring up the
    Debug dialog. Fill in the "Calling Program" edit box with the path
    and name of the acad.exe file (for example f:\r13\acad.exe). Leave the
    "Additional DLLs" edit box blank. Select "OK" to close the
    dialog.

    Now set your breakpoints. To do this you need to have your source in
    an edit window (use File/Open to access the necessary source files).
    You then set the cursor on the line you want a breakpoint and then
    use the "Breakpoints" option in the "Debug" pulldown (or press the F9
    key) to set the breakpoint.

    Now, Use the "Go" option in the "Debug" pulldown to launch AutoCAD.
    A dialog will appear informing you that acad.exe doesn't contain debug
    information and asking if you want to continue. You do so select
    "Yes". Once AutoCAD has fully initialized to its "Command:"
    prompt, you can (arxload "<myapp>.dll) to load your application.
    Note that the .dll is necessary since MSVC++ will create only a .dll
    and AutoCAD's (ARXLOAD) default extension is .arx.

    At this point, if you have no breakpoints in your program's
    initialization code, AutoCAD should load your program and come back
    to the "Command:" prompt. Now do whatever you normally would to
    execute your program. When code execution reaches your program, the
    MSVC++ IDE should come to the top and you should be at your first
    breakpoint.
    
    You can now set watches and do whatever else you wish for debugging.

    
  8.4 Debugging ARX with the MSVC++ 2.0 IDE
  -----------------------------------------
    
    Create the ARX .DLL with full debug information in the compile and
    link.

    In the "Project" pulldown select "Settings" to bring up the
    "Project Settings" dialog. Click on the "Debug" tab to bring the debug
    settings forward. Here are the three important settings:

      Executable For Debug Session -> This needs to be set to the path and
        file name of the acad.exe file (for example f:\r13\win\acad.exe).

      Working Directory -> This needs to be set to the path to the directory
        you want to be current during the debugging session.

      Program Arguments -> This is where you specify any AutoCAD command
        line arguments (for example, a drawing file name and/or a script
        file name or perhaps the /c argument with the location of your
        acad.cfg and acad.ini files).
    When you are done, select "OK" to close the dialog.

    Now set your breakpoints. To do this you need to have your source in
    an edit window (use File/Open to access the necessary source files).
    You then set the cursor on the line you want a breakpoint and then
    use the "Breakpoints" option in the "Debug" pulldown (or press the F9
    key) to set the breakpoint.

    Now, Use the "Go" option in the "Debug" pulldown to launch AutoCAD.
    A dialog will appear informing you that ACAD.EXE doesn't contain debug
    information and asking if you want to continue. You do, so select
    "Yes". Once AutoCAD has fully initialized to its "Command:"
    prompt, you can (arxload "<myapp>") to load your application.
    
    NOTE: If your ARX DLL has a file extension other than .arx then you
      will need to specify the extension in the (ARXLOAD) function call.
      For example, if your program is myapp.dll then you would need to use
      
        (arxload "myapp.dll")
        
      to load the program in AutoCAD.

    At this point, if you have no breakpoints in your program's
    initialization code, AutoCAD should load your program and come back
    to the "Command:" prompt. Now do whatever you normally would to
    execute your program. When code execution reaches your program the
    MSVC++ IDE should come to the top and you should be at your first
    breakpoint.
    
    You can now set watches and do whatever else you wish for debugging.


