                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Restore control to the system heap routines. Version T1.0.

* ASSOCIATED FILES
GRABHEAP.PAS
GRABHEAP.TPU
TESTGRAB.EXE
TESTGRAB.PAS

* KEYWORDS
PASCAL V4.0 UNIT HEAP

==========================================================================
}
  {$R-,S-,B-,F-}
  unit GrabHeap;

  interface

  procedure CustomHeapControl(GetPtr, FreePtr : Pointer);
    {-Give control of GetMem, New, FreeMem, Dispose to specified procedures}

  procedure SystemHeapControl;
    {-Restore control to the system heap routines}

    {===============================================================}

  implementation

  type
    Xfer = record
             Instr : Byte;
             Addr : Pointer;
           end;
  var
    P : ^Byte;
    GetMemPtr : ^Xfer;
    FreeMemPtr : ^Xfer;
    GetSave : Xfer;
    FreeSave : Xfer;

    procedure CustomHeapControl(GetPtr, FreePtr : Pointer);
    var
      X : Xfer;
    begin
      with X do begin
        Instr := $EA;  {JMP FAR}
        Addr := GetPtr;
        GetMemPtr^ := X;
        Addr := FreePtr;
        FreeMemPtr^ := X;
      end;
    end;

    procedure SystemHeapControl;
    begin
      GetMemPtr^ := GetSave;
      FreeMemPtr^ := FreeSave;
    end;

    function FindFarProcCall : Pointer;
      {-Return pointer to far procedure called just previously}
    inline
    ($E8/$00/$00/  {  call next}
     $5F/          {next:  pop  di}
     $0E/          {  push cs}
     $07/          {  pop  es}
     $83/$EF/$07/  {  sub  di,7}
     $26/$C4/$05/  {  les  ax,es:[di]}
     $8C/$C2);     {  mov  dx,es}

  begin
    {Find GetMem and FreeMem in SYSTEM}
    New(P);
    GetMemPtr := FindFarProcCall;
    Dispose(P);
    FreeMemPtr := FindFarProcCall;
    {Save the first 5 bytes of each routine, which will be overwritten}
    GetSave := GetMemPtr^;
    FreeSave := FreeMemPtr^;
  end.

