                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EMSHEAP.

* ASSOCIATED FILES
EMSHEAP.PAS
EMSHEAP.ASM
EMSHEAP.OBJ
EMSHEAP.TPU
GETEMSP.PAS
TESTHEAP.EXE
TESTHEAP.PAS


* KEYWORDS
PROGRAM PASCAL SOURCE V4.0

==========================================================================
}
  {$IFDEF UsePascal}
  procedure TouchPage(PP : Word);
    {-Touch physical page PP}
  begin
    if TimeCount < $FFFF then begin
      Inc(TimeCount);
      PageMap[PP].Touched := TimeCount;
    end else begin
      {Wraparound - reset all pages}
      TimeCount := 0;
      for PP := 0 to MaxPP do
        PageMap[PP].Touched := 0;
    end;
  end;

  function GetEmsP(P : Pointer) : Pointer;
    {-Return physical pointer for an EMS pointer}
  var
    PP : Word;
    Oldest : Word;
    OldPP : Word;
    Segm : Word;
  begin
    with EmsPtr(P) do begin
      {Is requested page already mapped?}
      Segm := FrameSeg;
      Oldest := $FFFF;
      OldPP := 0;
      for PP := 0 to MaxPP do
        with PageMap[PP] do
          if PageNum = LogicalPage then begin
            {Already mapped, return physical pointer}
            GetEmsP := Ptr(Segm, PageOfs);
            TouchPage(PP);
            Exit;
          end else begin
            if Touched < Oldest then begin
              {Retain oldest page}
              Oldest := Touched;
              OldPP := PP;
            end;
            Inc(Segm, PageSize shr 4);
          end;

      {Remap least recently used page}
      if MapEmsPage(Handle, PageNum, OldPP) then begin
        PageMap[OldPP].LogicalPage := PageNum;
        TouchPage(OldPP);
        GetEmsP := Ptr(FrameSeg+OldPP*(PageSize shr 4), PageOfs);
      end else begin
        Error(EmsMapError);
        GetEmsP := nil;
      end;
    end;
  end;
  {$ENDIF}


