                       F i l e    I n f o r m a t i o n

* DESCRIPTION
A single routine that attempts to classify the type of disk installed in a
specified drive. It recognizes all of the most common disk types. An
undocumented DOS function ($32) is used therefore some measure of caution
should be used. Author: TurboPower Software. Version 1.0.

* ASSOCIATED FILES
DRIVE.PAS
DRIVE.DOC


* KEYWORDS
PROGRAM PASCAL SOURCE READ DISK TYPE

==========================================================================
}
{*********************************************************}
{*                     DRIVE.PAS 1.0                     *}
{*                by TurboPower Software                 *}
{*********************************************************}

program ClassifyDrives;

uses
  Dos;

  {-------------------------------------------------------------------}

type
  DiskClass = (
    Floppy360, Floppy720, Floppy12, Floppy144, OtherFloppy, Bernoulli,
    HardDisk, RamDisk, SubstDrive, UnknownDisk, InvalidDrive);

  function GetDiskClass(Drive : Char; var SubstDriveChar : Char) : DiskClass;
    {-Return the disk class for the drive with the specified letter}
    {-This routine uses an undocumented DOS function ($32). Information about
      this function was obtained from Terry Dettmann's DOS Programmer's
      Reference (Que, 1988).}
  type
    ParamBlock =
      record
        DriveNumber, DeviceDriverUnit : Byte;
        BytesPerSector : Word;
        SectorsPerCluster, ShiftFactor : Byte;
        ReservedBootSectors : Word;
        FatCopies : Byte;
        RootDirEntries, FirstDataSector, HighestCluster : Word;
        SectorsPerFat : Byte;
        RootDirStartingSector : Word;
        DeviceDriverAddress : Pointer;
        Media2and3 : Byte; {media descriptor here in DOS 2.x and 3.x}
        Media4 : Byte;     {media descriptor here in DOS 4.x}
        NextDeviceParamBlock : Pointer;
      end;
    ParamBlockPtr = ^ParamBlock;
  var
    DriveNum : Byte;
    MediaDescriptor : Byte;
    Regs : Registers;
  begin
    {assume failure}
    GetDiskClass := InvalidDrive;

    {assume that this is not a SUBSTituted drive}
    SubstDriveChar := Drive;

    {convert drive letter to drive number}
    Drive := Upcase(Drive);
    case Drive of
      'A'..'Z' : DriveNum := Ord(Drive)-$40;
      else Exit;
    end;

    with Regs do begin
      {get pointer to media descriptor byte}
      AH := $1C;
      DL := DriveNum;
      MsDos(Regs);
      MediaDescriptor := Mem[DS:BX];

      {get pointer to drive parameter block}
      AH := $32;
      DL := DriveNum;
      MsDos(Regs);

      {drive invalid if AL = $FF}
      if (AL = $FF) then
        Exit;

      with ParamBlockPtr(Ptr(DS,BX))^ do begin
        {check for SUBSTituted drive}
        if (DriveNumber <> Pred(DriveNum)) then begin
          GetDiskClass := SubstDrive;
          SubstDriveChar := Char(Ord('A')+DriveNumber);
        end
        else if (FatCopies = 1) then
          {RAM disks have one copy of File Allocation Table}
          GetDiskClass := RamDisk
        else if (MediaDescriptor = $F8) then
          {MediaDescriptor of $F8 indicates hard disk}
          GetDiskClass := HardDisk
        else if (MediaDescriptor = $FD) and (SectorsPerFat <> 2) then
          {Bernoulli drives have more than 2 sectors per FAT}
          GetDiskClass := Bernoulli
        else if (MediaDescriptor >= $F9) then
          {media descriptors >= $F9 are for floppy disks}
          case HighestCluster of
             355 : GetDiskClass := Floppy360;
             714,
            1423 : GetDiskClass := Floppy720;
            2372 : GetDiskClass := Floppy12;
            else   GetDiskClass := OtherFloppy;
          end
        else if (MediaDescriptor = $F0) and (HighestCluster = 2848) then
          {it's a 1.44 meg floppy}
          GetDiskClass := Floppy144
        else
          {unable to classify disk/drive}
          GetDiskClass := UnknownDisk;
      end;
    end;
  end;

  {-------------------------------------------------------------------}

var
  Disk, SubstDisk : Char;
const
  DiskClasses : array[DiskClass] of string[34] = (
    '360K floppy', '720K floppy', '1.2 meg floppy', '1.44 meg floppy',
    'unknown floppy', 'Bernoulli drive', 'hard disk', 'RAM disk',
    'SUBSTituted drive', 'unknown disk type', 'invalid drive (or not ready)');
begin
  for Disk := 'A' to 'J' do begin
    Write('Drive ', Disk, ' is a ', DiskClasses[GetDiskClass(Disk, SubstDisk)]);
    if SubstDisk <> Disk then
      Write(' (actual drive, ', SubstDisk, ', is a ',
        DiskClasses[GetDiskClass(SubstDisk, SubstDisk)], ')');
    WriteLn;
  end;
end.

