{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROCEDURE  PrintNameAddressListing;

(* This module provides the user with a listing of the names, addresses,
   pledges, and assigned envelope numbers for the entire set of numbers
   for the year.  To be printed on continuous feed paper.

   For TURBO Pascal Version 4.0.     Last Revision:  April 12, 1988     *)

TYPE
  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

VAR
  Contributions           : FILE of ContributionsRecord;
  Offerings               : ContributionsRecord;
  FileName                : DOSString;
  ErrorCheck              : BYTE;
  Index,
  TotalEnvelopes          : LONGINT;
  Choice                  : CHAR;

BEGIN
  ClrScr;
  CursorOff;
  DrawDoubleLineBox (16,2,65,7);
  GoToXY (30,4);
    Write ('Print a Listing of each');
  GoToXY (20,5);
    Write ('Name, Address, Pledge, and Envelope Number');
  GoToXY (16,10);
    Write ('Please give the name of the Contributions File that');
  GoToXY (16,11);
    Write ('you wish to open for Listing of this data: ');
  CursorOn;
  Readln (FileName);
  CursorOff;

  Assign (Contributions, FileName);
  {$I-}
  Reset (Contributions);
  {$I+}
  ErrorCheck := IOResult;

    IF ErrorCheck <> 0
      THEN
        BEGIN
          ErrorMessageTwo;

(* Repeat from the beginning if file name is not found due to typing error *)

          PrintNameAddressListing
        END
      ELSE
        BEGIN
          ClrScr;
          TotalEnvelopes := (FileSize (Contributions) - 1);
          GoToXY (11,10);
            Write ('Please press the Space Bar when you are');
            Write (' ready to Print Listing.');

          REPEAT
            FlushKeyBuffer;
            Choice := ReadKey
          UNTIL Choice = ' ';

          ClrScr;
          GoToXY (28,10);
            Write ('Printing.   Please wait .....');

          FOR Index := 1 TO TotalEnvelopes DO
            BEGIN
              Seek (Contributions, Index);
              Read (Contributions, Offerings);

              WITH Offerings DO
                BEGIN
                  Writeln (LST, Name);
                  Writeln (LST, Address);
                  Writeln (LST, CityStateZip);
                  Write (LST, 'Pledge: ', TotalPledge : 10 : 2);
                  Writeln (LST, '      Envelope Number: ', EnvelopeNumber);
                  Writeln (LST)
                END

            END;                              (* End of FOR loop *)

          Close (Contributions);
          ClrScr;
          Writeln (LST);
          Writeln (LST);
          Writeln (LST);
          Writeln (LST);
          GoToXY (32,15);
            Write ('Printing Completed!');
          Delay (3000);
          ClrScr
        END

END;                                      (* End of Listing module *)

(***************************************************************************)

